/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

public final class CstString
extends TypedConstant {
    public static final CstString EMPTY_STRING = new CstString("");
    private final String string;
    private final ByteArray bytes;

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i15 = 0; i15 < len; ++i15) {
            char c15 = string.charAt(i15);
            if (c15 != '\u0000' && c15 < '\u0080') {
                bytes[outAt] = (byte)c15;
                ++outAt;
                continue;
            }
            if (c15 < '\u0800') {
                bytes[outAt] = (byte)(c15 >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c15 & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c15 >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c15 >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c15 & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(ByteArray bytes) {
        int length = bytes.size();
        char[] chars = new char[length];
        int outAt = 0;
        int at4 = 0;
        while (length > 0) {
            char out;
            int v05 = bytes.getUnsignedByte(at4);
            switch (v05 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v05 == 0) {
                        return CstString.throwBadUtf8(v05, at4);
                    }
                    out = (char)v05;
                    ++at4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        return CstString.throwBadUtf8(v05, at4);
                    }
                    int v15 = bytes.getUnsignedByte(at4 + 1);
                    if ((v15 & 0xC0) != 128) {
                        return CstString.throwBadUtf8(v15, at4 + 1);
                    }
                    int value = (v05 & 0x1F) << 6 | v15 & 0x3F;
                    if (value != 0 && value < 128) {
                        return CstString.throwBadUtf8(v15, at4 + 1);
                    }
                    out = (char)value;
                    at4 += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        return CstString.throwBadUtf8(v05, at4);
                    }
                    int v15 = bytes.getUnsignedByte(at4 + 1);
                    if ((v15 & 0xC0) != 128) {
                        return CstString.throwBadUtf8(v15, at4 + 1);
                    }
                    int v25 = bytes.getUnsignedByte(at4 + 2);
                    if ((v15 & 0xC0) != 128) {
                        return CstString.throwBadUtf8(v25, at4 + 2);
                    }
                    int value = (v05 & 0xF) << 12 | (v15 & 0x3F) << 6 | v25 & 0x3F;
                    if (value < 2048) {
                        return CstString.throwBadUtf8(v25, at4 + 2);
                    }
                    out = (char)value;
                    at4 += 3;
                    break;
                }
                default: {
                    return CstString.throwBadUtf8(v05, at4);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(value) + " at offset " + Hex.u4(offset));
    }

    public CstString(String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        this.string = string.intern();
        this.bytes = new ByteArray(CstString.stringToUtf8Bytes(string));
    }

    public CstString(ByteArray bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        this.bytes = bytes;
        this.string = CstString.utf8BytesToString(bytes).intern();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CstString)) {
            return false;
        }
        return this.string.equals(((CstString)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    protected int compareTo0(Constant other) {
        return this.string.compareTo(((CstString)other).string);
    }

    public String toString() {
        return "string{\"" + this.toHuman() + "\"}";
    }

    @Override
    public String typeName() {
        return "utf8";
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    public String toHuman() {
        int len = this.string.length();
        StringBuilder sb5 = new StringBuilder(len * 3 / 2);
        block5: for (int i15 = 0; i15 < len; ++i15) {
            char c15 = this.string.charAt(i15);
            if (c15 >= ' ' && c15 < '\u007f') {
                if (c15 == '\'' || c15 == '\"' || c15 == '\\') {
                    sb5.append('\\');
                }
                sb5.append(c15);
                continue;
            }
            if (c15 <= '\u007f') {
                switch (c15) {
                    case '\n': {
                        sb5.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb5.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb5.append("\\t");
                        break;
                    }
                    default: {
                        int nextChar = i15 < len - 1 ? (int)this.string.charAt(i15 + 1) : 0;
                        boolean displayZero = nextChar >= 48 && nextChar <= 55;
                        sb5.append('\\');
                        for (int shift = 6; shift >= 0; shift -= 3) {
                            char outChar = (char)((c15 >> shift & 7) + 48);
                            if (outChar == '0' && !displayZero) continue;
                            sb5.append(outChar);
                            displayZero = true;
                        }
                        if (displayZero) continue block5;
                        sb5.append('0');
                        break;
                    }
                }
                continue;
            }
            sb5.append("\\u");
            sb5.append(Character.forDigit(c15 >> 12, 16));
            sb5.append(Character.forDigit(c15 >> 8 & 0xF, 16));
            sb5.append(Character.forDigit(c15 >> 4 & 0xF, 16));
            sb5.append(Character.forDigit(c15 & 0xF, 16));
        }
        return sb5.toString();
    }

    public String toQuoted() {
        return '\"' + this.toHuman() + '\"';
    }

    public String toQuoted(int maxLength) {
        String ellipses;
        String string = this.toHuman();
        int length = string.length();
        if (length <= maxLength - 2) {
            ellipses = "";
        } else {
            string = string.substring(0, maxLength - 5);
            ellipses = "...";
        }
        return '\"' + string + ellipses + '\"';
    }

    public String getString() {
        return this.string;
    }

    public ByteArray getBytes() {
        return this.bytes;
    }

    public int getUtf8Size() {
        return this.bytes.size();
    }

    public int getUtf16Size() {
        return this.string.length();
    }

    @Override
    public Type getType() {
        return Type.STRING;
    }
}

