/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code.form;

import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.InsnFormat;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstCallSiteRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.AnnotatedOutput;
import java.util.BitSet;

public final class Form35c
extends InsnFormat {
    public static final InsnFormat THE_ONE = new Form35c();
    private static final int MAX_NUM_OPS = 5;

    private Form35c() {
    }

    @Override
    public String insnArgString(DalvInsn insn) {
        RegisterSpecList regs = Form35c.explicitize(insn.getRegisters());
        return Form35c.regListString(regs) + ", " + insn.cstString();
    }

    @Override
    public String insnCommentString(DalvInsn insn, boolean noteIndices) {
        if (noteIndices) {
            return insn.cstComment();
        }
        return "";
    }

    @Override
    public int codeSize() {
        return 3;
    }

    @Override
    public boolean isCompatible(DalvInsn insn) {
        if (!(insn instanceof CstInsn)) {
            return false;
        }
        CstInsn ci4 = (CstInsn)insn;
        int cpi = ci4.getIndex();
        if (!Form35c.unsignedFitsInShort(cpi)) {
            return false;
        }
        Constant cst = ci4.getConstant();
        if (!(cst instanceof CstMethodRef || cst instanceof CstType || cst instanceof CstCallSiteRef)) {
            return false;
        }
        RegisterSpecList regs = ci4.getRegisters();
        return Form35c.wordCount(regs) >= 0;
    }

    @Override
    public BitSet compatibleRegs(DalvInsn insn) {
        RegisterSpecList regs = insn.getRegisters();
        int sz4 = regs.size();
        BitSet bits = new BitSet(sz4);
        for (int i15 = 0; i15 < sz4; ++i15) {
            RegisterSpec reg = regs.get(i15);
            bits.set(i15, Form35c.unsignedFitsInNibble(reg.getReg() + reg.getCategory() - 1));
        }
        return bits;
    }

    @Override
    public void writeTo(AnnotatedOutput out, DalvInsn insn) {
        int cpi = ((CstInsn)insn).getIndex();
        RegisterSpecList regs = Form35c.explicitize(insn.getRegisters());
        int sz4 = regs.size();
        int r05 = sz4 > 0 ? regs.get(0).getReg() : 0;
        int r15 = sz4 > 1 ? regs.get(1).getReg() : 0;
        int r25 = sz4 > 2 ? regs.get(2).getReg() : 0;
        int r35 = sz4 > 3 ? regs.get(3).getReg() : 0;
        int r45 = sz4 > 4 ? regs.get(4).getReg() : 0;
        Form35c.write(out, Form35c.opcodeUnit(insn, Form35c.makeByte(r45, sz4)), (short)cpi, Form35c.codeUnit(r05, r15, r25, r35));
    }

    private static int wordCount(RegisterSpecList regs) {
        int sz4 = regs.size();
        if (sz4 > 5) {
            return -1;
        }
        int result = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            RegisterSpec one = regs.get(i15);
            result += one.getCategory();
            if (Form35c.unsignedFitsInNibble(one.getReg() + one.getCategory() - 1)) continue;
            return -1;
        }
        return result <= 5 ? result : -1;
    }

    private static RegisterSpecList explicitize(RegisterSpecList orig) {
        int sz4;
        int wordCount = Form35c.wordCount(orig);
        if (wordCount == (sz4 = orig.size())) {
            return orig;
        }
        RegisterSpecList result = new RegisterSpecList(wordCount);
        int wordAt = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            RegisterSpec one = orig.get(i15);
            result.set(wordAt, one);
            if (one.getCategory() == 2) {
                result.set(wordAt + 1, RegisterSpec.make(one.getReg() + 1, Type.VOID));
                wordAt += 2;
                continue;
            }
            ++wordAt;
        }
        result.setImmutable();
        return result;
    }
}

