/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.rop.cst.CstType;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.Hex;

public final class CatchHandlerList
extends FixedSizeList
implements Comparable<CatchHandlerList> {
    public static final CatchHandlerList EMPTY = new CatchHandlerList(0);

    public CatchHandlerList(int size) {
        super(size);
    }

    public Entry get(int n15) {
        return (Entry)this.get0(n15);
    }

    @Override
    public String toHuman() {
        return this.toHuman("", "");
    }

    public String toHuman(String prefix, String header) {
        StringBuilder sb5 = new StringBuilder(100);
        int size = this.size();
        sb5.append(prefix);
        sb5.append(header);
        sb5.append("catch ");
        for (int i15 = 0; i15 < size; ++i15) {
            Entry entry = this.get(i15);
            if (i15 != 0) {
                sb5.append(",\n");
                sb5.append(prefix);
                sb5.append("  ");
            }
            if (i15 == size - 1 && this.catchesAll()) {
                sb5.append("<any>");
            } else {
                sb5.append(entry.getExceptionType().toHuman());
            }
            sb5.append(" -> ");
            sb5.append(Hex.u2or4(entry.getHandler()));
        }
        return sb5.toString();
    }

    public boolean catchesAll() {
        int size = this.size();
        if (size == 0) {
            return false;
        }
        Entry last = this.get(size - 1);
        return last.getExceptionType().equals(CstType.OBJECT);
    }

    public void set(int n15, CstType exceptionType, int handler) {
        this.set0(n15, new Entry(exceptionType, handler));
    }

    public void set(int n15, Entry entry) {
        this.set0(n15, entry);
    }

    @Override
    public int compareTo(CatchHandlerList other) {
        if (this == other) {
            return 0;
        }
        int thisSize = this.size();
        int otherSize = other.size();
        int checkSize = Math.min(thisSize, otherSize);
        for (int i15 = 0; i15 < checkSize; ++i15) {
            Entry otherEntry;
            Entry thisEntry = this.get(i15);
            int compare = thisEntry.compareTo(otherEntry = other.get(i15));
            if (compare == 0) continue;
            return compare;
        }
        if (thisSize < otherSize) {
            return -1;
        }
        if (thisSize > otherSize) {
            return 1;
        }
        return 0;
    }

    public static class Entry
    implements Comparable<Entry> {
        private final CstType exceptionType;
        private final int handler;

        public Entry(CstType exceptionType, int handler) {
            if (handler < 0) {
                throw new IllegalArgumentException("handler < 0");
            }
            if (exceptionType == null) {
                throw new NullPointerException("exceptionType == null");
            }
            this.handler = handler;
            this.exceptionType = exceptionType;
        }

        public int hashCode() {
            return this.handler * 31 + this.exceptionType.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                return this.compareTo((Entry)other) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(Entry other) {
            if (this.handler < other.handler) {
                return -1;
            }
            if (this.handler > other.handler) {
                return 1;
            }
            return this.exceptionType.compareTo(other.exceptionType);
        }

        public CstType getExceptionType() {
            return this.exceptionType;
        }

        public int getHandler() {
            return this.handler;
        }
    }
}

