/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.cst;

import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstInterfaceMethodRef;
import com.android.dx.rop.cst.CstInvokeDynamic;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstMethodHandle;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstProtoRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.StdConstantPool;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import java.util.BitSet;

public final class ConstantPoolParser {
    private final ByteArray bytes;
    private final StdConstantPool pool;
    private final int[] offsets;
    private int endOffset;
    private ParseObserver observer;

    public ConstantPoolParser(ByteArray bytes) {
        int size = bytes.getUnsignedShort(8);
        this.bytes = bytes;
        this.pool = new StdConstantPool(size);
        this.offsets = new int[size];
        this.endOffset = -1;
    }

    public void setObserver(ParseObserver observer) {
        this.observer = observer;
    }

    public int getEndOffset() {
        this.parseIfNecessary();
        return this.endOffset;
    }

    public StdConstantPool getPool() {
        this.parseIfNecessary();
        return this.pool;
    }

    private void parseIfNecessary() {
        if (this.endOffset < 0) {
            this.parse();
        }
    }

    private void parse() {
        int i15;
        this.determineOffsets();
        if (this.observer != null) {
            this.observer.parsed(this.bytes, 8, 2, "constant_pool_count: " + Hex.u2(this.offsets.length));
            this.observer.parsed(this.bytes, 10, 0, "\nconstant_pool:");
            this.observer.changeIndent(1);
        }
        BitSet wasUtf8 = new BitSet(this.offsets.length);
        for (i15 = 1; i15 < this.offsets.length; ++i15) {
            int offset = this.offsets[i15];
            if (offset == 0 || this.pool.getOrNull(i15) != null) continue;
            this.parse0(i15, wasUtf8);
        }
        if (this.observer != null) {
            for (i15 = 1; i15 < this.offsets.length; ++i15) {
                Constant cst = this.pool.getOrNull(i15);
                if (cst == null) continue;
                int offset = this.offsets[i15];
                int nextOffset = this.endOffset;
                for (int j15 = i15 + 1; j15 < this.offsets.length; ++j15) {
                    int off = this.offsets[j15];
                    if (off == 0) continue;
                    nextOffset = off;
                    break;
                }
                String human = wasUtf8.get(i15) ? Hex.u2(i15) + ": utf8{\"" + cst.toHuman() + "\"}" : Hex.u2(i15) + ": " + cst.toString();
                this.observer.parsed(this.bytes, offset, nextOffset - offset, human);
            }
            this.observer.changeIndent(-1);
            this.observer.parsed(this.bytes, this.endOffset, 0, "end constant_pool");
        }
    }

    private void determineOffsets() {
        int lastCategory;
        int at4 = 10;
        for (int i15 = 1; i15 < this.offsets.length; i15 += lastCategory) {
            this.offsets[i15] = at4;
            int tag = this.bytes.getUnsignedByte(at4);
            try {
                switch (tag) {
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        lastCategory = 1;
                        at4 += 5;
                        break;
                    }
                    case 5: 
                    case 6: {
                        lastCategory = 2;
                        at4 += 9;
                        break;
                    }
                    case 7: 
                    case 8: {
                        lastCategory = 1;
                        at4 += 3;
                        break;
                    }
                    case 1: {
                        lastCategory = 1;
                        at4 += this.bytes.getUnsignedShort(at4 + 1) + 3;
                        break;
                    }
                    case 15: {
                        lastCategory = 1;
                        at4 += 4;
                        break;
                    }
                    case 16: {
                        lastCategory = 1;
                        at4 += 3;
                        break;
                    }
                    case 18: {
                        lastCategory = 1;
                        at4 += 5;
                        break;
                    }
                    default: {
                        throw new ParseException("unknown tag byte: " + Hex.u1(tag));
                    }
                }
                continue;
            }
            catch (ParseException ex4) {
                ex4.addContext("...while preparsing cst " + Hex.u2(i15) + " at offset " + Hex.u4(at4));
                throw ex4;
            }
        }
        this.endOffset = at4;
    }

    private Constant parse0(int idx, BitSet wasUtf8) {
        Constant cst = this.pool.getOrNull(idx);
        if (cst != null) {
            return cst;
        }
        int at4 = this.offsets[idx];
        try {
            int tag = this.bytes.getUnsignedByte(at4);
            switch (tag) {
                case 1: {
                    cst = this.parseUtf8(at4);
                    wasUtf8.set(idx);
                    break;
                }
                case 3: {
                    int value = this.bytes.getInt(at4 + 1);
                    cst = CstInteger.make(value);
                    break;
                }
                case 4: {
                    int bits = this.bytes.getInt(at4 + 1);
                    cst = CstFloat.make(bits);
                    break;
                }
                case 5: {
                    long value = this.bytes.getLong(at4 + 1);
                    cst = CstLong.make(value);
                    break;
                }
                case 6: {
                    long bits = this.bytes.getLong(at4 + 1);
                    cst = CstDouble.make(bits);
                    break;
                }
                case 7: {
                    int nameIndex = this.bytes.getUnsignedShort(at4 + 1);
                    CstString name = (CstString)this.parse0(nameIndex, wasUtf8);
                    cst = new CstType(Type.internClassName(name.getString()));
                    break;
                }
                case 8: {
                    int stringIndex = this.bytes.getUnsignedShort(at4 + 1);
                    cst = this.parse0(stringIndex, wasUtf8);
                    break;
                }
                case 9: {
                    int classIndex = this.bytes.getUnsignedShort(at4 + 1);
                    CstType type = (CstType)this.parse0(classIndex, wasUtf8);
                    int natIndex = this.bytes.getUnsignedShort(at4 + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex, wasUtf8);
                    cst = new CstFieldRef(type, nat);
                    break;
                }
                case 10: {
                    int classIndex = this.bytes.getUnsignedShort(at4 + 1);
                    CstType type = (CstType)this.parse0(classIndex, wasUtf8);
                    int natIndex = this.bytes.getUnsignedShort(at4 + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex, wasUtf8);
                    cst = new CstMethodRef(type, nat);
                    break;
                }
                case 11: {
                    int classIndex = this.bytes.getUnsignedShort(at4 + 1);
                    CstType type = (CstType)this.parse0(classIndex, wasUtf8);
                    int natIndex = this.bytes.getUnsignedShort(at4 + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex, wasUtf8);
                    cst = new CstInterfaceMethodRef(type, nat);
                    break;
                }
                case 12: {
                    int nameIndex = this.bytes.getUnsignedShort(at4 + 1);
                    CstString name = (CstString)this.parse0(nameIndex, wasUtf8);
                    int descriptorIndex = this.bytes.getUnsignedShort(at4 + 3);
                    CstString descriptor2 = (CstString)this.parse0(descriptorIndex, wasUtf8);
                    cst = new CstNat(name, descriptor2);
                    break;
                }
                case 15: {
                    Constant ref;
                    int kind2 = this.bytes.getUnsignedByte(at4 + 1);
                    int constantIndex = this.bytes.getUnsignedShort(at4 + 2);
                    switch (kind2) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            ref = (CstFieldRef)this.parse0(constantIndex, wasUtf8);
                            break;
                        }
                        case 5: 
                        case 8: {
                            ref = (CstMethodRef)this.parse0(constantIndex, wasUtf8);
                            break;
                        }
                        case 6: 
                        case 7: {
                            ref = this.parse0(constantIndex, wasUtf8);
                            if (ref instanceof CstMethodRef || ref instanceof CstInterfaceMethodRef) break;
                            throw new ParseException("Unsupported ref constant type for MethodHandle " + ref.getClass());
                        }
                        case 9: {
                            ref = (CstInterfaceMethodRef)this.parse0(constantIndex, wasUtf8);
                            break;
                        }
                        default: {
                            throw new ParseException("Unsupported MethodHandle kind: " + kind2);
                        }
                    }
                    int methodHandleType = ConstantPoolParser.getMethodHandleTypeForKind(kind2);
                    cst = CstMethodHandle.make(methodHandleType, ref);
                    break;
                }
                case 16: {
                    int descriptorIndex = this.bytes.getUnsignedShort(at4 + 1);
                    CstString descriptor3 = (CstString)this.parse0(descriptorIndex, wasUtf8);
                    cst = CstProtoRef.make(descriptor3);
                    break;
                }
                case 18: {
                    int bootstrapMethodIndex = this.bytes.getUnsignedShort(at4 + 1);
                    int natIndex = this.bytes.getUnsignedShort(at4 + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex, wasUtf8);
                    cst = CstInvokeDynamic.make(bootstrapMethodIndex, nat);
                    break;
                }
                default: {
                    throw new ParseException("unknown tag byte: " + Hex.u1(tag));
                }
            }
        }
        catch (ParseException ex4) {
            ex4.addContext("...while parsing cst " + Hex.u2(idx) + " at offset " + Hex.u4(at4));
            throw ex4;
        }
        catch (RuntimeException ex5) {
            ParseException pe5 = new ParseException(ex5);
            pe5.addContext("...while parsing cst " + Hex.u2(idx) + " at offset " + Hex.u4(at4));
            throw pe5;
        }
        this.pool.set(idx, cst);
        return cst;
    }

    private CstString parseUtf8(int at4) {
        int length = this.bytes.getUnsignedShort(at4 + 1);
        ByteArray ubytes = this.bytes.slice(at4 += 3, at4 + length);
        try {
            return new CstString(ubytes);
        }
        catch (IllegalArgumentException ex4) {
            throw new ParseException(ex4);
        }
    }

    private static int getMethodHandleTypeForKind(int kind2) {
        switch (kind2) {
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 8;
            }
        }
        throw new IllegalArgumentException("invalid kind: " + kind2);
    }
}

