/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.Map;
import java.util.function.Supplier;

class Compiler<E>
extends ContextAwareBase {
    Converter<E> head;
    Converter<E> tail;
    final Node top;
    final Map<String, Supplier<DynamicConverter>> converterMap;

    Compiler(Node top, Map<String, Supplier<DynamicConverter>> converterMap) {
        this.top = top;
        this.converterMap = converterMap;
    }

    Converter<E> compile() {
        this.tail = null;
        this.head = null;
        Node n15 = this.top;
        while (n15 != null) {
            switch (n15.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)n15.getValue()));
                    break;
                }
                case 2: {
                    CompositeNode cn4 = (CompositeNode)n15;
                    CompositeConverter<E> compositeConverter = this.createCompositeConverter(cn4);
                    if (compositeConverter == null) {
                        this.addError("Failed to create converter for [%" + String.valueOf(cn4.getValue()) + "] keyword");
                        this.addToList(new LiteralConverter("%PARSER_ERROR[" + String.valueOf(cn4.getValue()) + "]"));
                        break;
                    }
                    compositeConverter.setFormattingInfo(cn4.getFormatInfo());
                    compositeConverter.setOptionList(cn4.getOptions());
                    Compiler<E> childCompiler = new Compiler<E>(cn4.getChildNode(), this.converterMap);
                    childCompiler.setContext(this.context);
                    Converter<E> childConverter = childCompiler.compile();
                    compositeConverter.setChildConverter(childConverter);
                    this.addToList(compositeConverter);
                    break;
                }
                case 1: {
                    SimpleKeywordNode kn4 = (SimpleKeywordNode)n15;
                    DynamicConverter<E> dynaConverter = this.createConverter(kn4);
                    if (dynaConverter != null) {
                        dynaConverter.setFormattingInfo(kn4.getFormatInfo());
                        dynaConverter.setOptionList(kn4.getOptions());
                        this.addToList(dynaConverter);
                        break;
                    }
                    LiteralConverter errConveter = new LiteralConverter("%PARSER_ERROR[" + String.valueOf(kn4.getValue()) + "]");
                    this.addStatus(new ErrorStatus("[" + String.valueOf(kn4.getValue()) + "] is not a valid conversion word", this));
                    this.addToList(errConveter);
                }
            }
            n15 = n15.next;
        }
        return this.head;
    }

    private void addToList(Converter<E> c15) {
        if (this.head == null) {
            this.tail = c15;
            this.head = this.tail;
        } else {
            this.tail.setNext(c15);
            this.tail = c15;
        }
    }

    DynamicConverter<E> createConverter(SimpleKeywordNode kn4) {
        String keyword = (String)kn4.getValue();
        Supplier<DynamicConverter> supplier = this.converterMap.get(keyword);
        if (supplier != null) {
            return supplier.get();
        }
        this.addError("There is no conversion supplier registered for conversion word [" + keyword + "]");
        return null;
    }

    CompositeConverter<E> createCompositeConverter(CompositeNode cn4) {
        String keyword = (String)cn4.getValue();
        Supplier<DynamicConverter> supplier = this.converterMap.get(keyword);
        if (supplier != null) {
            try {
                return (CompositeConverter)supplier.get();
            }
            catch (ClassCastException e15) {
                this.addError("Failed to cast as CompositeConverter for keyword [" + keyword + "]", e15);
                return null;
            }
        }
        this.addError("There is no conversion class registered for composite conversion word [" + keyword + "]");
        return null;
    }
}

