/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.IThrowableRenderer;

public class DefaultThrowableRenderer
implements IThrowableRenderer<ILoggingEvent> {
    static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";

    @Override
    public void render(StringBuilder sbuf, ILoggingEvent event) {
        sbuf.append("<tr><td class=\"Exception\" colspan=\"6\">");
        for (IThrowableProxy tp4 = event.getThrowableProxy(); tp4 != null; tp4 = tp4.getCause()) {
            this.render(sbuf, tp4);
        }
        sbuf.append("</td></tr>");
    }

    @Override
    void render(StringBuilder sbuf, IThrowableProxy tp4) {
        this.printFirstLine(sbuf, tp4);
        int commonFrames = tp4.getCommonFrames();
        StackTraceElementProxy[] stepArray = tp4.getStackTraceElementProxyArray();
        for (int i15 = 0; i15 < stepArray.length - commonFrames; ++i15) {
            StackTraceElementProxy step = stepArray[i15];
            sbuf.append(TRACE_PREFIX);
            sbuf.append(Transform.escapeTags(step.toString()));
            sbuf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0) {
            sbuf.append(TRACE_PREFIX);
            sbuf.append("\t... ").append(commonFrames).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void printFirstLine(StringBuilder sb5, IThrowableProxy tp4) {
        int commonFrames = tp4.getCommonFrames();
        if (commonFrames > 0) {
            sb5.append("<br />").append("Caused by: ");
        }
        sb5.append(tp4.getClassName()).append(": ").append(Transform.escapeTags(tp4.getMessage()));
        sb5.append(CoreConstants.LINE_SEPARATOR);
    }
}

