/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.transform;

import java.util.Objects;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public final class SourceVariantData {
    private final String variantName;
    private final ImmutableAttributes attributes;

    public SourceVariantData(String variantName, ImmutableAttributes attributes) {
        this.variantName = variantName;
        this.attributes = attributes;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public String getFormattedVariantName() {
        int variantIdx = this.variantName.indexOf(" variant ");
        if (variantIdx == -1) {
            return this.variantName;
        }
        return this.variantName.substring(0, variantIdx + 9) + "'" + this.variantName.substring(variantIdx + 9) + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceVariantData that = (SourceVariantData)o;
        return Objects.equals(this.variantName, that.variantName) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.variantName);
        result = 31 * result + Objects.hashCode(this.attributes);
        return result;
    }
}

