/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.DouglasPeuckerMethod;
import tim.prune.function.compress.methods.DuplicatesMethod;
import tim.prune.function.compress.methods.NearbyDistMethod;
import tim.prune.function.compress.methods.NearbyFactorMethod;
import tim.prune.function.compress.methods.SingletonsMethod;
import tim.prune.function.compress.methods.SkiLiftsMethod;
import tim.prune.function.compress.methods.TooFastMethod;
import tim.prune.function.compress.methods.TooSlowMethod;
import tim.prune.function.compress.methods.TooSoonMethod;
import tim.prune.function.compress.methods.WackyPointsMethod;

public abstract class CompressionMethod {
    private boolean _active = false;

    public int preview(Track track, TrackDetails trackDetails, MarkingData markingData) {
        if (!this._active) {
            return 0;
        }
        TrackDetails trackDetails2 = trackDetails.modifyUsingMarkings(markingData);
        return this.compress(track, trackDetails2, markingData);
    }

    public void setActive(boolean bl) {
        this._active = bl;
    }

    public boolean isActive() {
        return this._active;
    }

    public abstract int compress(Track var1, TrackDetails var2, MarkingData var3);

    public String getTotalSettingsString() {
        return String.valueOf(this._active ? "x" : "o") + this.getSettingsString();
    }

    protected abstract String getSettingsString();

    public abstract CompressionMethodType getType();

    public abstract String getParam();

    public static CompressionMethod fromSettingsString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        CompressionMethod compressionMethod = CompressionMethod.fromSettingsSubstring(string.substring(1));
        if (compressionMethod != null) {
            compressionMethod.setActive(string.charAt(0) == 'x');
        }
        return compressionMethod;
    }

    private static CompressionMethod fromSettingsSubstring(String string) {
        if (string == null || string.length() < 3) {
            return null;
        }
        if (DuplicatesMethod.recogniseString(string)) {
            return new DuplicatesMethod();
        }
        if (NearbyFactorMethod.recogniseString(string)) {
            return new NearbyFactorMethod(string);
        }
        if (WackyPointsMethod.recogniseString(string)) {
            return new WackyPointsMethod(string);
        }
        if (SingletonsMethod.recogniseString(string)) {
            return new SingletonsMethod(string);
        }
        if (DouglasPeuckerMethod.recogniseString(string)) {
            return new DouglasPeuckerMethod(string);
        }
        if (NearbyDistMethod.recogniseString(string)) {
            return new NearbyDistMethod(string);
        }
        if (TooSlowMethod.recogniseString(string)) {
            return new TooSlowMethod(string);
        }
        if (TooFastMethod.recogniseString(string)) {
            return new TooFastMethod(string);
        }
        if (TooSoonMethod.recogniseString(string)) {
            return new TooSoonMethod(string);
        }
        if (SkiLiftsMethod.recogniseString(string)) {
            return new SkiLiftsMethod();
        }
        return null;
    }

    protected static boolean recogniseString(String string, CompressionMethodType compressionMethodType) {
        return string != null && string.startsWith(compressionMethodType.getKey());
    }

    public static boolean isPointDeleted(int n, MarkingData markingData) {
        return markingData != null && markingData.isPointMarkedForDeletion(n);
    }

    public static boolean isPointAtSegmentBoundary(int n, TrackDetails trackDetails, MarkingData markingData) {
        if (trackDetails != null && (trackDetails.isSegmentStart(n) || trackDetails.isSegmentEnd(n))) {
            return true;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (CompressionMethod.isPointDeleted(n2, markingData)) {
                if (markingData.isPointMarkedForSegmentBreak(n2)) {
                    return true;
                }
            } else if (!trackDetails.isWaypoint(n2)) {
                return false;
            }
            --n2;
        }
        return true;
    }

    protected static DataPoint getNextTrackPoint(Track track, int n, MarkingData markingData) {
        int n2 = n + 1;
        while (n2 < track.getNumPoints()) {
            DataPoint dataPoint = track.getPoint(n2);
            if (!dataPoint.isWaypoint() && !markingData.isPointMarkedForDeletion(n2)) {
                return dataPoint;
            }
            ++n2;
        }
        return null;
    }
}

