/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerAdapter;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

final class PossibleDelayedFunctionCreator
extends AnalyzerAdapter {
    PossibleDelayedFunctionCreator() {
        super("Function Start Search delayed", AnalysisPriority.DATA_ANALYSIS.after());
    }

    public boolean added(Program addedProgram, AddressSetView addedSet, TaskMonitor addedMonitor, MessageLog addedLog) throws CancelledException {
        AddressIterator addresses = addedSet.getAddresses(true);
        AddressSet functionStarts = new AddressSet();
        while (addresses.hasNext() && !addedMonitor.isCancelled()) {
            Address address = addresses.next();
            if (this.hasConditionalReferences(addedProgram, address)) continue;
            Function funcAt = addedProgram.getFunctionManager().getFunctionContaining(address);
            if (funcAt != null) {
                if (funcAt.getEntryPoint().equals((Object)address)) continue;
                BookmarkManager bookmarkManager = addedProgram.getBookmarkManager();
                bookmarkManager.setBookmark(address, "Analysis", this.getName() + " Overlap", "Function exists at probable good function start");
                continue;
            }
            functionStarts.add(address);
        }
        new CreateFunctionCmd((AddressSetView)functionStarts, false).applyTo(addedProgram, addedMonitor);
        return true;
    }

    private boolean hasConditionalReferences(Program addedProgram, Address address) {
        ReferenceIterator refsTo = addedProgram.getReferenceManager().getReferencesTo(address);
        while (refsTo.hasNext()) {
            Reference reference = refsTo.next();
            if (!reference.getReferenceType().isConditional()) continue;
            return true;
        }
        return false;
    }
}

