/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.annotations;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.annotations.AnnotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.AbstractModalGraphMouse;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicIconFactory;

public class AnnotatingModalGraphMouse<V, E>
extends AbstractModalGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;
    protected RenderContext<V, E> rc;

    public AnnotatingModalGraphMouse(RenderContext<V, E> rc, AnnotatingGraphMousePlugin<V, E> annotatingPlugin) {
        this(rc, annotatingPlugin, 1.1f, 0.9090909f);
    }

    public AnnotatingModalGraphMouse(RenderContext<V, E> rc, AnnotatingGraphMousePlugin<V, E> annotatingPlugin, float in, float out) {
        super(in, out);
        this.rc = rc;
        this.basicTransformer = rc.getMultiLayerTransformer();
        this.annotatingPlugin = annotatingPlugin;
        this.loadPlugins();
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    protected void loadPlugins() {
        this.pickingPlugin = new PickingGraphMousePlugin();
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(16);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }

    @Override
    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            } else if (mode == ModalGraphMouse.Mode.ANNOTATING) {
                this.setAnnotatingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem((Object)mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)mode, 1));
        }
    }

    @Override
    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    protected void setEditingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.annotatingPlugin);
    }

    protected void setAnnotatingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.add(this.annotatingPlugin);
    }

    @Override
    public JComboBox<ModalGraphMouse.Mode> getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING, ModalGraphMouse.Mode.ANNOTATING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem((Object)this.mode);
        return this.modeBox;
    }

    @Override
    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            final JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AnnotatingModalGraphMouse.this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                    }
                }
            });
            final JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AnnotatingModalGraphMouse.this.setMode(ModalGraphMouse.Mode.PICKING);
                    }
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                            transformingButton.setSelected(true);
                        } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                            pickingButton.setSelected(true);
                        }
                    }
                }
            });
        }
        return this.modeMenu;
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, char a, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(ModalGraphMouse.Mode.ANNOTATING);
            }
        }
    }
}

