/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.FunctionDataView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.Objects;

public class ParamInfo
implements Comparable<ParamInfo> {
    private String name;
    private DataType formalDataType;
    private VariableStorage storage;
    private boolean isCustomStorage;
    private int ordinal;
    private boolean hasStorageConflict = false;
    private FunctionDataView functionData;
    private Program program;

    ParamInfo(FunctionDataView functionData, Parameter parameter) {
        this(functionData, parameter.getName(), parameter.getFormalDataType(), parameter.getVariableStorage(), functionData.canCustomizeStorage(), parameter.getOrdinal());
    }

    ParamInfo(FunctionDataView functionData, ParameterDefinition paramDefinition) {
        this(functionData, paramDefinition.getName(), paramDefinition.getDataType(), VariableStorage.UNASSIGNED_STORAGE, false, paramDefinition.getOrdinal());
        this.functionData = functionData;
    }

    ParamInfo(FunctionDataView functionData, String name, DataType formalDataType, VariableStorage storage, boolean isCustomStorage, int ordinal) {
        this.functionData = functionData;
        this.program = functionData.getProgram();
        this.name = SymbolUtilities.isDefaultParameterName((String)name) ? null : name;
        this.formalDataType = formalDataType;
        this.storage = storage;
        this.isCustomStorage = isCustomStorage;
        this.ordinal = ordinal;
    }

    ParamInfo copy() {
        return new ParamInfo(this.functionData, this.name, this.formalDataType, this.storage, this.isCustomStorage, this.ordinal);
    }

    public boolean isSame(ParamInfo otherParam) {
        if (!Objects.equals(this.name, otherParam.name) || this.isAutoParameter() != otherParam.isAutoParameter() || !this.formalDataType.equals((Object)otherParam.getFormalDataType())) {
            return false;
        }
        return !this.isCustomStorage || this.storage.equals((Object)otherParam.storage);
    }

    @Override
    public int compareTo(ParamInfo o) {
        int c = this.ordinal - o.ordinal;
        if (c != 0) {
            return c;
        }
        return this.getName().compareTo(o.getName());
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String getName(boolean returnNullForDefault) {
        if (returnNullForDefault) {
            return this.name;
        }
        return this.getName();
    }

    public String getName() {
        return this.name != null ? this.name : SymbolUtilities.getDefaultParamName((int)(this.ordinal - this.functionData.getAutoParamCount()));
    }

    DataType getDataType() {
        DataType dt = this.formalDataType;
        if (this.storage.isForcedIndirect()) {
            ProgramBasedDataTypeManager dtm = this.program.getDataTypeManager();
            int ptrSize = this.storage.size();
            dt = ptrSize != dtm.getDataOrganization().getPointerSize() ? dtm.getPointer(dt, ptrSize) : dtm.getPointer(dt);
        }
        return dt;
    }

    public DataType getFormalDataType() {
        return this.formalDataType;
    }

    public VariableStorage getStorage() {
        return this.storage;
    }

    boolean isAutoParameter() {
        return this.storage.isAutoStorage();
    }

    boolean isReturnParameter() {
        return this.ordinal == -1;
    }

    boolean isForcedIndirect() {
        return this.storage.isForcedIndirect();
    }

    public String toString() {
        return this.getName() + "@" + String.valueOf(this.getStorage());
    }

    int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int i) {
        this.ordinal = i;
    }

    void setName(String name) {
        if (name != null && (name.length() == 0 || SymbolUtilities.isDefaultParameterName((String)name))) {
            name = null;
        }
        this.name = name;
    }

    void setFormalDataType(DataType formalDataType) {
        this.formalDataType = formalDataType;
    }

    void setStorage(VariableStorage storage) {
        this.isCustomStorage = this.functionData.canCustomizeStorage();
        this.storage = storage;
    }

    Parameter getParameter(SourceType source) {
        VariableStorage variableStorage = this.isCustomStorage ? this.storage : VariableStorage.UNASSIGNED_STORAGE;
        try {
            if (this.ordinal == -1) {
                return new ReturnParameterImpl(this.formalDataType, variableStorage, true, this.program);
            }
            String n = this.name;
            if (n == null) {
                source = SourceType.DEFAULT;
                n = SymbolUtilities.getDefaultParamName((int)this.ordinal);
            }
            return new ParameterImpl(n, this.ordinal, this.formalDataType, variableStorage, true, this.program, source);
        }
        catch (InvalidInputException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    boolean hasStorageConflict() {
        return this.hasStorageConflict;
    }

    void setHasStorageConflict(boolean state) {
        this.hasStorageConflict = state;
    }
}

