/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.plugin.core.cparser.CParserPlugin;
import ghidra.app.util.cparser.C.CParserUtils;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import javax.help.UnsupportedOperationException;

class CParserTask
extends Task {
    private CParserPlugin plugin;
    private String[] filenames;
    private String[] includePaths;
    private String options;
    private String languageId;
    private String compilerSpecId;
    private final DataTypeManager dataTypeManager;
    private final File dataFile;

    CParserTask(CParserPlugin plugin, String dataFileName) {
        super("Parsing C Files", true, false, false);
        this.dataTypeManager = null;
        this.plugin = plugin;
        this.dataFile = new File(dataFileName);
    }

    public CParserTask(CParserPlugin plugin, DataTypeManager dataTypeManager) {
        super("Parsing C Files", true, false, false);
        this.dataFile = null;
        this.plugin = plugin;
        this.dataTypeManager = dataTypeManager;
    }

    public CParserTask setLanguageID(String languageId) {
        if (this.dataTypeManager != null) {
            throw new UnsupportedOperationException("setLanguageID not supported when constructed with DataTypeManager");
        }
        this.languageId = languageId;
        return this;
    }

    public CParserTask setCompilerID(String compilerSpecId) {
        if (this.dataTypeManager != null) {
            throw new UnsupportedOperationException("setLanguageID not supported when constructed with DataTypeManager");
        }
        this.compilerSpecId = compilerSpecId;
        return this;
    }

    public CParserTask setIncludePaths(String[] includePaths) {
        this.includePaths = (String[])includePaths.clone();
        return this;
    }

    public CParserTask setFileNames(String[] names) {
        this.filenames = (String[])names.clone();
        return this;
    }

    public CParserTask setOptions(String options) {
        this.options = options;
        return this;
    }

    private String getFirstMessageLine(String errMsg) {
        int indexOf = errMsg.indexOf(10);
        String msg = errMsg;
        if (indexOf > 0) {
            msg = msg.substring(0, indexOf);
        }
        return msg;
    }

    private String getResultMessage(DataTypeManager dtMgr, int initialDtCount) {
        int finalDtCount = dtMgr.getDataTypeCount(true) - initialDtCount;
        String msg = (finalDtCount == 0 ? "No" : Integer.toString(finalDtCount)) + " Data Types added.";
        if (finalDtCount != 0 && this.plugin.isOpenInTool(dtMgr)) {
            msg = msg + "\nCheck the Data Type Manager window for added data types.";
        }
        return msg;
    }

    private String getParseDestination(DataTypeManager dtMgr) {
        Object parseDest = "";
        if (dtMgr instanceof ProgramDataTypeManager) {
            parseDest = "Program " + dtMgr.getName();
        } else if (dtMgr instanceof FileDataTypeManager) {
            FileDataTypeManager fileDtm = (FileDataTypeManager)dtMgr;
            parseDest = "Archive File: " + fileDtm.getFilename();
        } else {
            parseDest = dtMgr.getName();
        }
        return parseDest;
    }

    /*
     * Exception decompiling
     */
    public void run(TaskMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ void lambda$run$3(DataTypeManager dtMgr, String errMsg) {
        MultiLineMessageDialog.showMessageDialog((Component)this.plugin.getDialog().getComponent(), (String)"Error During C-Parse", (String)("Failed to parse header file(s) to " + this.getParseDestination(dtMgr)), (String)this.plugin.getFormattedParseMessage(errMsg), (int)0);
    }

    private /* synthetic */ void lambda$run$2(DataTypeManager dtMgr, String errMsg) {
        MultiLineMessageDialog.showMessageDialog((Component)this.plugin.getDialog().getComponent(), (String)"C-PreProcessor Parse Failed", (String)("Failed to parse header file(s) to " + this.getParseDestination(dtMgr)), (String)this.plugin.getFormattedParseMessage(errMsg), (int)0);
    }

    private /* synthetic */ void lambda$run$1(DataTypeManager dtMgr, String errMsg) {
        MultiLineMessageDialog.showMessageDialog((Component)this.plugin.getDialog().getComponent(), (String)"C-Parse Failed", (String)("Failed to parse header file(s) to " + this.getParseDestination(dtMgr)), (String)this.plugin.getFormattedParseMessage(errMsg), (int)0);
    }

    private /* synthetic */ void lambda$run$0(CParserUtils.CParseResults results, DataTypeManager dtMgr, String msg) {
        if (!results.successful()) {
            MultiLineMessageDialog.showModalMessageDialog((Component)this.plugin.getDialog().getComponent(), (String)"C-Parse Failed", (String)("Failed to parse header file(s) to " + this.getParseDestination(dtMgr)), (String)this.plugin.getFormattedParseMessage(msg), (int)1);
        } else {
            MultiLineMessageDialog.showModalMessageDialog((Component)this.plugin.getDialog().getComponent(), (String)"C-Parse Completed", (String)("Successfully parsed header file(s) to " + this.getParseDestination(dtMgr)), (String)this.plugin.getFormattedParseMessage(msg), (int)1);
        }
    }
}

