/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.nav.LocationMemento;
import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;

public class ByteViewerLocationMemento
extends LocationMemento {
    protected static final String BLOCK_NUM = "Block Num";
    protected static final String BLOCK_OFFSET = "Block Offset";
    private final ViewerPosition viewerPosition;
    private final int blockNum;
    private final BigInteger blockOffset;
    private int column;

    public ByteViewerLocationMemento(Program program, ProgramLocation location, int blockNum, BigInteger blockOffset, int column, ViewerPosition viewerPosition) {
        super(program, location);
        this.blockNum = blockNum;
        this.blockOffset = blockOffset;
        this.viewerPosition = viewerPosition;
        this.column = column;
    }

    public ByteViewerLocationMemento(SaveState saveState, Program[] programs) {
        super(saveState, programs);
        this.blockNum = saveState.getInt(BLOCK_NUM, 0);
        this.blockOffset = new BigInteger(saveState.getString(BLOCK_OFFSET, "0"));
        int index = saveState.getInt("INDEX", 0);
        int yOffset = saveState.getInt("Y_OFFSET", 0);
        int xOffset = saveState.getInt("X_OFFSET", 0);
        this.viewerPosition = new ViewerPosition(index, xOffset, yOffset);
    }

    public BigInteger getBlockOffset() {
        return this.blockOffset;
    }

    public ViewerPosition getViewerPosition() {
        return this.viewerPosition;
    }

    public int getBlockNum() {
        return this.blockNum;
    }

    public int getColumn() {
        return this.column;
    }

    public void saveState(SaveState saveState) {
        super.saveState(saveState);
        saveState.putInt("INDEX", this.viewerPosition.getIndexAsInt());
        saveState.putInt("Y_OFFSET", this.viewerPosition.getYOffset());
        saveState.putInt("X_OFFSET", this.viewerPosition.getYOffset());
        saveState.putInt(BLOCK_NUM, this.blockNum);
        if (this.blockOffset != null) {
            saveState.putString(BLOCK_OFFSET, this.blockOffset.toString());
        }
    }
}

