/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Matf;
import org.gephi.lib.gleem.linalg.Rotf;
import org.gephi.lib.gleem.linalg.Vec3f;
import org.gephi.lib.gleem.linalg.Vec4f;

public class Mat4f {
    private final float[] data = new float[16];

    public Mat4f() {
    }

    public Mat4f(Mat4f arg) {
        this();
        this.set(arg);
    }

    public void makeIdent() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                    continue;
                }
                this.set(i, j, 0.0f);
            }
        }
    }

    public void set(Mat4f arg) {
        float[] mine = this.data;
        float[] yours = arg.data;
        for (int i = 0; i < mine.length; ++i) {
            mine[i] = yours[i];
        }
    }

    public float get(int i, int j) {
        return this.data[4 * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[4 * i + j] = val;
    }

    public void setTranslation(Vec3f trans) {
        this.set(0, 3, trans.x());
        this.set(1, 3, trans.y());
        this.set(2, 3, trans.z());
    }

    public void setRotation(Rotf rot) {
        rot.toMatrix(this);
    }

    public void setRotation(Vec3f x, Vec3f y, Vec3f z) {
        this.set(0, 0, x.x());
        this.set(1, 0, x.y());
        this.set(2, 0, x.z());
        this.set(0, 1, y.x());
        this.set(1, 1, y.y());
        this.set(2, 1, y.z());
        this.set(0, 2, z.x());
        this.set(1, 2, z.y());
        this.set(2, 2, z.z());
    }

    public void getRotation(Rotf rot) {
        rot.fromMatrix(this);
    }

    public void setScale(Vec3f scale) {
        this.set(0, 0, scale.x());
        this.set(1, 1, scale.y());
        this.set(2, 2, scale.z());
    }

    public void invertRigid() {
        float t = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, t);
        t = this.get(0, 2);
        this.set(0, 2, this.get(2, 0));
        this.set(2, 0, t);
        t = this.get(1, 2);
        this.set(1, 2, this.get(2, 1));
        this.set(2, 1, t);
        Vec3f negTrans = new Vec3f(-this.get(0, 3), -this.get(1, 3), -this.get(2, 3));
        Vec3f trans = new Vec3f();
        this.xformDir(negTrans, trans);
        this.set(0, 3, trans.x());
        this.set(1, 3, trans.y());
        this.set(2, 3, trans.z());
    }

    public Mat4f mul(Mat4f b) {
        Mat4f tmp = new Mat4f();
        tmp.mul(this, b);
        return tmp;
    }

    public void mul(Mat4f a, Mat4f b) {
        for (int rc = 0; rc < 4; ++rc) {
            for (int cc = 0; cc < 4; ++cc) {
                float tmp = 0.0f;
                for (int i = 0; i < 4; ++i) {
                    tmp += a.get(rc, i) * b.get(i, cc);
                }
                this.set(rc, cc, tmp);
            }
        }
    }

    public void transpose() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                float t = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, t);
            }
        }
    }

    public void xformVec(Vec4f src, Vec4f dest) {
        for (int rc = 0; rc < 4; ++rc) {
            float tmp = 0.0f;
            for (int cc = 0; cc < 4; ++cc) {
                tmp += this.get(rc, cc) * src.get(cc);
            }
            dest.set(rc, tmp);
        }
    }

    public void xformPt(Vec3f src, Vec3f dest) {
        for (int rc = 0; rc < 3; ++rc) {
            float tmp = 0.0f;
            for (int cc = 0; cc < 3; ++cc) {
                tmp += this.get(rc, cc) * src.get(cc);
            }
            dest.set(rc, tmp += this.get(rc, 3));
        }
    }

    public void xformDir(Vec3f src, Vec3f dest) {
        for (int rc = 0; rc < 3; ++rc) {
            float tmp = 0.0f;
            for (int cc = 0; cc < 3; ++cc) {
                tmp += this.get(rc, cc) * src.get(cc);
            }
            dest.set(rc, tmp);
        }
    }

    public void getColumnMajorData(float[] out) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                out[4 * j + i] = this.get(i, j);
            }
        }
    }

    public Matf toMatf() {
        Matf out = new Matf(4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                out.set(i, j, this.get(i, j));
            }
        }
        return out;
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + ", " + this.get(0, 2) + ", " + this.get(0, 3) + endl + this.get(1, 0) + ", " + this.get(1, 1) + ", " + this.get(1, 2) + ", " + this.get(1, 3) + endl + this.get(2, 0) + ", " + this.get(2, 1) + ", " + this.get(2, 2) + ", " + this.get(2, 3) + endl + this.get(3, 0) + ", " + this.get(3, 1) + ", " + this.get(3, 2) + ", " + this.get(3, 3) + ")";
    }
}

