/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.headlessmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.RenderedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.freeplane.core.extension.Configurable;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;

public class HeadlessMapViewController
implements IMapViewManager {
    private final Map<String, MapModel> maps = new HashMap<String, MapModel>();
    Collection<IMapSelectionListener> mapSelectionListeners = new ArrayList<IMapSelectionListener>();
    private MapModel currentMap = null;
    private String currentKey = null;

    @Override
    public void addMapSelectionListener(IMapSelectionListener pListener) {
        this.mapSelectionListeners.add(pListener);
    }

    @Override
    public void addMapViewChangeListener(IMapViewChangeListener pListener) {
    }

    @Override
    public boolean changeToMapView(Component newMapView) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void changeToMap(MapModel map) {
        for (Map.Entry<String, MapModel> mapEntry : this.maps.entrySet()) {
            if (!mapEntry.getValue().equals(map)) continue;
            this.changeToMap(map, mapEntry.getKey());
            return;
        }
    }

    @Override
    public boolean changeToMapView(String mapViewDisplayName) {
        if (mapViewDisplayName != null && this.maps.containsKey(mapViewDisplayName)) {
            MapModel nextMap = this.maps.get(mapViewDisplayName);
            this.changeToMap(nextMap, mapViewDisplayName);
            return true;
        }
        return false;
    }

    private void changeToMap(MapModel nextMap, String mapViewDisplayName) {
        MapModel oldMap = this.currentMap;
        for (IMapSelectionListener mapSelectionListener : this.mapSelectionListeners) {
            mapSelectionListener.beforeMapChange(oldMap, nextMap);
        }
        this.currentKey = mapViewDisplayName;
        this.currentMap = nextMap;
        for (IMapSelectionListener mapSelectionListener : this.mapSelectionListeners) {
            mapSelectionListener.afterMapChange(oldMap, nextMap);
        }
    }

    @Override
    public boolean changeToMode(String modeName) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public String checkIfFileIsAlreadyOpened(URL urlToCheck) throws MalformedURLException {
        String key = urlToCheck.toString();
        if (this.maps.containsKey(key)) {
            return key;
        }
        return null;
    }

    @Override
    public boolean close() {
        this.closeWithoutSaving();
        return true;
    }

    @Override
    public void closeWithoutSaving() {
        if (this.currentMap != null) {
            this.maps.remove(this.currentKey);
            this.currentKey = null;
            this.currentMap = null;
        }
    }

    @Override
    public String createHtmlMap() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public RenderedImage createImage(int dpi, int imageType) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public RenderedImage createImage(Dimension slideSize, NodeModel placedNode, IMapSelection.NodePosition placedNodePosition, int dpi, int imageType) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Color getBackgroundColor(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Component getComponent(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Font getFont(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public List<String> getMapKeys() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Map<String, MapModel> getMaps() {
        return this.maps;
    }

    @Override
    public IMapSelection getMapSelection() {
        return null;
    }

    @Override
    public JComponent getMapViewComponent() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public JComponent findMapViewContainedIn(Component ancestor) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Configurable getMapViewConfiguration() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public List<? extends Component> getMapViews() {
        return Collections.emptyList();
    }

    @Override
    public ModeController getModeController(Component newMap) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public MapModel getMap() {
        return this.currentMap;
    }

    @Override
    public MapModel getMap(Component mapView) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Component getSelectedComponent() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public float getZoom() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void newMapView(MapModel map, ModeController modeController) {
        String key = map.getURL().toString();
        if (key.equals(this.currentKey)) {
            this.close();
        }
        this.maps.put(key, map);
        this.changeToMapView(key);
    }

    public void nextMapView() {
        throw new RuntimeException("Method not implemented");
    }

    public void previousMapView() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void removeMapSelectionListener(IMapSelectionListener pListener) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void removeMapViewChangeListener(IMapViewChangeListener pListener) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void scrollNodeToVisible(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setZoom(float zoom) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean tryToChangeToMapView(String mapView) {
        return this.changeToMapView(mapView);
    }

    @Override
    public boolean tryToChangeToMapView(URL url) throws MalformedURLException {
        if (url == null) {
            return false;
        }
        return this.tryToChangeToMapView(url.toString());
    }

    @Override
    public void updateMapViewName() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean isLeftTreeSupported(Component mapViewComponent) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Map<String, MapModel> getMaps(String modename) {
        return this.maps;
    }

    @Override
    public List<Component> getViews(MapModel map) {
        return Collections.emptyList();
    }

    @Override
    public boolean containsView(MapModel map) {
        return false;
    }

    public JScrollPane getScrollPane() {
        throw new RuntimeException("Method not implemented");
    }

    public Container getViewport() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void obtainFocusForSelected() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setMapTitles() {
    }

    public boolean closeAllMaps() {
        this.maps.clear();
        this.currentKey = null;
        this.currentMap = null;
        return true;
    }

    @Override
    public boolean close(Component mapViewComponent) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public JComboBox createZoomBox() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean isFoldedOnCurrentView(NodeModel node) {
        return node.isFolded();
    }

    @Override
    public void setFoldedOnCurrentView(NodeModel node, boolean folded) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void moveFocusFromDescendantToSelection(Component ancestor) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void displayOnCurrentView(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean isChildHidden(NodeModel nodeOnPath) {
        return false;
    }

    @Override
    public int getHiddenChildCount(NodeModel node) {
        return 0;
    }

    @Override
    public boolean hasHiddenChildren(NodeModel selected) {
        return false;
    }

    @Override
    public boolean unfoldHiddenChildren(NodeModel node) {
        return false;
    }

    @Override
    public void hideChildren(NodeModel node) {
    }

    @Override
    public boolean showHiddenNode(NodeModel child) {
        return false;
    }

    @Override
    public boolean isSpotlightEnabled() {
        return false;
    }

    @Override
    public void setViewRoot(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void usePreviousViewRoot() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setLayout(Component map, MapViewLayout newLayoutType) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setMap(Component view, MapModel map) {
    }

    @Override
    public JComponent getMapViewAncestor(Component component) {
        return null;
    }
}

