/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Background {
    private final Location location;
    private final String keyword;
    private final String name;
    private final String description;
    private final List<Step> steps;
    private final String id;

    public Background(Location location, String keyword, String name, String description, List<Step> steps, String id) {
        this.location = Objects.requireNonNull(location, "Background.location cannot be null");
        this.keyword = Objects.requireNonNull(keyword, "Background.keyword cannot be null");
        this.name = Objects.requireNonNull(name, "Background.name cannot be null");
        this.description = Objects.requireNonNull(description, "Background.description cannot be null");
        this.steps = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(steps, "Background.steps cannot be null")));
        this.id = Objects.requireNonNull(id, "Background.id cannot be null");
    }

    public Location getLocation() {
        return this.location;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Background that = (Background)o;
        return this.location.equals(that.location) && this.keyword.equals(that.keyword) && this.name.equals(that.name) && this.description.equals(that.description) && this.steps.equals(that.steps) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.keyword, this.name, this.description, this.steps, this.id);
    }

    public String toString() {
        return "Background{location=" + this.location + ", keyword=" + this.keyword + ", name=" + this.name + ", description=" + this.description + ", steps=" + this.steps + ", id=" + this.id + '}';
    }
}

