/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.struct.DBSObject;

public final class JDBCObjectSimpleCache<OWNER extends DBSObject, OBJECT extends DBSObject>
extends JDBCObjectCache<OWNER, OBJECT> {
    private final String query;
    private final Class<OBJECT> objectType;
    private final Object[] queryParameters;
    private Constructor<OBJECT> objectConstructor;

    public JDBCObjectSimpleCache(Class<OBJECT> objectType, String query, Object ... args) {
        this.query = query;
        this.objectType = objectType;
        this.queryParameters = args;
    }

    @Override
    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OWNER owner) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement(this.query);
        if (this.queryParameters != null) {
            for (int i = 0; i < this.queryParameters.length; ++i) {
                dbStat.setObject(i + 1, this.queryParameters[i]);
            }
        }
        return dbStat;
    }

    @Override
    protected OBJECT fetchObject(@NotNull JDBCSession session, @NotNull OWNER owner, @NotNull JDBCResultSet resultSet) throws DBException {
        try {
            if (this.objectConstructor == null) {
                for (Class argType = owner.getClass(); argType != null; argType = argType.getSuperclass()) {
                    try {
                        this.objectConstructor = this.objectType.getConstructor(argType, ResultSet.class);
                        break;
                    }
                    catch (Exception e) {
                        for (Class<?> intType : argType.getInterfaces()) {
                            try {
                                this.objectConstructor = this.objectType.getConstructor(intType, ResultSet.class);
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (this.objectConstructor != null) break;
                        continue;
                    }
                }
                if (this.objectConstructor == null) {
                    throw new DBException("Can't find proper constructor for object '" + this.objectType.getName() + "'");
                }
            }
            return (OBJECT)((DBSObject)this.objectConstructor.newInstance(owner, resultSet));
        }
        catch (Exception e) {
            Throwable throwable;
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                throwable = ite.getTargetException();
            } else {
                throwable = e;
            }
            throw new DBException("Error creating cache object", throwable);
        }
    }
}

