/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistryCache;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConfigurationProfile;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.net.DBWNetworkProfileProvider;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerNIO;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFileStorage;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceParseResults;
import org.jkiss.dbeaver.registry.DataSourcePersistentRegistry;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.DataSourceSerializerLegacy;
import org.jkiss.dbeaver.registry.DataSourceSerializerModern;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.DataSourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceRegistry<T extends DataSourceDescriptor>
implements DBPDataSourceRegistry,
DataSourcePersistentRegistry,
DBPDataSourceRegistryCache {
    private static final Log log = Log.getLog(DataSourceRegistry.class);
    private static final long DISCONNECT_ALL_TIMEOUT = 5000L;
    private final DBPProject project;
    private final DataSourceConfigurationManager configurationManager;
    @NotNull
    private final DBPPreferenceStore preferenceStore;
    private final List<DBPDataSourceConfigurationStorage> storages = new ArrayList<DBPDataSourceConfigurationStorage>();
    private final Map<String, T> dataSources = new LinkedHashMap<String, T>();
    private final List<DataSourceFolder> dataSourceFolders = new ArrayList<DataSourceFolder>();
    private final List<DBSObjectFilter> savedFilters = new ArrayList<DBSObjectFilter>();
    private final List<DBWNetworkProfile> networkProfiles = new ArrayList<DBWNetworkProfile>();
    private final Map<String, DBAAuthProfile> authProfiles = new LinkedHashMap<String, DBAAuthProfile>();
    private final List<DBPEventListener> dataSourceListeners = new ArrayList<DBPEventListener>();
    private final List<DBPEvent> dataSourceEvents = new ArrayList<DBPEvent>();
    private final EventProcessJob eventsJob = new EventProcessJob();
    private volatile boolean saveInProgress = false;
    private final DBVModel.ModelChangeListener modelChangeListener = new DBVModel.ModelChangeListener();
    private volatile ConfigSaver configSaver;
    private DBACredentialsProvider authCredentialsProvider;
    protected Throwable lastError;

    public DataSourceRegistry(DBPProject project) {
        this(project, new DataSourceConfigurationManagerNIO(project), DBWorkbench.getPlatform().getPreferenceStore());
    }

    public DataSourceRegistry(@NotNull DBPProject project, DataSourceConfigurationManager configurationManager, @NotNull DBPPreferenceStore preferenceStore) {
        boolean isLoaded;
        this.project = project;
        this.configurationManager = configurationManager;
        this.preferenceStore = preferenceStore;
        boolean bl = isLoaded = this.loadDataSources(true) != null;
        if (!this.isMultiUser() && isLoaded) {
            DataSourceProviderRegistry.getInstance().fireRegistryChange(this, true);
            this.addDataSourceListener((DBPEventListener)this.modelChangeListener);
        }
    }

    protected boolean isMultiUser() {
        return DBWorkbench.getPlatform().getApplication().isMultiuser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.isMultiUser()) {
            this.removeDataSourceListener((DBPEventListener)this.modelChangeListener);
            DataSourceProviderRegistry.getInstance().fireRegistryChange(this, false);
        }
        Object object = this.dataSourceListeners;
        synchronized (object) {
            if (!this.dataSourceListeners.isEmpty()) {
                log.warn((Object)("Some data source listeners are still registered: " + this.dataSourceListeners.stream().map(l -> l.getClass().getName() + ":" + String.valueOf(l)).collect(Collectors.joining(","))));
            }
            this.dataSourceListeners.clear();
        }
        this.closeConnections(5000L);
        object = this.dataSources;
        synchronized (object) {
            for (DataSourceDescriptor dataSourceDescriptor : this.dataSources.values()) {
                dataSourceDescriptor.dispose();
            }
            this.dataSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(long waitTime) {
        boolean hasConnections = false;
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dataSource : this.dataSources.values()) {
                if (!dataSource.isConnected()) continue;
                hasConnections = true;
                break;
            }
        }
        if (!hasConnections) {
            return;
        }
        DisconnectTask disconnectTask = new DisconnectTask();
        if (!RuntimeUtils.runTask((DBRRunnableWithProgress)disconnectTask, (String)"Disconnect from data sources", (long)waitTime)) {
            log.warn((Object)("Some data source connections wasn't closed on shutdown in " + waitTime + "ms. Probably network timeout occurred."));
        }
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    @NotNull
    DBPDataSourceConfigurationStorage getDefaultStorage() {
        List<DBPDataSourceConfigurationStorage> list = this.storages;
        synchronized (list) {
            for (DBPDataSourceConfigurationStorage dBPDataSourceConfigurationStorage : this.storages) {
                if (!dBPDataSourceConfigurationStorage.isDefault()) continue;
                return dBPDataSourceConfigurationStorage;
            }
            List<DBPDataSourceConfigurationStorage> storages = this.getConfigurationManager().getConfigurationStorages();
            for (DBPDataSourceConfigurationStorage storage : storages) {
                if (!storage.isDefault()) continue;
                this.storages.add(storage);
                return storage;
            }
            log.warn((Object)("no default storage in registry " + String.valueOf(this)));
            try {
                Path path = this.getProject().getMetadataFolder(false).resolve("data-sources.json");
                Files.createFile(path, new FileAttribute[0]);
                DataSourceFileStorage defaultStorage = new DataSourceFileStorage(path, false, true);
                this.storages.add(defaultStorage);
                return defaultStorage;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to create a default storage in registry " + String.valueOf(this), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getDataSource(@NotNull String id) {
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            return (T)((DataSourceDescriptor)this.dataSources.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getDataSource(@NotNull DBPDataSource dataSource) {
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dsd : this.dataSources.values()) {
                if (dsd.getDataSource() != dataSource) continue;
                return (T)dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T findDataSourceByName(String name) {
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dsd : this.dataSources.values()) {
                if (dsd.isHidden() || !dsd.getName().equals(name)) continue;
                return (T)dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSourcesByProfile(@NotNull DBWNetworkProfile profile) {
        List dsCopy;
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            dsCopy = CommonUtils.copyList(this.dataSources.values());
        }
        dsCopy.removeIf(ds -> !CommonUtils.equalObjects((Object)ds.getConnectionConfiguration().getConfigProfileSource(), (Object)profile.getProfileSource()) || !CommonUtils.equalObjects((Object)ds.getConnectionConfiguration().getConfigProfileName(), (Object)profile.getProfileName()));
        return dsCopy;
    }

    public int getDataSourceCount() {
        return this.dataSources.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<T> getDataSources() {
        List dsCopy;
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            dsCopy = CommonUtils.copyList(this.dataSources.values());
        }
        dsCopy.sort((o1, o2) -> ((String)CommonUtils.notNull((Object)o1.getName(), (Object)o1.getId())).compareToIgnoreCase((String)CommonUtils.notNull((Object)o2.getName(), (Object)o2.getId())));
        return dsCopy;
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptor(this, DataSourceDescriptor.generateNewId(driver), driver, connConfig);
    }

    public DBPDataSourceContainer createDataSource(@NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptor(this, id, driver, connConfig);
    }

    public DBPDataSourceContainer createDataSource(@NotNull DBPDataSourceConfigurationStorage dataSourceStorage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration configuration) {
        return new DataSourceDescriptor(this, dataSourceStorage, origin, id, driver, configuration);
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(@NotNull DBPDataSourceContainer source) {
        DataSourceDescriptor newDS = new DataSourceDescriptor((DataSourceDescriptor)source, this);
        newDS.setId(DataSourceDescriptor.generateNewId(source.getDriver()));
        return newDS;
    }

    @NotNull
    public List<DataSourceFolder> getAllFolders() {
        return this.dataSourceFolders;
    }

    @NotNull
    public List<DataSourceFolder> getRootFolders() {
        ArrayList<DataSourceFolder> rootFolders = new ArrayList<DataSourceFolder>();
        for (DataSourceFolder folder : this.dataSourceFolders) {
            if (folder.getParent() != null) continue;
            rootFolders.add(folder);
        }
        return rootFolders;
    }

    @NotNull
    public DataSourceFolder addFolder(@Nullable DBPDataSourceFolder parent, @NotNull String name) {
        return this.createFolder(parent, name);
    }

    protected DataSourceFolder createFolder(DBPDataSourceFolder parent, String name) {
        DataSourceFolder folder = new DataSourceFolder(this, (DataSourceFolder)parent, name, null);
        this.dataSourceFolders.add(folder);
        return folder;
    }

    public void removeFolder(@NotNull DBPDataSourceFolder folder, boolean dropContents) {
        DataSourceFolder folderImpl = (DataSourceFolder)folder;
        String folderPath = folder.getFolderPath();
        for (DataSourceFolder child : folderImpl.getChildren()) {
            this.removeFolder(child, dropContents);
        }
        this.dataSourceFolders.remove(folderImpl);
        DBPDataSourceFolder parent = folder.getParent();
        if (parent != null) {
            folderImpl.setParent(null);
        }
        for (DataSourceDescriptor ds : this.dataSources.values()) {
            if (ds.getFolder() != folder) continue;
            if (dropContents) {
                this.removeDataSource(ds);
                continue;
            }
            ds.setFolder(parent);
        }
        this.persistDataFolderDelete(folderPath, dropContents);
    }

    public void moveFolder(@NotNull String oldPath, @NotNull String newPath) throws DBException {
        DBPDataSourceFolder parentFolder;
        DBPDataSourceFolder folder = this.getFolder(oldPath);
        Path result = Path.of(newPath, new String[0]);
        String newName = result.getFileName().toString();
        Path parent = result.getParent();
        DBPDataSourceFolder dBPDataSourceFolder = parentFolder = parent == null ? null : this.getFolder(parent.toString().replace("\\", "/"));
        if (folder == parentFolder) {
            throw new DBException("Cannot move folder inside itself");
        }
        folder.setParent(parentFolder);
        if (!CommonUtils.equalObjects((Object)folder.getName(), (Object)newName)) {
            folder.setName(newName);
        }
    }

    private DataSourceFolder findRootFolder(String name) {
        for (DataSourceFolder root : this.getRootFolders()) {
            if (!root.getName().equals(name)) continue;
            return root;
        }
        return null;
    }

    @NotNull
    public DBPDataSourceFolder getFolder(@NotNull String path) {
        return this.findFolderByPath(path, true, null);
    }

    DataSourceFolder findFolderByPath(String path, boolean create, DataSourceParseResults results) {
        DataSourceFolder parent = null;
        for (String name : path.split("/")) {
            DataSourceFolder folder;
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.findRootFolder(name) : parent.getChild(name);
            if (folder == null) {
                if (!create) {
                    log.warn((Object)("Folder '" + path + "' not found"));
                    break;
                }
                folder = this.createFolder(parent, name);
            }
            parent = folder;
            if (results == null) continue;
            results.updatedFolders.add(parent);
        }
        return parent;
    }

    void addDataSourceFolder(DataSourceFolder folder) {
        if (this.dataSourceFolders.contains(folder)) {
            return;
        }
        this.dataSourceFolders.add(folder);
    }

    @Nullable
    public DBSObjectFilter getSavedFilter(String name) {
        for (DBSObjectFilter filter : this.savedFilters) {
            if (!CommonUtils.equalObjects((Object)filter.getName(), (Object)name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public List<DBSObjectFilter> getSavedFilters() {
        return this.savedFilters;
    }

    public void updateSavedFilter(@NotNull DBSObjectFilter filter) {
        DBSObjectFilter filterCopy = new DBSObjectFilter(filter);
        for (int i = 0; i < this.savedFilters.size(); ++i) {
            if (!CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filter.getName())) continue;
            this.savedFilters.set(i, filterCopy);
            return;
        }
        this.savedFilters.add(filterCopy);
    }

    public void removeSavedFilter(@NotNull String filterName) {
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filterName)) {
                this.savedFilters.remove(i);
                continue;
            }
            ++i;
        }
    }

    void addSavedFilter(DBSObjectFilter filter) {
        this.savedFilters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBWNetworkProfile getNetworkProfile(@Nullable String source, @NotNull String name) {
        if (!CommonUtils.isEmpty((String)source)) {
            DBWNetworkProfileProvider profileProvider = (DBWNetworkProfileProvider)RuntimeUtils.getObjectAdapter((Object)this.getProject(), DBWNetworkProfileProvider.class);
            if (profileProvider != null) {
                return profileProvider.getNetworkProfile(source, name);
            }
            return null;
        }
        List<DBWNetworkProfile> list = this.networkProfiles;
        synchronized (list) {
            return this.networkProfiles.stream().filter(profile -> CommonUtils.equalObjects((Object)profile.getProfileName(), (Object)name)).findFirst().orElse(null);
        }
    }

    @NotNull
    public List<DBWNetworkProfile> getNetworkProfiles() {
        return this.networkProfiles;
    }

    public void updateNetworkProfile(@NotNull DBWNetworkProfile profile) {
        for (int i = 0; i < this.networkProfiles.size(); ++i) {
            if (!CommonUtils.equalObjects((Object)this.networkProfiles.get(i).getProfileName(), (Object)profile.getProfileName())) continue;
            this.networkProfiles.set(i, profile);
            return;
        }
        this.networkProfiles.add(profile);
    }

    public void removeNetworkProfile(@NotNull DBWNetworkProfile profile) {
        try {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
            secretController.setPrivateSecretValue(profile.getSecretKeyId(), null);
            secretController.flushChanges();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Secret remove error", "Error removing network profile credentials from secret storage", (Throwable)e);
        }
        this.networkProfiles.remove(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBAAuthProfile getAuthProfile(@NotNull String id) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return this.authProfiles.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBAAuthProfile> getAllAuthProfiles() {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return new ArrayList<DBAAuthProfile>(this.authProfiles.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBAAuthProfile> getApplicableAuthProfiles(@Nullable DBPDriver driver) {
        DBPDataSourceProviderRegistry dspRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return this.authProfiles.values().stream().filter(p -> {
                DBPAuthModelDescriptor authModel = dspRegistry.getAuthModel(p.getAuthModelId());
                return authModel != null && authModel.isApplicableTo(driver);
            }).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthProfile(@NotNull DBAAuthProfile profile) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.put(profile.getProfileId(), profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthProfiles(@NotNull Collection<DBAAuthProfile> profiles) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.clear();
            this.authProfiles.putAll(profiles.stream().collect(Collectors.toMap(DBPConfigurationProfile::getProfileId, Function.identity())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthProfile(@NotNull DBAAuthProfile profile) {
        if (this.getProject().isUseSecretStorage()) {
            try {
                DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
                secretController.setPrivateSecretValue(profile.getSecretKeyId(), null);
                secretController.flushChanges();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Secret remove error", "Error removing auth profile credentials from secret storage", (Throwable)e);
            }
        }
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.remove(profile.getProfileId());
        }
    }

    public void addDataSource(@NotNull DBPDataSourceContainer dataSource) throws DBException {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        this.addDataSourceToList(descriptor);
        descriptor.persistSecretIfNeeded(true, true);
        if (!descriptor.isDetached()) {
            this.persistDataSourceCreate(dataSource);
        }
        this.notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)descriptor, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceToList(@NotNull DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            this.dataSources.put(descriptor.getId(), descriptor);
            DBPDataSourceConfigurationStorage storage = descriptor.getStorage();
            if (!this.storages.contains(storage) && !descriptor.isDetached()) {
                this.storages.add(storage);
            }
        }
    }

    public void removeDataSource(@NotNull DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        this.removeDataSourceFromList(descriptor);
        if (!descriptor.isDetached()) {
            this.persistDataSourceDelete(dataSource);
        }
        try {
            descriptor.removeSecretIfNeeded();
        }
        catch (DBException e) {
            log.error((Object)"Error deleting old secrets", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSourceFromList(@NotNull DBPDataSourceContainer dataSource) {
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            this.dataSources.remove(dataSource.getId());
        }
        try {
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dataSource);
        }
        finally {
            dataSource.dispose();
        }
    }

    public void updateDataSource(@NotNull DBPDataSourceContainer dataSource) throws DBException {
        if (!(dataSource instanceof DataSourceDescriptor)) {
            return;
        }
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        if (!this.dataSources.containsKey(dataSource.getId())) {
            this.addDataSource(dataSource);
        } else {
            if (!descriptor.isDetached()) {
                this.persistDataSourceUpdate(dataSource);
            }
            descriptor.persistSecretIfNeeded(true, false);
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSource);
        }
    }

    protected void persistDataSourceCreate(@NotNull DBPDataSourceContainer container) {
        this.persistDataSourceUpdate(container);
    }

    protected void persistDataSourceUpdate(@NotNull DBPDataSourceContainer container) {
        this.saveDataSources();
    }

    protected void persistDataFolderDelete(@NotNull String folderPath, boolean dropContents) {
        this.saveDataSources();
    }

    protected void persistDataSourceDelete(@NotNull DBPDataSourceContainer container) {
        this.saveDataSources();
    }

    public void flushConfig() {
        if (this.project.isInMemory()) {
            return;
        }
        if (this.configSaver == null) {
            this.configSaver = new ConfigSaver();
        }
        this.configSaver.schedule(100L);
    }

    public void refreshConfig() {
        if (!this.saveInProgress) {
            this.loadDataSources(true);
        }
    }

    public void refreshConfig(@Nullable Collection<String> dataSourceIds) {
        if (this.saveInProgress) {
            return;
        }
        this.loadDataSources(this.configurationManager.getConfigurationStorages(), this.configurationManager, dataSourceIds, true, false);
    }

    @Nullable
    public Throwable getLastError() {
        Throwable error = this.lastError;
        this.lastError = null;
        return error;
    }

    public boolean hasError() {
        return this.lastError != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceListener(@NotNull DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            this.dataSourceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSourceListener(@NotNull DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            return this.dataSourceListeners.remove(listener);
        }
    }

    private void fireDataSourceEvent(DBPEvent.Action action, DBSObject object) {
        this.notifyDataSourceListeners(new DBPEvent(action, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataSourceListeners(@NotNull DBPEvent event) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            this.dataSourceEvents.add(event);
        }
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
            this.eventsJob.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            this.eventsJob.schedule(20L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDataSourceEvents() {
        DBPEvent[] dBPEventArray = this.dataSourceListeners;
        synchronized (this.dataSourceListeners) {
            DBPEvent[] events = this.dataSourceEvents.toArray(new DBPEvent[0]);
            this.dataSourceEvents.clear();
            if (this.dataSourceListeners.isEmpty()) {
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return;
            }
            DBPEventListener[] listeners = this.dataSourceListeners.toArray(new DBPEventListener[0]);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            for (DBPEvent event : events) {
                for (DBPEventListener listener : listeners) {
                    listener.handleDataSourceEvent(event);
                }
            }
            return;
        }
    }

    @Nullable
    public DBACredentialsProvider getAuthCredentialsProvider() {
        return this.authCredentialsProvider;
    }

    public void setAuthCredentialsProvider(DBACredentialsProvider authCredentialsProvider) {
        this.authCredentialsProvider = authCredentialsProvider;
    }

    public static List<DBPDataSourceContainer> getAllDataSources() {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            if (!project.isOpen() || !project.isRegistryLoaded()) continue;
            result.addAll(project.getDataSourceRegistry().getDataSources());
        }
        return result;
    }

    @NotNull
    public Set<DBPDataSourceFolder> getTemporaryFolders() {
        LinkedHashSet<DBPDataSourceFolder> result = new LinkedHashSet<DBPDataSourceFolder>();
        Set folders = this.getDataSources().stream().filter(DBPDataSourceContainer::isTemporary).map(DBPDataSourceContainer::getFolder).collect(Collectors.toSet());
        Iterator iterator = folders.iterator();
        while (iterator.hasNext()) {
            for (DBPDataSourceFolder folder = (DBPDataSourceFolder)iterator.next(); folder != null; folder = folder.getParent()) {
                result.add(folder);
            }
        }
        return result;
    }

    private DataSourceParseResults loadDataSources(boolean refresh) {
        return this.loadDataSources(this.configurationManager.getConfigurationStorages(), this.configurationManager, null, refresh, true);
    }

    @Override
    public DataSourceParseResults loadDataSources(@NotNull List<DBPDataSourceConfigurationStorage> storages, @NotNull DataSourceConfigurationManager manager, @Nullable Collection<String> dataSourceIds, boolean refresh, boolean purgeUntouched) {
        if (!this.project.isOpen() || this.project.isInMemory()) {
            return null;
        }
        this.savedFilters.clear();
        DataSourceParseResults parseResults = new DataSourceParseResults();
        for (DBPDataSourceConfigurationStorage dBPDataSourceConfigurationStorage : storages) {
            if (this.loadDataSources(dBPDataSourceConfigurationStorage, manager, dataSourceIds, parseResults) || this.lastError == null) continue;
            return null;
        }
        if (refresh) {
            for (DBPDataSourceContainer dBPDataSourceContainer : parseResults.updatedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dBPDataSourceContainer);
            }
            for (DBPDataSourceContainer dBPDataSourceContainer : parseResults.addedDataSources) {
                this.addDataSourceToList(dBPDataSourceContainer);
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)dBPDataSourceContainer);
            }
            for (DBPDataSourceFolder dBPDataSourceFolder : parseResults.addedFolders) {
                this.addDataSourceFolder((DataSourceFolder)dBPDataSourceFolder);
            }
            if (purgeUntouched) {
                for (DataSourceDescriptor dataSourceDescriptor : this.dataSources.values()) {
                    if (parseResults.addedDataSources.contains(dataSourceDescriptor) || parseResults.updatedDataSources.contains(dataSourceDescriptor) || dataSourceDescriptor.isProvided() || dataSourceDescriptor.isExternallyProvided() || dataSourceDescriptor.isDetached()) continue;
                    parseResults.removedDataSources.add(dataSourceDescriptor);
                }
                for (DBPDataSourceContainer dBPDataSourceContainer : parseResults.removedDataSources) {
                    this.dataSources.remove(dBPDataSourceContainer.getId());
                    this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dBPDataSourceContainer);
                    dBPDataSourceContainer.dispose();
                }
                for (DataSourceFolder dataSourceFolder : this.dataSourceFolders) {
                    if (parseResults.addedFolders.contains(dataSourceFolder) || parseResults.updatedFolders.contains(dataSourceFolder)) continue;
                    parseResults.removedFolders.add(dataSourceFolder);
                }
                for (DBPDataSourceFolder dBPDataSourceFolder : parseResults.removedFolders) {
                    if (parseResults.addedFolders.contains(dBPDataSourceFolder) || parseResults.updatedFolders.contains(dBPDataSourceFolder) || DataSourceUtils.isFolderHasTemporaryDataSources((DBPDataSourceFolder)dBPDataSourceFolder)) continue;
                    this.dataSourceFolders.remove(dBPDataSourceFolder);
                    dBPDataSourceFolder.setParent(null);
                }
            }
        }
        this.updateProjectNature();
        return parseResults;
    }

    protected boolean loadDataSources(@NotNull DBPDataSourceConfigurationStorage storage, @NotNull DataSourceConfigurationManager manager, @Nullable Collection<String> dataSourceIds, @NotNull DataSourceParseResults parseResults) {
        boolean configChanged = false;
        try {
            DataSourceSerializer<T> serializer = storage instanceof DataSourceFileStorage && ((DataSourceFileStorage)storage).isLegacy() ? new DataSourceSerializerLegacy(this) : this.createModernSerializer();
            configChanged = serializer.parseDataSources(storage, manager, parseResults, dataSourceIds);
            this.lastError = null;
        }
        catch (Exception ex) {
            this.lastError = ex;
            log.error((Object)("Error loading datasource config from " + storage.getStorageId()), (Throwable)ex);
        }
        return configChanged;
    }

    @NotNull
    protected DataSourceSerializer<T> createModernSerializer() {
        return new DataSourceSerializerModern(this);
    }

    @Override
    public void saveDataSources() {
        this.saveDataSources((DBRProgressMonitor)new VoidProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDataSources(DBRProgressMonitor monitor) {
        if (this.project.isInMemory()) {
            return;
        }
        this.updateProjectNature();
        this.saveInProgress = true;
        try {
            for (DBPDataSourceConfigurationStorage storage : this.storages) {
                if (storage instanceof DataSourceFileStorage && ((DataSourceFileStorage)storage).isLegacy()) {
                    ((DataSourceFileStorage)storage).convertToModern(this.project);
                }
                List<T> localDataSources = this.getDataSources(storage);
                try {
                    DataSourceSerializer<T> serializer = this.createModernSerializer();
                    serializer.saveDataSources(monitor, this.configurationManager, storage, localDataSources);
                    try {
                        if (this.project.isUseSecretStorage() && !this.configurationManager.isSecure()) {
                            DBSSecretController.getProjectSecretController((DBPProject)this.project).flushChanges();
                        }
                        this.lastError = null;
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error saving secured preferences", e);
                        this.lastError = e;
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Error saving datasources configuration", (Throwable)ex);
                    this.lastError = ex;
                }
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getDataSources(DBPDataSourceConfigurationStorage storage) {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
        Map<String, T> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor ds : this.dataSources.values()) {
                if (!CommonUtils.equalObjects((Object)ds.getStorage(), (Object)storage)) continue;
                result.add(ds);
            }
        }
        return result;
    }

    private void updateProjectNature() {
        DBPProject dBPProject = this.project;
        if (dBPProject instanceof BaseProjectImpl) {
            BaseProjectImpl bp = (BaseProjectImpl)dBPProject;
            bp.updateProjectNature();
        }
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    @Override
    public DataSourceConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public String toString() {
        return this.project.getName() + " (" + this.getClass().getSimpleName() + ")";
    }

    @Override
    public void saveConfigurationToManager(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceConfigurationManager configurationManager, @Nullable Predicate<DBPDataSourceContainer> filter) {
        List<T> localDataSources = this.getDataSources();
        if (filter != null) {
            localDataSources.removeIf(filter.negate());
        }
        try {
            DataSourceSerializer<T> serializer = this.createModernSerializer();
            serializer.saveDataSources(monitor, configurationManager, this.getDefaultStorage(), localDataSources);
            try {
                if (!configurationManager.isSecure()) {
                    DBSSecretController.getProjectSecretController((DBPProject)this.project).flushChanges();
                }
                this.lastError = null;
            }
            catch (Throwable e) {
                this.lastError = e;
                log.error((Object)"Error saving secured preferences", e);
            }
        }
        catch (Exception ex) {
            this.lastError = ex;
            log.error((Object)"Error saving datasources configuration", (Throwable)ex);
        }
    }

    public void checkForErrors() throws DBException {
        Throwable lastError = this.getLastError();
        if (lastError != null) {
            if (lastError instanceof DBException) {
                throw (DBException)lastError;
            }
            throw new DBException(lastError.getMessage(), lastError.getCause());
        }
    }

    public void persistSecrets(DBSSecretController secretController) throws DBException {
        for (DBPDataSourceContainer ds : this.getDataSources()) {
            ds.persistSecrets(secretController);
        }
        for (DBWNetworkProfile np : this.getNetworkProfiles()) {
            np.persistSecrets(secretController);
        }
        for (DBAAuthProfile ap : this.getAllAuthProfiles()) {
            ap.persistSecrets(secretController);
        }
    }

    public void resolveSecrets(DBSSecretController secretController) throws DBException {
        for (DBPDataSourceContainer ds : this.getDataSources()) {
            ds.resolveSecrets(secretController);
        }
        for (DBWNetworkProfile np : this.getNetworkProfiles()) {
            np.resolveSecrets(secretController);
        }
        for (DBAAuthProfile ap : this.getAllAuthProfiles()) {
            ap.resolveSecrets(secretController);
        }
    }

    public DBPDataSourceContainer createDataSource(DBPDataSourceConfigurationStorage dbpDataSourceConfigurationStorage, DBPDataSourceOrigin origin, String id, DriverDescriptor originalDriver, DriverDescriptor substitutedDriver, DBPConnectionConfiguration dbpConnectionConfiguration) {
        return new DataSourceDescriptor(this, dbpDataSourceConfigurationStorage, origin, id, originalDriver, substitutedDriver, dbpConnectionConfiguration);
    }

    private class EventProcessJob
    extends Job {
        public EventProcessJob() {
            super("Notify datasource events");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            DataSourceRegistry.this.flushDataSourceEvents();
            return Status.OK_STATUS;
        }
    }

    private class DisconnectTask
    implements DBRRunnableWithProgress {
        boolean disconnected;

        private DisconnectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(DBRProgressMonitor monitor) {
            List dsSnapshot;
            monitor = new ProxyProgressMonitor(this, (DBRProgressMonitor)monitor){

                public boolean isCanceled() {
                    return false;
                }
            };
            Map map = DataSourceRegistry.this.dataSources;
            synchronized (map) {
                dsSnapshot = CommonUtils.copyList(DataSourceRegistry.this.dataSources.values());
            }
            monitor.beginTask("Disconnect all databases", dsSnapshot.size());
            try {
                for (DataSourceDescriptor dataSource : dsSnapshot) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    if (dataSource.isConnected()) {
                        try {
                            monitor.subTask("Disconnect from [" + dataSource.getName() + "]");
                            this.disconnected = dataSource.disconnect((DBRProgressMonitor)monitor);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Can't shutdown data source '" + dataSource.getName() + "'"), (Throwable)ex);
                        }
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Datasource configuration save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            DataSourceRegistry dataSourceRegistry = DataSourceRegistry.this;
            synchronized (dataSourceRegistry) {
                DataSourceRegistry.this.saveDataSources(monitor);
            }
            return Status.OK_STATUS;
        }
    }
}

