﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mgn/MgnRequest.h>
#include <aws/mgn/Mgn_EXPORTS.h>

#include <utility>

namespace Aws {
namespace mgn {
namespace Model {

/**
 */
class DeleteLaunchConfigurationTemplateRequest : public MgnRequest {
 public:
  AWS_MGN_API DeleteLaunchConfigurationTemplateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLaunchConfigurationTemplate"; }

  AWS_MGN_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>ID of resource to be deleted.</p>
   */
  inline const Aws::String& GetLaunchConfigurationTemplateID() const { return m_launchConfigurationTemplateID; }
  inline bool LaunchConfigurationTemplateIDHasBeenSet() const { return m_launchConfigurationTemplateIDHasBeenSet; }
  template <typename LaunchConfigurationTemplateIDT = Aws::String>
  void SetLaunchConfigurationTemplateID(LaunchConfigurationTemplateIDT&& value) {
    m_launchConfigurationTemplateIDHasBeenSet = true;
    m_launchConfigurationTemplateID = std::forward<LaunchConfigurationTemplateIDT>(value);
  }
  template <typename LaunchConfigurationTemplateIDT = Aws::String>
  DeleteLaunchConfigurationTemplateRequest& WithLaunchConfigurationTemplateID(LaunchConfigurationTemplateIDT&& value) {
    SetLaunchConfigurationTemplateID(std::forward<LaunchConfigurationTemplateIDT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_launchConfigurationTemplateID;
  bool m_launchConfigurationTemplateIDHasBeenSet = false;
};

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
