"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.nodonPilotWire = void 0;
const zigbee_herdsman_1 = require("zigbee-herdsman");
const exposes = __importStar(require("./exposes"));
const logger_1 = require("./logger");
const modernExtend_1 = require("./modernExtend");
const reporting = __importStar(require("./reporting"));
const utils = __importStar(require("./utils"));
const e = exposes.presets;
const NS = "zhc:nodon";
const PILOT_WIRE_CLUSTER = "customClusterNodOnPilotWire";
const manufacturerOptions = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.NODON };
const pilotWireCluster = (0, modernExtend_1.deviceAddCustomCluster)(PILOT_WIRE_CLUSTER, {
    ID: 0xfc00,
    manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.NODON,
    attributes: {
        mode: { ID: 0x0000, type: zigbee_herdsman_1.Zcl.DataType.UINT8, write: true, max: 0xff },
    },
    commands: {
        setMode: {
            ID: 0x0000,
            parameters: [{ name: "mode", type: zigbee_herdsman_1.Zcl.DataType.UINT8, max: 0xff }],
        },
    },
    commandsResponse: {},
});
const pilotWireConfig = (configureReporting) => {
    return {
        exposes: [e.pilot_wire_mode()],
        fromZigbee: [
            {
                cluster: PILOT_WIRE_CLUSTER,
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    const payload = {};
                    const mode = msg.data.mode;
                    if (mode === 0x00)
                        payload.pilot_wire_mode = "off";
                    else if (mode === 0x01)
                        payload.pilot_wire_mode = "comfort";
                    else if (mode === 0x02)
                        payload.pilot_wire_mode = "eco";
                    else if (mode === 0x03)
                        payload.pilot_wire_mode = "frost_protection";
                    else if (mode === 0x04)
                        payload.pilot_wire_mode = "comfort_-1";
                    else if (mode === 0x05)
                        payload.pilot_wire_mode = "comfort_-2";
                    else {
                        logger_1.logger.warning(`wrong mode : ${mode}`, NS);
                        payload.pilot_wire_mode = "unknown";
                    }
                    return payload;
                },
            },
        ],
        toZigbee: [
            {
                key: ["pilot_wire_mode"],
                convertSet: async (entity, key, value, meta) => {
                    const mode = utils.getFromLookup(value, {
                        off: 0x00,
                        comfort: 0x01,
                        eco: 0x02,
                        frost_protection: 0x03,
                        "comfort_-1": 0x04,
                        "comfort_-2": 0x05,
                    });
                    const payload = { mode: mode };
                    await entity.command(PILOT_WIRE_CLUSTER, "setMode", payload);
                    return { state: { pilot_wire_mode: value } };
                },
                convertGet: async (entity, key, meta) => {
                    await entity.read(PILOT_WIRE_CLUSTER, [0x0000], manufacturerOptions);
                },
            },
        ],
        configure: [
            async (device, coordinatorEndpoint) => {
                const ep = device.getEndpoint(1);
                await reporting.bind(ep, coordinatorEndpoint, [PILOT_WIRE_CLUSTER]);
                if (configureReporting) {
                    const p = reporting.payload("mode", 0, 120, 0, { min: 1, max: 3600, change: 0 });
                    await ep.configureReporting(PILOT_WIRE_CLUSTER, p);
                }
                else {
                    await ep.read(PILOT_WIRE_CLUSTER, ["mode"]);
                }
            },
        ],
        isModernExtend: true,
    };
};
const nodonPilotWire = (configureReporting) => [pilotWireCluster, pilotWireConfig(configureReporting)];
exports.nodonPilotWire = nodonPilotWire;
//# sourceMappingURL=nodon.js.map