/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnInstaller;
import org.zaproxy.zap.control.NullUninstallationProgressCallBack;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

class PostponedTasksRunner {
    private static final Logger LOGGER = LogManager.getLogger(PostponedTasksRunner.class);
    private static final String TASKS_BASE_KEY = "postponedTasks";
    private static final String TASKS_KEY = "postponedTasks.task";
    private final ZapXmlConfiguration config;
    private final AddOnCollection aoc;
    private final List<Task> tasks;

    PostponedTasksRunner(ZapXmlConfiguration config, AddOnCollection aoc) {
        this.config = config;
        this.aoc = aoc;
        this.tasks = PostponedTasksRunner.readTasks(config);
    }

    List<Task> getTasks() {
        return this.tasks;
    }

    private static List<Task> readTasks(ZapXmlConfiguration config) {
        List savedTasks = config.configurationsAt(TASKS_KEY);
        ArrayList<Task> tasks = new ArrayList<Task>(0);
        for (HierarchicalConfiguration savedTask : savedTasks) {
            Task task = PostponedTasksRunner.createTask(savedTask);
            if (task == null) continue;
            tasks.add(task);
        }
        return tasks;
    }

    public void run() {
        Iterator<Task> it = this.tasks.iterator();
        while (it.hasNext()) {
            it.next().execute(this.aoc);
            it.remove();
        }
        this.saveTasks();
    }

    public void addUninstallAddOnTask(AddOn addOn) {
        this.tasks.add(new UninstallAddOnTask(addOn));
        this.saveTasks();
    }

    public void addDeleteFileTask(Path path) {
        this.tasks.add(new DeleteFileTask(path));
        this.saveTasks();
    }

    private void saveTasks() {
        this.config.clearTree(TASKS_BASE_KEY);
        try {
            int i = 0;
            for (Task task : this.tasks) {
                task.save(this.config, "postponedTasks.task(" + i + ").");
                ++i;
            }
            this.config.save();
        }
        catch (Exception e) {
            LOGGER.error("Failed to save the postponed tasks:", (Throwable)e);
        }
    }

    private static Task createTask(HierarchicalConfiguration data) {
        Task.Type type = PostponedTasksRunner.readType(data);
        if (type == null) {
            return null;
        }
        switch (type) {
            case UNINSTALL_ADD_ON: {
                return UninstallAddOnTask.create(data);
            }
            case DELETE_FILE: {
                return DeleteFileTask.create(data);
            }
        }
        LOGGER.error("Ignoring unsupported postponed task type: {}", (Object)type);
        return null;
    }

    private static Task.Type readType(HierarchicalConfiguration savedData) {
        String typeName = savedData.getString("type", "");
        if (typeName.isBlank()) {
            return null;
        }
        try {
            return Task.Type.valueOf(typeName);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create postponed task type: {}", (Object)typeName);
            return null;
        }
    }

    static abstract class Task {
        private static final String TYPE_KEY = "type";
        private final Type type;

        protected Task(Type type) {
            this.type = type;
        }

        Type getType() {
            return this.type;
        }

        abstract void execute(AddOnCollection var1);

        final void save(ZapXmlConfiguration config, String keyPrefix) {
            config.setProperty(keyPrefix + TYPE_KEY, this.type.name());
            this.saveData(config, keyPrefix);
        }

        protected abstract void saveData(ZapXmlConfiguration var1, String var2);

        static enum Type {
            UNINSTALL_ADD_ON,
            DELETE_FILE;

        }
    }

    static class UninstallAddOnTask
    extends Task {
        private static final String ADD_ON_KEY = "addOn";
        private final AddOn addOn;

        private UninstallAddOnTask(AddOn addOn) {
            super(Task.Type.UNINSTALL_ADD_ON);
            this.addOn = addOn;
        }

        AddOn getAddOn() {
            return this.addOn;
        }

        @Override
        void execute(AddOnCollection aoc) {
            LOGGER.info("Executing postponed task, uninstalling add-on: {}", (Object)this.addOn);
            AddOnInstaller.uninstallAddOnFiles(this.addOn, NullUninstallationProgressCallBack.getSingleton(), Collections.emptySet(), null);
            AddOnInstaller.uninstallAddOnLibs(this.addOn);
            AddOn presentAddOn = aoc.getAddOn(this.addOn.getId());
            if (presentAddOn != null && this.addOn.getFile().equals(presentAddOn.getFile())) {
                aoc.removeAddOn(presentAddOn);
            }
            Path path = this.addOn.getFile().toPath();
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete add-on file: {}", (Object)path, (Object)e);
            }
        }

        @Override
        protected void saveData(ZapXmlConfiguration config, String keyPrefix) {
            config.setProperty(keyPrefix + ADD_ON_KEY, this.addOn.getFile().toPath().toAbsolutePath().normalize().toString());
        }

        static UninstallAddOnTask create(HierarchicalConfiguration data) {
            AddOn addOn;
            String path = data.getString(ADD_ON_KEY, "");
            if (path.isBlank()) {
                return null;
            }
            Path file = Paths.get(path, new String[0]);
            if (Files.notExists(file, new LinkOption[0])) {
                LOGGER.warn("Ignoring postponed task, add-on file no longer exists: {}", (Object)path);
                return null;
            }
            try {
                addOn = new AddOn(file);
            }
            catch (IOException e) {
                LOGGER.warn("Ignoring postponed task, add-on file is not valid: {}", (Object)path, (Object)e);
                return null;
            }
            return new UninstallAddOnTask(addOn);
        }
    }

    static class DeleteFileTask
    extends Task {
        private static final String FILE_KEY = "file";
        private final Path file;

        private DeleteFileTask(Path file) {
            super(Task.Type.DELETE_FILE);
            this.file = file;
        }

        Path getFile() {
            return this.file;
        }

        @Override
        void execute(AddOnCollection aoc) {
            LOGGER.info("Executing postponed task, deleting bundled add-on file: {}", (Object)this.file);
            try {
                Files.delete(this.file);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete the file: {}", (Object)this.file, (Object)e);
            }
        }

        @Override
        protected void saveData(ZapXmlConfiguration config, String keyPrefix) {
            config.setProperty(keyPrefix + FILE_KEY, this.file.toAbsolutePath().normalize().toString());
        }

        static DeleteFileTask create(HierarchicalConfiguration data) {
            String path = data.getString(FILE_KEY, "");
            if (path == null || path.isBlank()) {
                return null;
            }
            Path file = Paths.get(path, new String[0]);
            if (Files.notExists(file, new LinkOption[0])) {
                LOGGER.warn("Ignoring postponed task, add-on bundled file no longer exists: {}", (Object)path);
                return null;
            }
            Path homeDir = Paths.get(Constant.getZapHome(), new String[0]);
            if (!file.startsWith(homeDir)) {
                LOGGER.warn("Ignoring postponed task, add-on bundled file is not under the home directory: {}", (Object)path);
                return null;
            }
            return new DeleteFileTask(file);
        }
    }
}

