/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AccessLogAdapter;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.MultiThrowable;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.InlineExecutorService;

public abstract class ContainerBase
extends LifecycleMBeanBase
implements Container {
    private static final Log log = LogFactory.getLog(ContainerBase.class);
    protected final HashMap<String, Container> children = new HashMap();
    private final ReadWriteLock childrenLock = new ReentrantReadWriteLock();
    protected int backgroundProcessorDelay = -1;
    protected ScheduledFuture<?> backgroundProcessorFuture;
    protected ScheduledFuture<?> monitorFuture;
    protected final List<ContainerListener> listeners = new CopyOnWriteArrayList<ContainerListener>();
    protected Log logger = null;
    protected String logName = null;
    protected Cluster cluster = null;
    private final ReadWriteLock clusterLock = new ReentrantReadWriteLock();
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected final Pipeline pipeline = new StandardPipeline(this);
    private volatile Realm realm = null;
    private final ReadWriteLock realmLock = new ReentrantReadWriteLock();
    protected static final StringManager sm = StringManager.getManager(ContainerBase.class);
    protected boolean startChildren = true;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected volatile AccessLog accessLog = null;
    private volatile boolean accessLogScanComplete = false;
    private int startStopThreads = 1;
    protected ExecutorService startStopExecutor;

    @Override
    public int getStartStopThreads() {
        return this.startStopThreads;
    }

    @Override
    public void setStartStopThreads(int n) {
        int n2 = this.startStopThreads;
        this.startStopThreads = n;
        if (n2 != n && this.startStopExecutor != null) {
            this.reconfigureStartStopExecutor(this.getStartStopThreads());
        }
    }

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int n) {
        this.backgroundProcessorDelay = n;
    }

    @Override
    public Log getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        this.logger = LogFactory.getLog((String)this.getLogName());
        return this.logger;
    }

    @Override
    public String getLogName() {
        if (this.logName != null) {
            return this.logName;
        }
        String string = null;
        for (Container container = this; container != null; container = container.getParent()) {
            String string2 = container.getName();
            if (string2 == null || string2.isEmpty()) {
                string2 = "/";
            } else if (string2.startsWith("##")) {
                string2 = "/" + string2;
            }
            string = "[" + string2 + "]" + (string != null ? "." + string : "");
        }
        this.logName = ContainerBase.class.getName() + "." + string;
        return this.logName;
    }

    @Override
    public Cluster getCluster() {
        Lock lock = this.clusterLock.readLock();
        lock.lock();
        try {
            if (this.cluster != null) {
                Cluster cluster = this.cluster;
                return cluster;
            }
            if (this.parent != null) {
                Cluster cluster = this.parent.getCluster();
                return cluster;
            }
            Cluster cluster = null;
            return cluster;
        }
        finally {
            lock.unlock();
        }
    }

    protected Cluster getClusterInternal() {
        Lock lock = this.clusterLock.readLock();
        lock.lock();
        try {
            Cluster cluster = this.cluster;
            return cluster;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCluster(Cluster cluster) {
        Cluster cluster2;
        Lock lock = this.clusterLock.writeLock();
        lock.lock();
        try {
            cluster2 = this.cluster;
            if (cluster2 == cluster) {
                return;
            }
            this.cluster = cluster;
            if (cluster != null) {
                cluster.setContainer(this);
            }
        }
        finally {
            lock.unlock();
        }
        if (this.getState().isAvailable() && cluster2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("containerBase.cluster.stop"), (Throwable)lifecycleException);
            }
        }
        if (this.getState().isAvailable() && cluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster)).start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("containerBase.cluster.start"), (Throwable)lifecycleException);
            }
        }
        this.support.firePropertyChange("cluster", cluster2, cluster);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("containerBase.nullName"));
        }
        String string2 = this.name;
        this.name = string;
        this.support.firePropertyChange("name", string2, this.name);
    }

    public boolean getStartChildren() {
        return this.startChildren;
    }

    public void setStartChildren(boolean bl) {
        boolean bl2 = this.startChildren;
        this.startChildren = bl;
        this.support.firePropertyChange("startChildren", bl2, this.startChildren);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container container2 = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", container2, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Realm getRealm() {
        Lock lock = this.realmLock.readLock();
        lock.lock();
        try {
            if (this.realm != null) {
                Realm realm = this.realm;
                return realm;
            }
            if (this.parent != null) {
                Realm realm = this.parent.getRealm();
                return realm;
            }
            Realm realm = null;
            return realm;
        }
        finally {
            lock.unlock();
        }
    }

    protected Realm getRealmInternal() {
        Lock lock = this.realmLock.readLock();
        lock.lock();
        try {
            Realm realm = this.realm;
            return realm;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRealm(Realm realm) {
        Realm realm2;
        Lock lock = this.realmLock.writeLock();
        lock.lock();
        try {
            realm2 = this.realm;
            if (realm2 == realm) {
                return;
            }
            this.realm = realm;
            if (realm != null) {
                realm.setContainer(this);
            }
        }
        finally {
            lock.unlock();
        }
        if (this.getState().isAvailable() && realm2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("containerBase.realm.stop"), (Throwable)lifecycleException);
            }
        }
        if (this.getState().isAvailable() && realm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm)).start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("containerBase.realm.start"), (Throwable)lifecycleException);
            }
        }
        this.support.firePropertyChange("realm", realm2, this.realm);
    }

    @Override
    public void addChild(Container container) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild privilegedAddChild = new PrivilegedAddChild(container);
            AccessController.doPrivileged(privilegedAddChild);
        } else {
            this.addChildInternal(container);
        }
    }

    private void addChildInternal(Container container) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("containerBase.child.add", new Object[]{container, this}));
        }
        this.childrenLock.writeLock().lock();
        try {
            if (this.children.get(container.getName()) != null) {
                throw new IllegalArgumentException(sm.getString("containerBase.child.notUnique", new Object[]{container.getName()}));
            }
            container.setParent(this);
            this.children.put(container.getName(), container);
        }
        finally {
            this.childrenLock.writeLock().unlock();
        }
        this.fireContainerEvent("addChild", container);
        try {
            if ((this.getState().isAvailable() || LifecycleState.STARTING_PREP.equals((Object)this.getState())) && this.startChildren) {
                container.start();
            }
        }
        catch (LifecycleException lifecycleException) {
            throw new IllegalStateException(sm.getString("containerBase.child.start"), lifecycleException);
        }
    }

    @Override
    public void addContainerListener(ContainerListener containerListener) {
        this.listeners.add(containerListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Container findChild(String string) {
        if (string == null) {
            return null;
        }
        this.childrenLock.readLock().lock();
        try {
            Container container = this.children.get(string);
            return container;
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
    }

    @Override
    public Container[] findChildren() {
        this.childrenLock.readLock().lock();
        try {
            Container[] containerArray = this.children.values().toArray(new Container[0]);
            return containerArray;
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
    }

    @Override
    public ContainerListener[] findContainerListeners() {
        return this.listeners.toArray(new ContainerListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(Container container) {
        if (container == null) {
            return;
        }
        try {
            if (container.getState().isAvailable()) {
                container.stop();
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)sm.getString("containerBase.child.stop"), (Throwable)lifecycleException);
        }
        boolean bl = false;
        try {
            if (!LifecycleState.DESTROYING.equals((Object)container.getState())) {
                container.destroy();
                bl = true;
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)sm.getString("containerBase.child.destroy"), (Throwable)lifecycleException);
        }
        if (!bl) {
            this.fireContainerEvent("removeChild", container);
        }
        this.childrenLock.writeLock().lock();
        try {
            this.children.remove(container.getName());
        }
        finally {
            this.childrenLock.writeLock().unlock();
        }
    }

    @Override
    public void removeContainerListener(ContainerListener containerListener) {
        this.listeners.remove(containerListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private void reconfigureStartStopExecutor(int n) {
        if (n == 1) {
            if (!(this.startStopExecutor instanceof InlineExecutorService)) {
                this.startStopExecutor = new InlineExecutorService();
            }
        } else {
            Server server = Container.getService(this).getServer();
            server.setUtilityThreads(n);
            this.startStopExecutor = server.getUtilityExecutor();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void startInternal() throws LifecycleException {
        void future;
        Realm realm;
        this.reconfigureStartStopExecutor(this.getStartStopThreads());
        this.logger = null;
        this.getLogger();
        Cluster cluster = this.getClusterInternal();
        if (cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)cluster)).start();
        }
        if ((realm = this.getRealmInternal()) instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).start();
        }
        MultiThrowable multiThrowable = this.findChildren();
        ArrayList<Future<Void>> arrayList = new ArrayList<Future<Void>>(((Container[])multiThrowable).length);
        MultiThrowable multiThrowable2 = multiThrowable;
        int n = ((Container[])multiThrowable2).length;
        boolean bl = false;
        while (future < n) {
            Container throwable = multiThrowable2[future];
            arrayList.add(this.startStopExecutor.submit(new StartChild(throwable)));
            ++future;
        }
        multiThrowable2 = null;
        for (Future future2 : arrayList) {
            try {
                future2.get();
            }
            catch (Throwable throwable) {
                log.error((Object)sm.getString("containerBase.threadedStartFailed"), throwable);
                if (multiThrowable2 == null) {
                    multiThrowable2 = new MultiThrowable();
                }
                multiThrowable2.add(throwable);
            }
        }
        if (multiThrowable2 != null) {
            throw new LifecycleException(sm.getString("containerBase.threadedStartFailed"), multiThrowable2.getThrowable());
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.setState(LifecycleState.STARTING);
        if (this.backgroundProcessorDelay > 0) {
            this.monitorFuture = Container.getService(this).getServer().getUtilityExecutor().scheduleWithFixedDelay(new ContainerBackgroundProcessorMonitor(), 0L, 60L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        Cluster cluster;
        void future;
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        this.threadStop();
        this.setState(LifecycleState.STOPPING);
        if (this.pipeline instanceof Lifecycle && ((Lifecycle)((Object)this.pipeline)).getState().isAvailable()) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] containerArray = this.findChildren();
        ArrayList<Future<Void>> arrayList = new ArrayList<Future<Void>>(containerArray.length);
        Container[] containerArray2 = containerArray;
        int n = containerArray2.length;
        boolean bl = false;
        while (future < n) {
            Container exception = containerArray2[future];
            arrayList.add(this.startStopExecutor.submit(new StopChild(exception)));
            ++future;
        }
        boolean bl2 = false;
        for (Future cluster2 : arrayList) {
            try {
                cluster2.get();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("containerBase.threadedStopFailed"), (Throwable)exception);
                bl2 = true;
            }
        }
        if (bl2) {
            throw new LifecycleException(sm.getString("containerBase.threadedStopFailed"));
        }
        Realm realm = this.getRealmInternal();
        if (realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).stop();
        }
        if ((cluster = this.getClusterInternal()) instanceof Lifecycle) {
            ((Lifecycle)((Object)cluster)).stop();
        }
        if (this.startStopExecutor != null) {
            this.startStopExecutor.shutdownNow();
            this.startStopExecutor = null;
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        Cluster cluster;
        Realm realm = this.getRealmInternal();
        if (realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).destroy();
        }
        if ((cluster = this.getClusterInternal()) instanceof Lifecycle) {
            ((Lifecycle)((Object)cluster)).destroy();
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).destroy();
        }
        for (Container container : this.findChildren()) {
            this.removeChild(container);
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        super.destroyInternal();
    }

    @Override
    public void logAccess(Request request, Response response, long l, boolean bl) {
        boolean bl2 = false;
        if (this.getAccessLog() != null) {
            this.getAccessLog().log(request, response, l);
            bl2 = true;
        }
        if (this.getParent() != null) {
            this.getParent().logAccess(request, response, l, bl && !bl2);
        }
    }

    @Override
    public AccessLog getAccessLog() {
        Valve[] valveArray;
        if (this.accessLogScanComplete) {
            return this.accessLog;
        }
        AccessLogAdapter accessLogAdapter = null;
        for (Valve valve : valveArray = this.getPipeline().getValves()) {
            if (!(valve instanceof AccessLog)) continue;
            if (accessLogAdapter == null) {
                accessLogAdapter = new AccessLogAdapter((AccessLog)((Object)valve));
                continue;
            }
            accessLogAdapter.add((AccessLog)((Object)valve));
        }
        if (accessLogAdapter != null) {
            this.accessLog = accessLogAdapter;
        }
        this.accessLogScanComplete = true;
        return this.accessLog;
    }

    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
    }

    @Override
    public synchronized void backgroundProcess() {
        Realm realm;
        if (!this.getState().isAvailable()) {
            return;
        }
        Cluster cluster = this.getClusterInternal();
        if (cluster != null) {
            try {
                cluster.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.cluster", new Object[]{cluster}), (Throwable)exception);
            }
        }
        if ((realm = this.getRealmInternal()) != null) {
            try {
                realm.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.realm", new Object[]{realm}), (Throwable)exception);
            }
        }
        for (Valve valve = this.pipeline.getFirst(); valve != null; valve = valve.getNext()) {
            try {
                valve.backgroundProcess();
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.valve", new Object[]{valve}), (Throwable)exception);
            }
        }
        this.fireLifecycleEvent("periodic", null);
    }

    @Override
    public File getCatalinaBase() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCatalinaBase();
    }

    @Override
    public File getCatalinaHome() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCatalinaHome();
    }

    @Override
    public void fireContainerEvent(String string, Object object) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ContainerEvent containerEvent = new ContainerEvent(this, string, object);
        for (ContainerListener containerListener : this.listeners) {
            containerListener.containerEvent(containerEvent);
        }
    }

    @Override
    protected String getDomainInternal() {
        Container container = this.getParent();
        if (container == null) {
            return null;
        }
        return container.getDomain();
    }

    @Override
    public String getMBeanKeyProperties() {
        Container container = this;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (!(container instanceof Engine)) {
            if (container instanceof Wrapper) {
                stringBuilder.insert(0, ",servlet=");
                stringBuilder.insert(9, container.getName());
            } else if (container instanceof Context) {
                stringBuilder.insert(0, ",context=");
                ContextName contextName = new ContextName(container.getName(), false);
                stringBuilder.insert(9, contextName.getDisplayName());
            } else if (container instanceof Host) {
                stringBuilder.insert(0, ",host=");
                stringBuilder.insert(6, container.getName());
            } else {
                if (container == null) {
                    stringBuilder.append(",container");
                    stringBuilder.append(n);
                    stringBuilder.append("=null");
                    break;
                }
                stringBuilder.append(",container");
                stringBuilder.append(n++);
                stringBuilder.append('=');
                stringBuilder.append(container.getName());
            }
            container = container.getParent();
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getChildren() {
        ArrayList<ObjectName> arrayList;
        this.childrenLock.readLock().lock();
        try {
            arrayList = new ArrayList<ObjectName>(this.children.size());
            for (Container container : this.children.values()) {
                if (!(container instanceof ContainerBase)) continue;
                arrayList.add(container.getObjectName());
            }
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
        return arrayList.toArray(new ObjectName[0]);
    }

    protected void threadStart() {
        if (this.backgroundProcessorDelay > 0 && (this.getState().isAvailable() || LifecycleState.STARTING_PREP.equals((Object)this.getState())) && (this.backgroundProcessorFuture == null || this.backgroundProcessorFuture.isDone())) {
            if (this.backgroundProcessorFuture != null && this.backgroundProcessorFuture.isDone()) {
                try {
                    this.backgroundProcessorFuture.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    log.error((Object)sm.getString("containerBase.backgroundProcess.error"), (Throwable)exception);
                }
            }
            this.backgroundProcessorFuture = Container.getService(this).getServer().getUtilityExecutor().scheduleWithFixedDelay(new ContainerBackgroundProcessor(), this.backgroundProcessorDelay, this.backgroundProcessorDelay, TimeUnit.SECONDS);
        }
    }

    protected void threadStop() {
        if (this.backgroundProcessorFuture != null) {
            this.backgroundProcessorFuture.cancel(true);
            this.backgroundProcessorFuture = null;
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Container container = this.getParent();
        if (container != null) {
            stringBuilder.append(container);
            stringBuilder.append('.');
        }
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('[');
        stringBuilder.append(this.getName());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction<Void> {
        private final Container child;

        PrivilegedAddChild(Container container) {
            this.child = container;
        }

        @Override
        public Void run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }

    private static class StartChild
    implements Callable<Void> {
        private final Container child;

        StartChild(Container container) {
            this.child = container;
        }

        @Override
        public Void call() throws LifecycleException {
            this.child.start();
            return null;
        }
    }

    protected class ContainerBackgroundProcessorMonitor
    implements Runnable {
        protected ContainerBackgroundProcessorMonitor() {
        }

        @Override
        public void run() {
            if (ContainerBase.this.getState().isAvailable()) {
                ContainerBase.this.threadStart();
            }
        }
    }

    private static class StopChild
    implements Callable<Void> {
        private final Container child;

        StopChild(Container container) {
            this.child = container;
        }

        @Override
        public Void call() throws LifecycleException {
            if (this.child.getState().isAvailable()) {
                this.child.stop();
            }
            return null;
        }
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        @Override
        public void run() {
            this.processChildren(ContainerBase.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void processChildren(Container var1_1) {
            block10: {
                var2_2 = null;
                if (!(var1_1 instanceof Context)) ** GOTO lbl12
                var3_3 = ((Context)var1_1).getLoader();
                if (var3_3 != null) break block10;
                if (var1_1 instanceof Context) {
                    ((Context)var1_1).unbind(false, var2_2);
                }
                return;
            }
            try {
                var2_2 = ((Context)var1_1).bind(false, null);
lbl12:
                // 2 sources

                var1_1.backgroundProcess();
                for (Container var7_8 : var3_3 = var1_1.findChildren()) {
                    if (var7_8.getBackgroundProcessorDelay() > 0) continue;
                    this.processChildren(var7_8);
                }
            }
            catch (Throwable var3_4) {
                try {
                    ExceptionUtils.handleThrowable((Throwable)var3_4);
                    ContainerBase.access$100().error((Object)ContainerBase.sm.getString("containerBase.backgroundProcess.error"), var3_4);
                }
                catch (Throwable var8_9) {
                    if (var1_1 instanceof Context) {
                        ((Context)var1_1).unbind(false, var2_2);
                    }
                    throw var8_9;
                }
                if (var1_1 instanceof Context) {
                    ((Context)var1_1).unbind(false, var2_2);
                } else {
                    ** GOTO lbl31
                }
            }
            if (var1_1 instanceof Context) {
                ((Context)var1_1).unbind(false, var2_2);
            }
        }
    }
}

