/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class WebdavIfHeader {
    private static final Log log = LogFactory.getLog(WebdavIfHeader.class);
    private static final StringManager sm = StringManager.getManager((String)WebdavIfHeader.class.getPackage().getName());
    private final String headerValue;
    private final IfHeaderInterface ifHeader;
    private final List<String> resources = new ArrayList<String>();
    private final List<String> allTokens = new ArrayList<String>();
    private final List<String> allNotTokens = new ArrayList<String>();
    private String uriPrefix;

    public WebdavIfHeader(String[] stringArray) throws IOException {
        this.allTokens.addAll(Arrays.asList(stringArray));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("(").append("<");
            stringBuilder.append(string);
            stringBuilder.append(">").append(")");
        }
        this.headerValue = stringBuilder.toString();
        this.ifHeader = this.parse();
    }

    public WebdavIfHeader(String string, String string2) throws IOException {
        this.uriPrefix = string;
        this.headerValue = string2;
        this.ifHeader = this.parse();
    }

    public String getHeaderName() {
        return "If";
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public boolean hasValue() {
        return this.ifHeader != null;
    }

    public boolean matches(String string, List<String> list, String string2) {
        if (this.ifHeader == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"matches: No If header, assume match");
            }
            return true;
        }
        return this.ifHeader.matches(string, list, string2);
    }

    public Iterator<String> getResources() {
        return this.resources.iterator();
    }

    public Iterator<String> getAllTokens() {
        return this.allTokens.iterator();
    }

    public Iterator<String> getAllNotTokens() {
        return this.allNotTokens.iterator();
    }

    private IfHeaderInterface parse() throws IOException {
        Cloneable cloneable;
        if (this.headerValue != null && !this.headerValue.isEmpty()) {
            int n = 0;
            try (StringReader stringReader = new StringReader(this.headerValue);){
                try {
                    stringReader.mark(1);
                    n = this.readWhiteSpace(stringReader);
                    stringReader.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n == 40) {
                    cloneable = this.parseUntagged(stringReader);
                }
                if (n == 60) {
                    cloneable = this.parseTagged(stringReader);
                }
                this.logIllegalState("If", n, "(<", null);
                cloneable = null;
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"IfHeader: No If header in request");
            }
            cloneable = null;
        }
        return cloneable;
    }

    private IfHeaderMap parseTagged(StringReader stringReader) throws IOException {
        int n;
        IfHeaderMap ifHeaderMap = new IfHeaderMap();
        while ((n = this.readWhiteSpace(stringReader)) >= 0) {
            if (n == 60) {
                String string = this.readWord(stringReader, '>');
                if (string == null) break;
                ifHeaderMap.put(string, this.parseUntagged(stringReader));
                this.resources.add(string);
                continue;
            }
            this.logIllegalState("Tagged", n, "<", stringReader);
        }
        return ifHeaderMap;
    }

    private IfHeaderList parseUntagged(StringReader stringReader) throws IOException {
        IfHeaderList ifHeaderList = new IfHeaderList();
        while (true) {
            stringReader.mark(1);
            int n = this.readWhiteSpace(stringReader);
            if (n < 0) break;
            if (n == 40) {
                ifHeaderList.add(this.parseIfList(stringReader));
                continue;
            }
            if (n == 60) {
                stringReader.reset();
                break;
            }
            this.logIllegalState("Untagged", n, "(", stringReader);
        }
        return ifHeaderList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IfList parseIfList(StringReader stringReader) throws IOException {
        IfList ifList = new IfList();
        boolean bl = true;
        block6: while (true) {
            int n = this.readWhiteSpace(stringReader);
            switch (n) {
                case 78: 
                case 110: {
                    int n2 = stringReader.read();
                    if (n2 != 111 && n2 != 79) {
                        this.logIllegalState("IfList-Not", n2, "o", null);
                        continue block6;
                    }
                    n2 = stringReader.read();
                    if (n2 != 116 && n2 != 84) {
                        this.logIllegalState("IfList-Not", n2, "t", null);
                        continue block6;
                    }
                    bl = false;
                    continue block6;
                }
                case 60: {
                    String string = this.readWord(stringReader, '>');
                    if (string == null) continue block6;
                    ifList.add(new IfListEntryToken(string, bl));
                    if (bl) {
                        this.allTokens.add(string);
                    } else {
                        this.allNotTokens.add(string);
                    }
                    bl = true;
                    continue block6;
                }
                case 91: {
                    String string = this.readWord(stringReader, ']');
                    if (string == null) continue block6;
                    ifList.add(new IfListEntryEtag(string, bl));
                    bl = true;
                    continue block6;
                }
                case 41: {
                    if (!log.isTraceEnabled()) return ifList;
                    log.trace((Object)"parseIfList: End of If list, terminating loop");
                    return ifList;
                }
                default: {
                    this.logIllegalState("IfList", n, "nN<[)", stringReader);
                    if (n < 0) return ifList;
                    continue block6;
                }
            }
            break;
        }
    }

    private int readWhiteSpace(Reader reader) throws IOException {
        int n = reader.read();
        while (n >= 0 && Character.isWhitespace((char)n)) {
            n = reader.read();
        }
        return n;
    }

    private String readWord(Reader reader, char c) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = reader.read();
        while (n >= 0 && n != c) {
            stringBuilder.append((char)n);
            n = reader.read();
        }
        if (n < 0) {
            log.error((Object)"readWord: Unexpected end of input reading word");
            return null;
        }
        return stringBuilder.toString();
    }

    private void logIllegalState(String string, int n, String string2, StringReader stringReader) {
        String string3 = n < 0 ? "<EOF>" : String.valueOf((char)n);
        log.error((Object)sm.getString("webdavifheader.unexpectedCharacter", new Object[]{string3, string, string2}));
        if (stringReader != null && n >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("logIllegalState: Catch up to any of " + string2));
                }
                do {
                    stringReader.mark(1);
                } while ((n = stringReader.read()) >= 0 && string2.indexOf(n) < 0);
                if (n >= 0) {
                    stringReader.reset();
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("webdavifheader.ioError", new Object[]{string2}));
            }
        }
    }

    private static interface IfHeaderInterface {
        public boolean matches(String var1, List<String> var2, String var3);
    }

    private static class IfHeaderList
    extends ArrayList<IfList>
    implements IfHeaderInterface {
        private static final long serialVersionUID = 1L;

        private IfHeaderList() {
        }

        @Override
        public boolean matches(String string, List<String> list, String string2) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("matches: Trying to match token=" + list + ", etag=" + string2));
            }
            for (IfList ifList : this) {
                if (!ifList.match(list, string2)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("matches: Found match with " + ifList));
                }
                return true;
            }
            return false;
        }
    }

    private class IfHeaderMap
    extends HashMap<String, IfHeaderList>
    implements IfHeaderInterface {
        private static final long serialVersionUID = 1L;

        private IfHeaderMap() {
        }

        @Override
        public boolean matches(String string, List<String> list, String string2) {
            String string3;
            String string4;
            if (log.isTraceEnabled()) {
                log.trace((Object)("matches: Trying to match resource=" + string + ", token=" + list + "," + string2));
            }
            if (string.startsWith("/")) {
                string4 = string;
                string3 = WebdavIfHeader.this.uriPrefix + string;
            } else {
                string4 = string.substring(WebdavIfHeader.this.uriPrefix.length());
                string3 = string;
            }
            IfHeaderList ifHeaderList = (IfHeaderList)this.get(string4);
            if (ifHeaderList == null) {
                ifHeaderList = (IfHeaderList)this.get(string3);
            }
            if (ifHeaderList == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("matches: No entry for tag " + string + ", assuming mismatch"));
                }
                return false;
            }
            return ifHeaderList.matches(string, list, string2);
        }
    }

    private static class IfList
    extends ArrayList<IfListEntry> {
        private static final long serialVersionUID = 1L;

        private IfList() {
        }

        @Override
        public boolean add(IfListEntry ifListEntry) {
            return super.add(ifListEntry);
        }

        @Override
        public void add(int n, IfListEntry ifListEntry) {
            super.add(n, ifListEntry);
        }

        public boolean match(List<String> list, String string) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("match: Trying to match token=" + list + ", etag=" + string));
            }
            for (int i = 0; i < this.size(); ++i) {
                IfListEntry ifListEntry = (IfListEntry)this.get(i);
                boolean bl = false;
                for (String string2 : list) {
                    if (!ifListEntry.match(string2, string)) continue;
                    bl = true;
                }
                if (bl) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("match: Entry " + i + "-" + ifListEntry + " does not match"));
                }
                return false;
            }
            return true;
        }
    }

    private static class IfListEntryToken
    extends IfListEntry {
        IfListEntryToken(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        public boolean match(String string, String string2) {
            return string == null || super.match(string);
        }

        @Override
        protected String getType() {
            return "Token";
        }
    }

    private static abstract class IfListEntry {
        protected final String value;
        protected final boolean positive;
        protected String stringValue;

        protected IfListEntry(String string, boolean bl) {
            this.value = string;
            this.positive = bl;
        }

        protected boolean match(String string) {
            return this.positive == this.value.equals(string);
        }

        public abstract boolean match(String var1, String var2);

        protected abstract String getType();

        protected String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.stringValue == null) {
                this.stringValue = this.getType() + ": " + (this.positive ? "" : "!") + this.getValue();
            }
            return this.stringValue;
        }
    }

    private static class IfListEntryEtag
    extends IfListEntry {
        IfListEntryEtag(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        public boolean match(String string, String string2) {
            return super.match(string2);
        }

        @Override
        protected String getType() {
            return "ETag";
        }
    }
}

