/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.util;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryUtility;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.TableNames;
import com.ibm.db2.cmx.runtime.internal.repository.util.SQLUtilities;
import com.ibm.db2.cmx.runtime.internal.repository.util.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;

public class DumpUtilitiesBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dumpMetadata(Connection connection, String string, OutputStream outputStream, File file) {
        boolean bl2 = false;
        ResultSet resultSet = null;
        PrintStream printStream = null;
        File file2 = null;
        try {
            Object object;
            if (outputStream == null) {
                file2 = File.createTempFile("md_tables", ".txt");
                bl2 = true;
                outputStream = new FileOutputStream(file2);
                System.out.println("dumping tables to file " + file2.getAbsolutePath());
            }
            printStream = new PrintStream(outputStream);
            RepositoryVersionImpl repositoryVersionImpl = RepositoryUtility.getPQRepositoryVersion(connection, string);
            boolean bl3 = repositoryVersionImpl.compareTo(RepositoryVersion.OPMVersion) <= 0;
            List<String> list = null;
            list = bl3 ? Arrays.asList(TableNames.AllTablesV22) : (repositoryVersionImpl.isFullRepository() ? Arrays.asList(TableNames.AllTables) : Arrays.asList(TableNames.COTables));
            if (file != null) {
                printStream.println("All content dumped to directory " + file.getAbsolutePath());
                printStream.println();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list.contains("STMT_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "STMT_T", string + "." + "STMT_T", printStream, null);
                arrayList.add("STMT_T");
            }
            if (list.contains("SRCINFO_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "SRCINFO_T" + " ORDER BY PROJECT_KEY, STACK_ID, STACKTRACEORDER", string + "." + "SRCINFO_T", printStream, null);
                arrayList.add("SRCINFO_T");
            }
            if (list.contains("SRC_STMT_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "SRC_STMT_T" + " ORDER BY STMT_KEY", string + "." + "SRC_STMT_T", printStream, null);
                arrayList.add("SRC_STMT_T");
            }
            if (list.contains("DBINFO_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "DBINFO_T" + " ORDER BY DBPKG_KEY", string + "." + "DBINFO_T", printStream, null);
                arrayList.add("DBINFO_T");
            }
            if (list.contains("DEPTAB_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "DEPTAB_T" + " ORDER BY STMT_KEY", string + "." + "DEPTAB_T", printStream, null);
                arrayList.add("DEPTAB_T");
            }
            if (list.contains("METADATASOURCE_T")) {
                if (file != null) {
                    object = new BlobContentToFileSystem("METADATASRC_KEY", "CONTENT", file, "METADATASOURCE_T", printStream);
                    DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "METADATASOURCE_T" + " ORDER BY METADATASRC_KEY", string + "." + "METADATASOURCE_T", printStream, (SQLUtilities.BlobContentHandler)object);
                } else if (bl3) {
                    DumpUtilitiesBase.printTable(connection, "select METADATASRC_KEY, \"SOURCE\", IMPORT_TIME, SOURCEFILE from " + string + "." + "METADATASOURCE_T" + " ORDER BY METADATASRC_KEY", string + "." + "METADATASOURCE_T", printStream, null);
                } else {
                    DumpUtilitiesBase.printTable(connection, "select METADATASRC_KEY, \"SOURCE\", CONTENT_LENGTH, IMPORT_TIME, SOURCEFILE from " + string + "." + "METADATASOURCE_T" + " ORDER BY METADATASRC_KEY", string + "." + "METADATASOURCE_T", printStream, null);
                }
                arrayList.add("METADATASOURCE_T");
            }
            if (list.contains("PROJECT_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "PROJECT_T" + " ORDER BY PROJECT_KEY", string + "." + "PROJECT_T", printStream, null);
                arrayList.add("PROJECT_T");
            }
            if (list.contains("APP_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "APP_T" + " ORDER BY APP_KEY", string + "." + "APP_T", printStream, null);
                arrayList.add("APP_T");
            }
            if (list.contains("METADATASOURCE_STMT_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "METADATASOURCE_STMT_T" + " ORDER BY METADATASRC_KEY", string + "." + "METADATASOURCE_STMT_T", printStream, null);
                arrayList.add("METADATASOURCE_STMT_T");
            }
            if (list.contains("STACK_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "STACK_T", string + "." + "STACK_T", printStream, null);
                arrayList.add("STACK_T");
            }
            if (list.contains("METADATAGROUP_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "METADATAGROUP_T" + " ORDER BY METADATAGROUP_KEY", string + "." + "METADATAGROUP_T", printStream, null);
                arrayList.add("METADATAGROUP_T");
            }
            if (list.contains("METADATAGROUPMEMBERS_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "METADATAGROUPMEMBERS_T" + " ORDER BY METADATAGROUP_KEY", string + "." + "METADATAGROUPMEMBERS_T", printStream, null);
                arrayList.add("METADATAGROUPMEMBERS_T");
            }
            if (list.contains("CAPTUREDATA_T")) {
                if (file != null) {
                    object = new BlobContentToFileSystem("CAPTUREDATA_KEY", "CONTENT", file, "CAPTUREDATA_T", printStream);
                    DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "CAPTUREDATA_T" + " ORDER BY CAPTUREDATA_KEY", string + "." + "CAPTUREDATA_T", printStream, (SQLUtilities.BlobContentHandler)object);
                } else {
                    DumpUtilitiesBase.printTable(connection, "select CAPTUREDATA_KEY, GROUP_NAME, GROUP_VERSION, UPDATE_TIME, CONTENT_LENGTH, STATE, STATE_TRANSITION_TIME from " + string + "." + "CAPTUREDATA_T" + " ORDER BY CAPTUREDATA_KEY", string + "." + "CAPTUREDATA_T", printStream, null);
                }
                arrayList.add("CAPTUREDATA_T");
            }
            if (list.contains("CONTACT_T")) {
                DumpUtilitiesBase.printTable(connection, "select * from " + string + "." + "CONTACT_T" + " ORDER BY CONTACT_KEY", string + "." + "CONTACT_T", printStream, null);
                arrayList.add("CONTACT_T");
            }
            object = connection.getMetaData();
            resultSet = object.getTables(null, string, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                String string2 = resultSet.getString(3);
                if (arrayList.contains(string2)) continue;
                String string3 = string + "." + string2;
                DumpUtilitiesBase.printTable(connection, "select * from " + string3, string3, printStream, null);
            }
        }
        catch (Throwable throwable) {
            if (printStream != null) {
                printStream.println("Error when dumping tables");
                throwable.printStackTrace(printStream);
            } else {
                System.out.println("Error when dumping tables");
                throwable.printStackTrace();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (bl2 && outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file2;
    }

    protected static void printTable(Connection connection, String string, String string2, PrintStream printStream, SQLUtilities.BlobContentHandler blobContentHandler) throws MetadataException, SQLException {
        List<String[]> list = SQLUtilities.runQuerySQL(connection, string, true, blobContentHandler);
        printStream.println(string2 + "  ( " + (list.size() - 1) + " rows)");
        DumpUtilitiesBase.printTableData(list, printStream);
        printStream.println("------------------------");
        printStream.flush();
    }

    protected static void printTableData(List<String[]> list, PrintStream printStream) {
        for (String[] stringArray : list) {
            for (String string : stringArray) {
                if (string != null) {
                    String string2 = string.trim();
                    if (string2.length() == 0) {
                        printStream.print("<" + string2.length() + " length blank str>");
                    } else {
                        printStream.print(string2);
                    }
                } else {
                    printStream.print("<null>");
                }
                printStream.print("  ");
            }
            printStream.println();
        }
    }

    private static class BlobContentToFileSystem
    implements SQLUtilities.BlobContentHandler {
        private String keyColumnName = null;
        private String blobColumnName = null;
        private File contentDir = null;
        private String tableName = null;
        private PrintStream ps = null;
        private boolean hadError = false;

        public BlobContentToFileSystem(String string, String string2, File file, String string3, PrintStream printStream) {
            this.keyColumnName = string;
            this.blobColumnName = string2;
            this.contentDir = file;
            this.tableName = string3;
            this.ps = printStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String newBlobContent(String string, InputStream inputStream) {
            String string2 = "<null>";
            if (inputStream != null) {
                String string3 = (this.tableName + "_" + string + ".txt").toLowerCase();
                File file = new File(this.contentDir, string3);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    zipInputStream.getNextEntry();
                    StreamUtils.copyStream(zipInputStream, fileOutputStream);
                }
                catch (Exception exception) {
                    if (!this.hadError) {
                        this.ps.println("Error creating file to write blobs for table " + this.tableName);
                        exception.printStackTrace(this.ps);
                    }
                    this.hadError = true;
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                string2 = file.getName();
            }
            return string2;
        }

        @Override
        public String getBlobColumnName() {
            return this.blobColumnName;
        }

        @Override
        public String getColumnName() {
            return this.keyColumnName;
        }
    }
}

