/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class ByteBufferCollector {
    private static final int DEFAULT_INITIAL_SIZE = 1024;
    private static final String INVALID_INITIAL_SIZE = "'initialSize' cannot be less than 0.";
    private static final String REQUESTED_BUFFER_INVALID = "Required capacity is greater than Integer.MAX_VALUE.";
    private static final ClientLogger LOGGER = new ClientLogger(ByteBufferCollector.class);
    private byte[] buffer;
    private int position;

    public ByteBufferCollector() {
        this(1024);
    }

    public ByteBufferCollector(int initialSize) {
        if (initialSize < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_INITIAL_SIZE));
        }
        this.buffer = new byte[initialSize];
        this.position = 0;
    }

    public void write(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        int remaining = byteBuffer.remaining();
        if (remaining == 0) {
            return;
        }
        this.ensureCapacity(remaining);
        byteBuffer.get(this.buffer, this.position, remaining);
        this.position += remaining;
    }

    public byte[] toByteArray() {
        if (this.buffer.length == this.position) {
            return this.buffer;
        }
        return Arrays.copyOf(this.buffer, this.position);
    }

    private void ensureCapacity(int byteBufferRemaining) {
        int currentCapacity = this.buffer.length;
        int requiredCapacity = this.position + byteBufferRemaining;
        if (((this.position ^ requiredCapacity) & (byteBufferRemaining ^ requiredCapacity)) < 0) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(REQUESTED_BUFFER_INVALID));
        }
        if (currentCapacity >= requiredCapacity) {
            return;
        }
        int proposedNewCapacity = currentCapacity << 1;
        if (proposedNewCapacity - requiredCapacity < 0) {
            proposedNewCapacity = requiredCapacity;
        }
        if (proposedNewCapacity < 0) {
            proposedNewCapacity = 0x7FFFFFF7;
        }
        this.buffer = Arrays.copyOf(this.buffer, proposedNewCapacity);
    }
}

