/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import java.security.SecureRandom;

public class Utils {
    private static final ThreadLocal<SecureRandom> RND = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            SecureRandom result = new SecureRandom();
            result.nextBoolean();
            return result;
        }
    };

    private Utils() {
    }

    public static SecureRandom getRng() {
        return RND.get();
    }

    public static byte[] getRandom(int len) {
        byte[] result = new byte[len];
        Utils.getRng().nextBytes(result);
        return result;
    }

    public static <V> V checkNotNull(V ref, String errMsg) {
        if (ref == null) {
            throw new NullPointerException(errMsg);
        }
        return ref;
    }

    public static String loadVersion() {
        return "2.0.3-legacy";
    }
}

