/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.dao;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.common.inject.Inject;
import org.opensearch.geospatial.ip2geo.processor.Ip2GeoProcessor;
import org.opensearch.ingest.IngestMetadata;
import org.opensearch.ingest.IngestService;

public class Ip2GeoProcessorDao {
    private final IngestService ingestService;

    @Inject
    public Ip2GeoProcessorDao(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    public List<Ip2GeoProcessor> getProcessors(String datasourceName) {
        IngestMetadata ingestMetadata = (IngestMetadata)this.ingestService.getClusterService().state().getMetadata().custom("ingest");
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        return ingestMetadata.getPipelines().keySet().stream().flatMap(pipelineId -> this.ingestService.getProcessorsInPipeline(pipelineId, Ip2GeoProcessor.class).stream()).filter(ip2GeoProcessor -> ip2GeoProcessor.getDatasourceName().equals(datasourceName)).collect(Collectors.toList());
    }
}

