/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public final class NIODataDescriptorPacket
extends NIOPacket
implements SQLnetDef {
    private static final String CLASS_NAME = NIODataDescriptorPacket.class.getName();
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd = new int[26];
    boolean useLongDescriptor = false;
    private static final byte[] STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU = new byte[]{0, 72, 0, 0, 15, 0, 0, 0};
    private static final byte[] STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU = new byte[]{0, 0, 0, 72, 15, 0, 0, 0};
    private static final byte[] STANDARD_SDD_MAX_DD_PAYLOAD = new byte[]{0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    NIODataDescriptorPacket(SessionAtts sAtts) {
        super(sAtts);
        this.header.type = 15;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        ByteOrder originalOrder = this.session.readBuffer.order();
        this.session.readBuffer.order(ByteOrder.BIG_ENDIAN);
        this.descriptorFLaG = this.session.payloadBufferForRead.getInt();
        this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
        this.totalDataLength = this.session.payloadBufferForRead.getInt();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readPayloadBuffer", "DescriptorFlag = {0}, UseLongDescriptor = {1}, TotalDataLength = {2}, SessionTraceId = {3}", (String)null, null, (Object)this.descriptorFLaG, (Object)this.useLongDescriptor, (Object)this.totalDataLength, (Object)this.session.traceId);
        this.session.readBuffer.order(originalOrder);
    }

    final void writeToSocketChannel(int totalLength, boolean marker) throws IOException {
        if (totalLength == 1703910 && !marker) {
            this.session.writeBuffer.clear();
            if (this.session.isLargeSDU) {
                this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU, 0, STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU.length);
            } else {
                this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU, 0, STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU.length);
            }
            this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_PAYLOAD, 0, STANDARD_SDD_MAX_DD_PAYLOAD.length);
            this.session.writeBuffer.flip();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeToSocketChannel", "SessionWriteBuffer = {0}, TotalDataLength = {1}, SessionTraceId = {2}", (String)null, null, (Object)this.session.writeBuffer, (Object)totalLength, (Object)this.session.traceId);
            while (this.session.writeBuffer.hasRemaining()) {
                this.session.socketChannel.write(this.session.writeBuffer);
            }
        } else {
            int i;
            this.useLongDescriptor = false;
            this.descriptorFLaG = 2;
            if (marker) {
                this.descriptorFLaG |= 1;
            }
            int nbOfDD = 0;
            int remainingBytes = totalLength;
            while (remainingBytes > 0) {
                this.sdd[nbOfDD] = remainingBytes > 65535 ? 65535 : remainingBytes;
                remainingBytes -= this.sdd[nbOfDD];
                ++nbOfDD;
            }
            this.session.payloadBufferForWrite.clear();
            this.session.payloadBufferForWrite.putInt(this.descriptorFLaG);
            this.session.payloadBufferForWrite.putInt(totalLength);
            this.session.payloadBufferForWrite.putInt(nbOfDD);
            for (i = 0; i < nbOfDD; ++i) {
                this.session.payloadBufferForWrite.putShort((short)this.sdd[i]);
            }
            for (i = nbOfDD; i < 26; ++i) {
                this.session.payloadBufferForWrite.putShort((short)0);
            }
            this.writeToSocketChannel();
        }
    }
}

