/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoer19;

class T4CTTIoer
extends T4CTTIoer19 {
    private static final String CLASS_NAME = T4CTTIoer.class.getName();
    long oertyp2;
    long oerchksm;

    T4CTTIoer(T4CConnection conn) {
        super(conn);
    }

    @Override
    void init() {
        super.init();
        this.oertyp2 = 0L;
        this.oerchksm = 0L;
    }

    @Override
    int unmarshal() throws IOException, SQLException {
        return this.unmarshal(false);
    }

    @Override
    int unmarshal(boolean ignoreORA1403) throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.oerrcd2 != 0L) {
            if (this.oerrcd2 == 1403L && ignoreORA1403) {
                this.unmarshalErrorMessageAndIgnore();
            } else {
                this.unmarshalErrorMessage();
            }
        }
        return this.currCursorID;
    }

    @Override
    void unmarshalAttributes() throws IOException, SQLException {
        super.unmarshalAttributes();
        if (this.connection.getTTCVersion() >= 14) {
            this.oertyp2 = this.meg.unmarshalUB4();
            this.oerchksm = this.meg.unmarshalUB4();
        }
    }

    @Override
    void print() throws SQLException {
        super.print();
    }

    @Override
    long updateChecksum(long localCheckSum) throws SQLException {
        localCheckSum = super.updateChecksum(localCheckSum);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.oertyp2);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.oerchksm);
        return localCheckSum;
    }
}

