/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.util;

import java.awt.Color;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.eclipse.core.runtime.CoreException;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.commons.ListValuePicker;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.commands.GetRepositoryTasksCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BugzillaUtil {
    private static final Color ERROR_COLOR;

    public static boolean show(JPanel panel, String title, String okName) {
        return BugzillaUtil.show(panel, title, okName, new HelpCtx(panel.getClass()));
    }

    public static boolean show(JPanel panel, String title, String okName, HelpCtx helpCtx) {
        JButton ok = new JButton(okName);
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(NbBundle.getMessage(BugzillaUtil.class, (String)"LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, title, true, new Object[]{ok, cancel}, (Object)ok, 0, helpCtx, null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == ok;
    }

    public static NbTask getTask(BugzillaRepository repository, String id, boolean handleExceptions) {
        block5: {
            MylynSupport supp = MylynSupport.getInstance();
            try {
                GetRepositoryTasksCommand cmd = supp.getCommandFactory().createGetRepositoryTasksCommand(repository.getTaskRepository(), Collections.singleton(id));
                repository.getExecutor().execute((BugtrackingCommand)cmd, handleExceptions);
                if (cmd.hasFailed() && Bugzilla.LOG.isLoggable(Level.FINE)) {
                    Bugzilla.LOG.log(Level.FINE, cmd.getErrorMessage());
                }
                if (cmd.getTasks().isEmpty()) {
                    NbTask task = supp.getTask(repository.getTaskRepository().getRepositoryUrl(), id);
                    if (cmd.hasFailed() && task != null) {
                        return task;
                    }
                    break block5;
                }
                return (NbTask)cmd.getTasks().iterator().next();
            }
            catch (CoreException ex) {
                Bugzilla.LOG.log(Level.INFO, null, ex);
            }
        }
        return null;
    }

    public static String getKeywords(String message, String keywordsString, BugzillaRepository repository) {
        try {
            BugzillaConfiguration bc = repository.getConfiguration();
            if (bc == null || !bc.isValid()) {
                return keywordsString;
            }
            return ListValuePicker.getValues((String)NbBundle.getMessage(BugzillaUtil.class, (String)"CTL_KeywordsTitle"), (String)NbBundle.getMessage(BugzillaUtil.class, (String)"LBL_Keywords"), (String)message, (String)keywordsString, bc.getKeywords());
        }
        catch (MissingResourceException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
            return keywordsString;
        }
    }

    public static boolean isAssertEnabled() {
        boolean retval = false;
        if (!$assertionsDisabled) {
            retval = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return retval;
    }

    public static boolean isNbRepository(BugzillaRepository repo) {
        return BugzillaUtil.isNbRepository(repo.getUrl());
    }

    public static boolean isNbRepository(String url) {
        return NBBugzillaUtils.isNbRepository((String)url);
    }

    public static boolean showQAContact(BugzillaRepository repo) {
        return true;
    }

    public static boolean showStatusWhiteboard(BugzillaRepository repo) {
        return true;
    }

    public static boolean showIssueType(BugzillaRepository repo) {
        return NBBugzillaUtils.isNbRepository((String)repo.getUrl());
    }

    public static Repository getRepository(BugzillaRepository bugzillaRepository) {
        Repository repository = RepositoryManager.getInstance().getRepository("org.netbeans.modules.bugzilla", bugzillaRepository.getID());
        if (repository == null) {
            repository = BugzillaUtil.createRepository(bugzillaRepository);
        }
        return repository;
    }

    public static Repository createRepository(BugzillaRepository bugzillaRepository) {
        return Bugzilla.getInstance().getBugtrackingFactory().createRepository((Object)bugzillaRepository, Bugzilla.getInstance().getStatusProvider(), Bugzilla.getInstance().getSchedulingProvider(), Bugzilla.getInstance().createPriorityProvider(bugzillaRepository), Bugzilla.getInstance().getBugzillaIssueFinder());
    }

    public static void openIssue(BugzillaIssue bugzillaIssue) {
        Bugzilla.getInstance().getBugtrackingFactory().openIssue((Object)bugzillaIssue.getRepository(), (Object)bugzillaIssue);
    }

    public static void openQuery(BugzillaQuery bugzillaQuery) {
        Bugzilla.getInstance().getBugtrackingFactory().editQuery((Object)bugzillaQuery.getRepository(), (Object)bugzillaQuery);
    }

    public static Color getErrorForegroundColor() {
        return ERROR_COLOR;
    }

    static {
        Color c = UIManager.getColor("nb.errorForeground");
        if (c == null) {
            c = new Color(153, 0, 0);
        }
        ERROR_COLOR = c;
    }
}

