/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.JmsDestinationDefinition;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MdbLocationPanel;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationUiSupport;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MdbLocationPanelVisual
extends JPanel {
    public static final String CHANGED = MdbLocationPanelVisual.class.getName() + ".CHANGED";
    public static final String SCANNED = MdbLocationPanelVisual.class.getName() + ".SCANNED";
    private final Project project;
    private final J2eeModuleProvider provider;
    private final boolean isDestinationCreationSupportedByServerPlugin;
    private Set<MessageDestination> moduleDestinations;
    private Set<MessageDestination> serverDestinations;
    private JButton addButton;
    private ButtonGroup destinationsGroup;
    private JComboBox projectDestinationsCombo;
    private JRadioButton projectDestinationsRadio;
    private JLabel scanningLabel;
    private JComboBox serverDestinationsCombo;
    private JRadioButton serverDestinationsRadio;

    private MdbLocationPanelVisual(Project project, J2eeModuleProvider provider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations) {
        this.initComponents();
        this.projectDestinationsCombo.setModel(new ProjectDestinationsComboModel(this.projectDestinationsCombo.getEditor()));
        this.project = project;
        this.provider = provider;
        this.moduleDestinations = moduleDestinations;
        this.serverDestinations = serverDestinations;
        this.isDestinationCreationSupportedByServerPlugin = provider.getConfigSupport().supportsCreateMessageDestination();
        if (!SourceUtils.isScanInProgress()) {
            this.scanningLabel.setVisible(false);
        } else {
            ClasspathInfo classPathInfo = MdbLocationPanel.getClassPathInfo(project);
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classPathInfo, (FileObject[])new FileObject[0]);
            try {
                javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        MdbLocationPanelVisual.this.fire(true);
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static MdbLocationPanelVisual newInstance(Project project, J2eeModuleProvider provider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations) {
        MdbLocationPanelVisual mdp = new MdbLocationPanelVisual(project, provider, moduleDestinations, serverDestinations);
        mdp.initialize();
        return mdp;
    }

    public MessageDestination getDestination() {
        if (this.projectDestinationsRadio.isSelected()) {
            if (this.projectDestinationsCombo.getSelectedItem() == null || ((String)this.projectDestinationsCombo.getSelectedItem()).isEmpty()) {
                return null;
            }
            String selectedDestination = (String)this.projectDestinationsCombo.getSelectedItem();
            for (MessageDestination messageDestination : this.moduleDestinations) {
                if (!messageDestination.getName().equals(selectedDestination)) continue;
                return messageDestination;
            }
            return new JmsDestinationDefinition(selectedDestination, MessageDestination.Type.QUEUE, false);
        }
        if (this.serverDestinationsRadio.isSelected()) {
            return (MessageDestination)this.serverDestinationsCombo.getSelectedItem();
        }
        return null;
    }

    public boolean isServerConfigured() {
        String id = this.provider.getServerInstanceID();
        try {
            return id != null && Deployment.getDefault().getServerInstance(id).getJ2eePlatform() != null;
        }
        catch (InstanceRemovedException ex) {
            return false;
        }
    }

    private void initialize() {
        this.registerListeners();
        this.setupAddButton();
        this.handleComboBoxes();
        this.populate();
    }

    private void registerListeners() {
        this.projectDestinationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MdbLocationPanelVisual.this.fire(false);
                MdbLocationPanelVisual.this.handleComboBoxes();
            }
        });
        this.serverDestinationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MdbLocationPanelVisual.this.fire(false);
                MdbLocationPanelVisual.this.handleComboBoxes();
            }
        });
        this.projectDestinationsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MdbLocationPanelVisual.this.fire(false);
            }
        });
        this.serverDestinationsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MdbLocationPanelVisual.this.fire(false);
            }
        });
        JTextComponent tc = (JTextComponent)this.projectDestinationsCombo.getEditor().getEditorComponent();
        tc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireUpdate();
            }

            private void fireUpdate() {
                MdbLocationPanelVisual.this.fire(false);
            }
        });
    }

    private void setupAddButton() {
        if (!this.isDestinationCreationSupportedByServerPlugin) {
            this.addButton.setEnabled(false);
        }
    }

    private void handleComboBoxes() {
        this.projectDestinationsCombo.setEnabled(this.projectDestinationsRadio.isSelected());
        this.serverDestinationsCombo.setEnabled(this.serverDestinationsRadio.isSelected());
    }

    private void populate() {
        MessageDestinationUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, null);
        MessageDestinationUiSupport.populateDestinations(this.serverDestinations, this.serverDestinationsCombo, null);
    }

    private void fire(boolean fromScanning) {
        if (fromScanning) {
            this.firePropertyChange(SCANNED, null, null);
            this.scanningLabel.setVisible(SourceUtils.isScanInProgress());
        }
        this.firePropertyChange(CHANGED, null, null);
    }

    void store(WizardDescriptor descriptor) {
        descriptor.putProperty("DESTINATION_TYPE", (Object)this.getDestination());
    }

    private void initComponents() {
        this.destinationsGroup = new ButtonGroup();
        this.projectDestinationsRadio = new JRadioButton();
        this.serverDestinationsRadio = new JRadioButton();
        this.projectDestinationsCombo = new JComboBox();
        this.addButton = new JButton();
        this.serverDestinationsCombo = new JComboBox();
        this.scanningLabel = new JLabel();
        this.destinationsGroup.add(this.projectDestinationsRadio);
        this.projectDestinationsRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectDestinationsRadio, (String)NbBundle.getMessage(MdbLocationPanelVisual.class, (String)"LBL_ProjectDestinations"));
        this.projectDestinationsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.destinationsGroup.add(this.serverDestinationsRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.serverDestinationsRadio, (String)NbBundle.getMessage(MdbLocationPanelVisual.class, (String)"LBL_ServerDestinations"));
        this.serverDestinationsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.serverDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.projectDestinationsCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MdbLocationPanelVisual.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MdbLocationPanelVisual.this.addButtonActionPerformed(evt);
            }
        });
        this.scanningLabel.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.scanningLabel, (String)NbBundle.getMessage(MdbLocationPanelVisual.class, (String)"MdbLocationPanelVisual.scanningLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDestinationsRadio).addComponent(this.serverDestinationsRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverDestinationsCombo, 0, -1, Short.MAX_VALUE).addComponent(this.projectDestinationsCombo, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton)).addGroup(layout.createSequentialGroup().addComponent(this.scanningLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDestinationsRadio).addComponent(this.addButton).addComponent(this.projectDestinationsCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverDestinationsRadio).addComponent(this.serverDestinationsCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.scanningLabel)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        MessageDestination destination = MessageDestinationUiSupport.prepareMessageDestination(this.project, this.provider, this.moduleDestinations, this.serverDestinations);
        if (destination != null) {
            this.moduleDestinations.add(destination);
            MessageDestinationUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, destination);
        }
    }

    void refreshDestinations(Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations) {
        this.moduleDestinations = moduleDestinations;
        this.serverDestinations = serverDestinations;
    }

    private static class ProjectDestinationsComboModel
    extends DefaultComboBoxModel {
        private final ComboBoxEditor comboEditor;

        public ProjectDestinationsComboModel(ComboBoxEditor comboEditor) {
            this.comboEditor = comboEditor;
        }

        @Override
        public Object getSelectedItem() {
            Object selectedItem = super.getSelectedItem();
            if (selectedItem instanceof MessageDestination) {
                return ((MessageDestination)selectedItem).getName();
            }
            return this.comboEditor.getItem();
        }
    }
}

