/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.InsertProfilingPointAction;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsUIHelper;
import org.netbeans.modules.profiler.ppoints.ui.ProjectSelector;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class ProfilingPointsWindowUI
extends JPanel
implements ActionListener,
ListSelectionListener,
PropertyChangeListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final Icon PPOINT_ADD_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Add");
    private static final Icon PPOINT_REMOVE_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Remove");
    private static final Icon PPOINT_EDIT_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Edit");
    private static final Icon PPOINT_ENABLE_DISABLE_ICON = Icons.getIcon((String)"ProfilingPointsIcons.EnableDisable");
    private AbstractTableModel profilingPointsTableModel;
    private JButton addButton;
    private JButton disableButton;
    private JButton editButton;
    private JButton removeButton;
    private JCheckBox dependenciesCheckbox;
    private ProjectSelector ppointProjectSelector;
    private ProfilerTable profilingPointsTable;
    private JLabel projectLabel;
    private JMenuItem disableItem;
    private JMenuItem editItem;
    private JMenuItem enableDisableItem;
    private JMenuItem enableItem;
    private JMenuItem removeItem;
    private JMenuItem showEndInSourceItem;
    private JMenuItem showInSourceItem;
    private JMenuItem showReportItem;
    private JMenuItem showStartInSourceItem;
    private JPopupMenu profilingPointsPopup;
    private ProfilingPoint[] profilingPoints = new ProfilingPoint[0];
    private boolean profilingInProgress = false;

    public ProfilingPointsWindowUI() {
        this.initComponents();
        this.updateProjectsCombo();
        this.notifyProfilingStateChanged();
        ProfilingPointsManager.getDefault().addPropertyChangeListener(this);
    }

    public Lookup.Provider getSelectedProject() {
        return this.ppointProjectSelector.getProject();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            ((InsertProfilingPointAction)SystemAction.get(InsertProfilingPointAction.class)).performAction(this.getSelectedProject());
        } else if (e.getSource() == this.removeButton) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            ProfilingPoint[] selectedProfilingPoints = new ProfilingPoint[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedProfilingPoints[i] = this.getProfilingPointAt(selectedRows[i]);
            }
            ProfilingPointsManager.getDefault().removeProfilingPoints(selectedProfilingPoints);
        } else if (e.getSource() == this.editButton) {
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            selectedProfilingPoint.customize(false, false);
        } else if (e.getSource() == this.disableButton) {
            int[] selectedRows;
            for (int i : selectedRows = this.profilingPointsTable.getSelectedRows()) {
                ProfilingPoint selectedProfilingPoint;
                selectedProfilingPoint.setEnabled(!(selectedProfilingPoint = this.getProfilingPointAt(i)).isEnabled());
                this.repaint();
            }
        } else if (e.getSource() == this.showInSourceItem) {
            CodeProfilingPoint selectedProfilingPoint = (CodeProfilingPoint)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            Utils.openLocation(selectedProfilingPoint.getLocation());
        } else if (e.getSource() == this.showStartInSourceItem) {
            CodeProfilingPoint.Paired selectedProfilingPoint = (CodeProfilingPoint.Paired)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            CodeProfilingPoint.Location location = selectedProfilingPoint.getStartLocation();
            if (location == null) {
                ProfilerDialogs.displayWarning((String)Bundle.ProfilingPointsWindowUI_NoStartDefinedMsg());
            } else {
                Utils.openLocation(location);
            }
        } else if (e.getSource() == this.showEndInSourceItem) {
            CodeProfilingPoint.Paired selectedProfilingPoint = (CodeProfilingPoint.Paired)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            CodeProfilingPoint.Location location = selectedProfilingPoint.getEndLocation();
            if (location == null) {
                ProfilerDialogs.displayWarning((String)Bundle.ProfilingPointsWindowUI_NoEndDefinedMsg());
            } else {
                Utils.openLocation(location);
            }
        } else if (e.getSource() == this.showReportItem) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            for (int selectedRow : selectedRows) {
                ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
                selectedProfilingPoint.showResults(null);
            }
        } else if (e.getSource() == this.enableItem) {
            int selectedRow = this.profilingPointsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            selectedProfilingPoint.setEnabled(true);
        } else if (e.getSource() == this.disableItem) {
            int selectedRow = this.profilingPointsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            selectedProfilingPoint.setEnabled(false);
        } else if (e.getSource() == this.enableDisableItem) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            for (int selectedRow : selectedRows) {
                ProfilingPoint selectedProfilingPoint;
                selectedProfilingPoint.setEnabled(!(selectedProfilingPoint = this.getProfilingPointAt(selectedRow)).isEnabled());
            }
        } else if (e.getSource() == this.editItem) {
            int selectedRow = this.profilingPointsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            selectedProfilingPoint.customize(false, false);
        } else if (e.getSource() == this.removeItem) {
            this.deletePPs();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length != 0) {
                Rectangle rowBounds = this.profilingPointsTable.getCellRect(selectedRows[0], 1, true);
                this.showProfilingPointsPopup(e.getComponent(), rowBounds.x + 20, rowBounds.y + this.profilingPointsTable.getRowHeight() / 2);
            }
        } else if (e.getKeyCode() == 127) {
            this.deletePPs();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 16) {
            ProfilingPoint profilingPoint;
            int clickedRow = this.profilingPointsTable.rowAtPoint(e.getPoint());
            if (clickedRow != -1 && e.getClickCount() == 2 && (profilingPoint = this.getProfilingPointAt(clickedRow)) instanceof CodeProfilingPoint) {
                Utils.openLocation(((CodeProfilingPoint)profilingPoint).getLocation());
            }
        } else if (e.getModifiers() == 4) {
            int clickedRow = this.profilingPointsTable.rowAtPoint(e.getPoint());
            int selectedRowCount = this.profilingPointsTable.getSelectedRowCount();
            if (clickedRow != -1 && selectedRowCount != 0) {
                if (selectedRowCount == 1) {
                    this.profilingPointsTable.setRowSelectionInterval(clickedRow, clickedRow);
                }
                this.showProfilingPointsPopup(e.getComponent(), e.getX(), e.getY());
                return;
            }
        }
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int clickedRow;
        if (e.getModifiers() == 4 && (clickedRow = this.profilingPointsTable.rowAtPoint(e.getPoint())) != -1) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                this.profilingPointsTable.setRowSelectionInterval(clickedRow, clickedRow);
            } else {
                boolean changeSelection = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow != clickedRow) continue;
                    changeSelection = false;
                }
                if (changeSelection) {
                    this.profilingPointsTable.setRowSelectionInterval(clickedRow, clickedRow);
                }
            }
        }
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    public void notifyProfilingStateChanged() {
        this.profilingInProgress = ProfilingPointsManager.getDefault().isProfilingSessionInProgress();
        this.updateButtons();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "p_projects_changed") {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilingPointsWindowUI.this.updateProjectsCombo();
                }
            });
        } else if (evt.getPropertyName() == "p_profiling_points_changed") {
            this.refreshProfilingPoints();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    private ProfilingPoint getProfilingPointAt(int row) {
        return this.profilingPoints[this.profilingPointsTable.convertRowIndexToModel(row)];
    }

    private void createProfilingPointsTable() {
        this.profilingPointsTableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                if (col == 0) {
                    return Bundle.ProfilingPointsWindowUI_ScopeColumnName();
                }
                if (col == 1) {
                    return Bundle.ProfilingPointsWindowUI_ProjectColumnName();
                }
                if (col == 2) {
                    return Bundle.ProfilingPointsWindowUI_PpColumnName();
                }
                if (col == 3) {
                    return Bundle.ProfilingPointsWindowUI_ResultsColumnName();
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return ProfilingPointsWindowUI.this.profilingPoints.length;
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            public Class getColumnClass(int col) {
                return ProfilingPoint.class;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return ProfilingPointsWindowUI.this.profilingPoints[row];
            }
        };
        this.profilingPointsTable = new ProfilerTable(this.profilingPointsTableModel, true, true, null){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (this.convertColumnIndexToModel(column) == 3) {
                    return row < 0 || row >= this.getRowCount() ? this.getDefaultRenderer(String.class) : ProfilingPointsWindowUI.this.getProfilingPointAt(row).getResultsRenderer();
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.profilingPointsTable.setMainColumn(2);
        this.profilingPointsTable.setFitWidthColumn(2);
        this.profilingPointsTable.setDefaultSortOrder(SortOrder.ASCENDING);
        this.profilingPointsTable.setSortColumn(1);
        this.profilingPointsTable.setColumnRenderer(0, Utils.getScopeRenderer());
        this.profilingPointsTable.setColumnRenderer(1, Utils.getProjectRenderer());
        this.profilingPointsTable.setColumnRenderer(2, Utils.getPresenterRenderer());
        this.profilingPointsTable.setDefaultColumnWidth(0, 50);
        this.profilingPointsTable.setDefaultColumnWidth(1, 165);
        this.profilingPointsTable.setDefaultColumnWidth(3, 200);
        this.profilingPointsTable.setColumnToolTips(new String[]{Bundle.ProfilingPointsWindowUI_ScopeColumnToolTip(), Bundle.ProfilingPointsWindowUI_ProjectColumnToolTip(), Bundle.ProfilingPointsWindowUI_PpColumnToolTip(), Bundle.ProfilingPointsWindowUI_ResultsColumnToolTip()});
        this.profilingPointsTable.setSelectionMode(2);
        this.profilingPointsTable.getSelectionModel().addListSelectionListener(this);
        this.profilingPointsTable.addMouseListener((MouseListener)this);
        this.profilingPointsTable.addMouseMotionListener((MouseMotionListener)this);
        this.profilingPointsTable.addKeyListener((KeyListener)this);
    }

    private void deletePPs() {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        ArrayList<ProfilingPoint> pointsToRemove = new ArrayList<ProfilingPoint>();
        for (int selectedRow : selectedRows) {
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            pointsToRemove.add(selectedProfilingPoint);
        }
        Object object = pointsToRemove.iterator();
        while (object.hasNext()) {
            ProfilingPoint pointToRemove = (ProfilingPoint)object.next();
            ProfilingPointsManager.getDefault().removeProfilingPoint(pointToRemove);
        }
    }

    private void dispatchResultsRendererEvent(MouseEvent e) {
        int column = this.profilingPointsTable.columnAtPoint(e.getPoint());
        if (column != 3) {
            this.profilingPointsTable.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int row = this.profilingPointsTable.rowAtPoint(e.getPoint());
        if (row == -1) {
            return;
        }
        ProfilingPoint profilingPoint = this.getProfilingPointAt(row);
        ProfilingPoint.ResultsRenderer resultsRenderer = profilingPoint.getResultsRenderer();
        Rectangle cellRect = this.profilingPointsTable.getCellRect(row, column, true);
        resultsRenderer.dispatchMouseEvent(e, cellRect);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ProfilerToolbar toolbar = ProfilerToolbar.create((boolean)true);
        this.projectLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)Bundle.ProfilingPointsWindowUI_ProjectLabelText());
        this.projectLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.ppointProjectSelector = new ProjectSelector(Bundle.ProfilingPointsWindowUI_AllProjectsString()){

            protected void selectionChanged() {
                ProfilingPointsWindowUI.this.refreshProfilingPoints();
            }

            protected int getPreferredWidth() {
                return 200;
            }
        };
        this.projectLabel.setLabelFor((Component)((Object)this.ppointProjectSelector));
        toolbar.add((Component)this.projectLabel);
        toolbar.add((Component)((Object)this.ppointProjectSelector));
        if (ProfilingPointsUIHelper.get().displaySubprojectsOption()) {
            this.dependenciesCheckbox = new JCheckBox();
            this.dependenciesCheckbox.setOpaque(false);
            UIUtils.addBorder((JComponent)this.dependenciesCheckbox, (Border)BorderFactory.createEmptyBorder(0, 4, 0, 3));
            Mnemonics.setLocalizedText((AbstractButton)this.dependenciesCheckbox, (String)Bundle.ProfilingPointsWindowUI_InclSubprojCheckboxText());
            this.dependenciesCheckbox.setSelected(ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies());
            toolbar.add((Component)this.dependenciesCheckbox);
            this.dependenciesCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilerIDESettings.getInstance().setIncludeProfilingPointsDependencies(ProfilingPointsWindowUI.this.dependenciesCheckbox.isSelected());
                    ProfilingPointsWindowUI.this.refreshProfilingPoints();
                }
            });
        }
        toolbar.addSeparator();
        this.addButton = new JButton(PPOINT_ADD_ICON);
        this.addButton.setToolTipText(Bundle.ProfilingPointsWindowUI_AddButtonToolTip());
        this.addButton.addActionListener(this);
        toolbar.add((Component)this.addButton);
        this.removeButton = new JButton(PPOINT_REMOVE_ICON);
        this.removeButton.setToolTipText(Bundle.ProfilingPointsWindowUI_RemoveButtonToolTip());
        this.removeButton.addActionListener(this);
        toolbar.add((Component)this.removeButton);
        toolbar.addSeparator();
        this.editButton = new JButton(PPOINT_EDIT_ICON);
        this.editButton.setToolTipText(Bundle.ProfilingPointsWindowUI_EditButtonToolTip());
        this.editButton.addActionListener(this);
        toolbar.add((Component)this.editButton);
        this.disableButton = new JButton(PPOINT_ENABLE_DISABLE_ICON);
        this.disableButton.setToolTipText(Bundle.ProfilingPointsWindowUI_DisableButtonToolTip());
        this.disableButton.addActionListener(this);
        toolbar.add((Component)this.disableButton);
        this.createProfilingPointsTable();
        this.showInSourceItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowSourceItemText());
        this.showInSourceItem.setFont(this.showInSourceItem.getFont().deriveFont(1));
        this.showInSourceItem.addActionListener(this);
        this.showStartInSourceItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowStartItemText());
        this.showStartInSourceItem.setFont(this.showInSourceItem.getFont().deriveFont(1));
        this.showStartInSourceItem.addActionListener(this);
        this.showEndInSourceItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowEndItemText());
        this.showEndInSourceItem.addActionListener(this);
        this.showReportItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowReportItemText());
        this.showReportItem.addActionListener(this);
        this.enableItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_EnableItemText());
        this.enableItem.addActionListener(this);
        this.disableItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_DisableItemText());
        this.disableItem.addActionListener(this);
        this.enableDisableItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_EnableDisableItemText());
        this.enableDisableItem.addActionListener(this);
        this.editItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_EditItemText());
        this.editItem.addActionListener(this);
        this.removeItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_RemoveItemText());
        this.removeItem.addActionListener(this);
        this.profilingPointsPopup = new JPopupMenu();
        this.profilingPointsPopup.add(this.showInSourceItem);
        this.profilingPointsPopup.add(this.showStartInSourceItem);
        this.profilingPointsPopup.add(this.showEndInSourceItem);
        this.profilingPointsPopup.add(this.showReportItem);
        this.profilingPointsPopup.addSeparator();
        this.profilingPointsPopup.add(this.editItem);
        this.profilingPointsPopup.add(this.enableItem);
        this.profilingPointsPopup.add(this.disableItem);
        this.profilingPointsPopup.add(this.enableDisableItem);
        this.profilingPointsPopup.addSeparator();
        this.profilingPointsPopup.add(this.removeItem);
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)new ProfilerTableContainer(this.profilingPointsTable, false, null), "Center");
    }

    private void refreshProfilingPoints() {
        List<ProfilingPoint> sortedProfilingPoints = ProfilingPointsManager.getDefault().getProfilingPoints(this.getSelectedProject(), ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies(), false);
        this.profilingPoints = sortedProfilingPoints.toArray(new ProfilingPoint[0]);
        this.profilingPointsTableModel.fireTableDataChanged();
        this.repaint();
    }

    private void showProfilingPointsPopup(Component source, int x, int y) {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        boolean singleSelection = selectedRows.length == 1;
        ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRows[0]);
        this.showInSourceItem.setVisible(!singleSelection || selectedProfilingPoint instanceof CodeProfilingPoint.Single);
        this.showInSourceItem.setEnabled(singleSelection);
        this.showStartInSourceItem.setVisible(singleSelection && selectedProfilingPoint instanceof CodeProfilingPoint.Paired);
        this.showEndInSourceItem.setVisible(singleSelection && selectedProfilingPoint instanceof CodeProfilingPoint.Paired);
        this.showReportItem.setEnabled(true);
        this.enableItem.setVisible(singleSelection && !selectedProfilingPoint.isEnabled());
        this.enableItem.setEnabled(!this.profilingInProgress);
        this.disableItem.setVisible(singleSelection && selectedProfilingPoint.isEnabled());
        this.disableItem.setEnabled(!this.profilingInProgress);
        this.enableDisableItem.setVisible(!singleSelection);
        this.enableDisableItem.setEnabled(!this.profilingInProgress);
        this.editItem.setEnabled(singleSelection && !this.profilingInProgress);
        this.removeItem.setEnabled(!this.profilingInProgress);
        this.profilingPointsPopup.show(source, x, y);
    }

    private void updateButtons() {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        this.addButton.setEnabled(!this.profilingInProgress);
        if (selectedRows.length == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.disableButton.setEnabled(false);
        } else if (selectedRows.length == 1) {
            this.editButton.setEnabled(!this.profilingInProgress);
            this.removeButton.setEnabled(!this.profilingInProgress);
            this.disableButton.setEnabled(!this.profilingInProgress);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(!this.profilingInProgress);
            this.disableButton.setEnabled(!this.profilingInProgress);
        }
    }

    private void updateProjectsCombo() {
        this.ppointProjectSelector.resetModel();
        this.refreshProfilingPoints();
    }
}

