/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Resource;
import org.netbeans.modules.cordova.updatetask.CordovaPlugin;

public class PluginTask
extends Task {
    private HashSet<CordovaPlugin> requestedPlugins;
    private HashSet<CordovaPlugin> currentPlugins;

    public static boolean isWin() {
        boolean isWin = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        return isWin;
    }

    public static boolean isMac() {
        boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
        return isMac;
    }

    public void execute() throws BuildException {
        try {
            if (!this.initRequested()) {
                return;
            }
            this.initCurrent();
            HashSet pluginsToInstall = (HashSet)this.requestedPlugins.clone();
            pluginsToInstall.removeAll(this.currentPlugins);
            this.currentPlugins.removeAll(this.requestedPlugins);
            this.installPlugins(pluginsToInstall);
            this.uninstallPlugins(this.currentPlugins);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private boolean initRequested() throws IOException {
        this.requestedPlugins = new HashSet();
        Resource resource = this.getProject().getResource("nbproject/plugins.properties");
        if (resource == null || !resource.isExists()) {
            return false;
        }
        Properties props = new Properties();
        props.load(resource.getInputStream());
        for (String name : props.stringPropertyNames()) {
            this.requestedPlugins.add(new CordovaPlugin(name, props.getProperty(name)));
        }
        return true;
    }

    public static String getCordovaCommand() {
        boolean isWin = PluginTask.isWin();
        return isWin ? "cordova.cmd" : "cordova";
    }

    private void initCurrent() {
        this.currentPlugins = new HashSet();
        this.log(PluginTask.getCordovaCommand() + " plugins ");
        ExecTask exec = (ExecTask)this.getProject().createTask("exec");
        Environment.Variable variable = new Environment.Variable();
        String key = this.getProject().getProperty("cordova.path.key");
        variable.setKey(key);
        String val = this.getProject().getProperty("cordova.path.value");
        variable.setValue(val);
        exec.addEnv(variable);
        exec.setResolveExecutable(true);
        exec.setSearchPath(true);
        exec.setExecutable(PluginTask.getCordovaCommand());
        exec.createArg().setValue("plugins");
        exec.setOutputproperty("cordova.current.plugins");
        exec.execute();
        String plugins = this.getProject().getProperty("cordova.current.plugins");
        if (this.compareCordovaVersion("3.5.0") >= 0) {
            try {
                String line;
                BufferedReader r = new BufferedReader(new StringReader(plugins));
                while ((line = r.readLine()) != null && !line.startsWith("No plugins added")) {
                    this.currentPlugins.add(new CordovaPlugin(line.substring(0, line.indexOf(" ")), ""));
                }
            }
            catch (IOException ex) {
                this.log(ex, 0);
            }
        } else {
            int startPar = plugins.indexOf("[");
            if (startPar < 0) {
                return;
            }
            plugins = plugins.substring(startPar + 1, plugins.lastIndexOf("]")).trim();
            StringTokenizer tokenizer = new StringTokenizer(plugins, ",");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken().trim();
                this.currentPlugins.add(new CordovaPlugin(name.substring(name.indexOf("'") + 1, name.lastIndexOf("'")), ""));
            }
        }
    }

    private int compareCordovaVersion(String version) {
        String current = this.getProject().getProperty("cordova.version").trim();
        String currentApi = current.substring(0, current.indexOf("-"));
        return currentApi.compareTo(version);
    }

    private void installPlugins(Set<CordovaPlugin> pluginsToInstall) {
        for (CordovaPlugin plugin : pluginsToInstall) {
            this.log(PluginTask.getCordovaCommand() + " -d plugin add " + plugin.getUrl());
            ExecTask exec = (ExecTask)this.getProject().createTask("exec");
            Environment.Variable variable = new Environment.Variable();
            variable.setKey(this.getProject().getProperty("cordova.path.key"));
            variable.setValue(this.getProject().getProperty("cordova.path.value"));
            exec.addEnv(variable);
            exec.setExecutable(PluginTask.getCordovaCommand());
            exec.createArg().setValue("-d");
            exec.createArg().setValue("plugin");
            exec.createArg().setValue("add");
            for (String arg : plugin.getUrl().split("\\s+")) {
                exec.createArg().setValue(arg);
            }
            exec.setFailonerror(true);
            exec.setResolveExecutable(true);
            exec.setSearchPath(true);
            exec.execute();
        }
    }

    private void uninstallPlugins(Set<CordovaPlugin> pluginsToUninstall) {
        for (CordovaPlugin plugin : pluginsToUninstall) {
            this.log(PluginTask.getCordovaCommand() + " -d plugin remove " + plugin.getId());
            ExecTask exec = (ExecTask)this.getProject().createTask("exec");
            Environment.Variable variable = new Environment.Variable();
            variable.setKey(this.getProject().getProperty("cordova.path.key"));
            variable.setValue(this.getProject().getProperty("cordova.path.value"));
            exec.addEnv(variable);
            exec.setResolveExecutable(true);
            exec.setSearchPath(true);
            exec.setExecutable(PluginTask.getCordovaCommand());
            exec.createArg().setValue("-d");
            exec.createArg().setValue("plugin");
            exec.createArg().setValue("remove");
            exec.createArg().setValue(plugin.getId());
            exec.execute();
        }
    }
}

