/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.assistant.AssistantView;
import org.netbeans.modules.nbform.FormEditorSupport;
import org.openide.actions.FileSystemAction;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class FormDesignerTC
extends TopComponent
implements MultiViewElement {
    private FormEditorSupport formEditorSupport;
    private FormDesigner formDesigner;
    private PropertyChangeListener designerListener;
    private FormDesignerLookup lookup;
    private AssistantView assistantView;
    private PreferenceChangeListener settingsListener;
    private MultiViewElementCallback multiViewObserver;
    private PreLoadTask preLoadTask;
    private static String iconURL = "org/netbeans/modules/form/resources/formDesigner.gif";

    public FormDesignerTC(Lookup lkp) {
        this((FormEditorSupport)((Object)lkp.lookup(FormEditorSupport.class)));
    }

    FormDesignerTC(FormEditorSupport formEditorSupport) {
        this.formEditorSupport = formEditorSupport;
        this.lookup = new FormDesignerLookup();
        this.createDesigner();
        this.associateLookup((Lookup)this.lookup);
        this.setIcon(ImageUtilities.loadImage((String)iconURL));
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(10, 10));
    }

    private void createDesigner() {
        this.formDesigner = new FormDesigner(this.formEditorSupport.getFormEditor(true));
        if (this.designerListener == null) {
            this.designerListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("topDesignComponent".equals(evt.getPropertyName())) {
                        FormDesignerTC.this.formEditorSupport.updateMVTCDisplayName();
                    }
                }
            };
        }
        this.formDesigner.addPropertyChangeListener(this.designerListener);
        this.lookup.setLookupFromDesigner(this.formDesigner);
    }

    protected String preferredID() {
        return this.formEditorSupport.getFormDataObject().getName();
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
        this.closeDesigner();
    }

    private FormEditorSupport closeDesigner() {
        if (this.formDesigner != null) {
            this.formDesigner.removePropertyChangeListener(this.designerListener);
            this.formDesigner.close();
        }
        this.removeAll();
        if (this.preLoadTask != null) {
            StatusDisplayer.getDefault().setStatusText("");
        }
        if (this.settingsListener != null) {
            FormLoaderSettings.getPreferences().removePreferenceChangeListener(this.settingsListener);
            this.settingsListener = null;
        }
        this.assistantView = null;
        this.formDesigner = null;
        FormEditorSupport fes = this.formEditorSupport;
        this.formEditorSupport = null;
        return fes;
    }

    void resetDesigner(boolean reload) {
        boolean selected;
        if (this.isShowing()) {
            selected = FormDesigner.getSelectedDesigner() == this.formDesigner;
        } else {
            selected = false;
            reload = false;
        }
        JToolBar toolbar = this.formDesigner != null ? this.formDesigner.getToolBar() : null;
        this.formEditorSupport = this.closeDesigner();
        this.createDesigner();
        if (toolbar != null) {
            this.formDesigner.setToolBar(toolbar);
        }
        if (selected) {
            TopComponent activeTC = TopComponent.getRegistry().getActivated();
            if (activeTC == this || activeTC != null && activeTC.isAncestorOf((Component)((Object)this))) {
                this.formDesigner.componentActivated();
            } else {
                FormDesigner.setSelectedDesigner((FormDesigner)this.formDesigner, (boolean)true);
            }
        }
        if (reload) {
            this.componentShowing();
        }
    }

    public void componentShowing() {
        this.formDesigner.componentShowing();
        if (!this.isAncestorOf(this.formDesigner.getDesignCanvas())) {
            this.guiInit();
        }
        if (this.formEditorSupport.isOpened()) {
            FormEditorSupport.checkFormGroupVisibility();
        } else if (this.preLoadTask == null && this.formEditorSupport.startFormLoading()) {
            this.preLoadTask = new PreLoadTask(this.formEditorSupport.getFormEditor());
            FormUtils.getRequestProcessor().post((Runnable)this.preLoadTask);
            StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString((String)"FMT_PreparingForm", (Object[])new Object[]{this.formEditorSupport.getFormDataObject().getName()}));
        }
    }

    private void guiInit() {
        this.removeAll();
        JScrollPane scrollPane = new JScrollPane(this.formDesigner.getDesignCanvas());
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.add(scrollPane);
        this.setupAssistant();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Provider provider = (UndoRedo.Provider)this.getLookup().lookup(UndoRedo.Provider.class);
        return provider == null ? UndoRedo.NONE : provider.getUndoRedo();
    }

    private void loadForm() {
        assert (!this.formEditorSupport.isOpened());
        long ms = System.currentTimeMillis();
        if (this.formEditorSupport.loadOpeningForm()) {
            FormEditorSupport.checkFormGroupVisibility();
            this.formDesigner.loadingComplete();
            this.guiInit();
            Logger.getLogger(FormEditor.class.getName()).log(Level.FINER, "Opening form time 3: {0}ms", System.currentTimeMillis() - ms);
        }
    }

    public void componentHidden() {
        if (this.formDesigner != null) {
            this.formDesigner.componentHidden();
        }
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentActivated() {
        this.formDesigner.componentActivated();
    }

    public void componentDeactivated() {
        if (this.formDesigner != null) {
            this.formDesigner.componentDeactivated();
        }
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public CloseOperationState canCloseElement() {
        return this.formEditorSupport.canCloseElement(this.multiViewObserver.getTopComponent());
    }

    public Action[] getActions() {
        Action[] actions = super.getActions();
        SystemAction fsAction = SystemAction.get(FileSystemAction.class);
        if (!Arrays.asList(actions).contains(fsAction)) {
            Action[] newActions = new Action[actions.length + 1];
            System.arraycopy(actions, 0, newActions, 0, actions.length);
            newActions[actions.length] = fsAction;
            actions = newActions;
        }
        return actions;
    }

    public JComponent getToolbarRepresentation() {
        return this.formDesigner.getToolBar();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.multiViewObserver = callback;
        callback.getTopComponent().putClientProperty((Object)"formDesigner", (Object)this);
        if (this.formEditorSupport != null) {
            this.formEditorSupport.setTopComponent(callback.getTopComponent());
        }
    }

    private void setupAssistant() {
        if (this.formEditorSupport.isOpened()) {
            this.updateAssistant();
            this.settingsListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    if ("assistantShown".equals(evt.getKey())) {
                        FormDesignerTC.this.updateAssistant();
                    }
                }
            };
            FormLoaderSettings.getPreferences().addPreferenceChangeListener(this.settingsListener);
        } else if (FormLoaderSettings.getInstance().getAssistantShown()) {
            JPanel c = new JPanel();
            ((Component)c).setPreferredSize(new Dimension(10, 41));
            ((Component)c).setBackground(FormLoaderSettings.getInstance().getFormDesignerBackgroundColor());
            this.add(c, "North");
        }
    }

    private void updateAssistant() {
        if (FormLoaderSettings.getInstance().getAssistantShown()) {
            AssistantModel assistant = FormEditor.getAssistantModel((FormModel)this.formDesigner.getFormModel());
            this.assistantView = new AssistantView(assistant);
            assistant.setContext("select");
            this.add((Component)this.assistantView, "North");
        } else if (this.assistantView != null) {
            this.remove((Component)this.assistantView);
            this.assistantView = null;
        }
        this.revalidate();
        this.repaint();
    }

    private class PreLoadTask
    implements Runnable {
        private FormEditor formEditor;

        PreLoadTask(FormEditor formEditor) {
            this.formEditor = formEditor;
        }

        @Override
        public void run() {
            long ms = System.currentTimeMillis();
            this.formEditor.loadOnBackground();
            Logger.getLogger(FormEditor.class.getName()).log(Level.FINER, "Opening form time 2: {0}ms", System.currentTimeMillis() - ms);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormDesignerTC.this.preLoadTask = null;
                    if (FormDesignerTC.this.formEditorSupport != null) {
                        FormDesignerTC.this.loadForm();
                    }
                }
            });
        }
    }

    private static class FormDesignerLookup
    extends ProxyLookup {
        private FormDesignerLookup() {
        }

        void setLookupFromDesigner(FormDesigner designer) {
            this.setLookups(new Lookup[]{designer.getLookup()});
        }
    }
}

