/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class PolyglotStackFramesRetriever {
    PolyglotStackFramesRetriever() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void populateHeapRoots(final PolyglotContextImpl context, final List<Object> heapRoots) {
        Future<Object> future;
        PolyglotContextImpl polyglotContextImpl = context;
        synchronized (polyglotContextImpl) {
            future = !context.state.isClosed() ? context.threadLocalActions.submit(null, "engine", new ThreadLocalAction(false, false){

                @Override
                protected void perform(ThreadLocalAction.Access access) {
                    Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){

                        @Override
                        public Object visitFrame(FrameInstance frameInstance) {
                            PolyglotStackFramesRetriever.populateHeapRootsFromFrame(context, frameInstance, heapRoots);
                            return null;
                        }
                    });
                }
            }, false) : CompletableFuture.completedFuture(null);
        }
        TruffleSafepoint.setBlockedThreadInterruptible(context.uncachedLocation, new TruffleSafepoint.Interruptible<Future<Void>>(){

            @Override
            public void apply(Future<Void> arg) throws InterruptedException {
                if (!context.state.isClosed()) {
                    try {
                        arg.get();
                    }
                    catch (ExecutionException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                }
            }
        }, future);
    }

    private static void addRootPointerForGuestToHostStackFrameArgument(PolyglotContextImpl context, Object obj, List<Object> heapRoots) {
        if (InteropLibrary.isValidValue(obj)) {
            heapRoots.add(obj);
        } else if (obj instanceof PolyglotWrapper) {
            heapRoots.add(((PolyglotWrapper)obj).getGuestObject());
        } else if (context.getAPIAccess().isValue(obj)) {
            heapRoots.add(context.getAPIAccess().getValueReceiver(obj));
        }
    }

    static void populateHeapRootsFromFrame(PolyglotContextImpl context, FrameInstance frameInstance, List<Object> heapRoots) {
        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
        RootNode rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
        if (!(rootNode instanceof HostToGuestRootNode)) {
            if (EngineAccessor.HOST.isGuestToHostRootNode(rootNode)) {
                for (Object obj : frame.getArguments()) {
                    if (obj instanceof Object[]) {
                        for (Object elem : (Object[])obj) {
                            PolyglotStackFramesRetriever.addRootPointerForGuestToHostStackFrameArgument(context, elem, heapRoots);
                        }
                        continue;
                    }
                    PolyglotStackFramesRetriever.addRootPointerForGuestToHostStackFrameArgument(context, obj, heapRoots);
                }
            } else {
                heapRoots.add(frame);
            }
        }
    }
}

