/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.jira.FakeJiraConnector;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.ui.selectors.SelectorPanel;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.ide.spi.IDEServices;

public class RepositorySelector {
    private SelectorPanel selectorPanel = new SelectorPanel();

    public RepositoryImpl create(boolean selectNode) {
        DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
        ArrayList<DelegatingConnector> l = new ArrayList<DelegatingConnector>(connectors.length);
        for (DelegatingConnector dc : connectors) {
            if (!dc.providesRepositoryManagement()) continue;
            l.add(dc);
        }
        connectors = l.toArray(new DelegatingConnector[0]);
        connectors = this.addJiraProxyIfNeeded(connectors);
        this.selectorPanel.setConnectors(connectors);
        boolean didCreate = this.selectorPanel.create();
        final RepositoryImpl repo = this.selectorPanel.getRepository();
        if (!didCreate) {
            if (repo != null) {
                repo.cancelChanges();
            }
            return null;
        }
        repo.applyChanges();
        RepositoryRegistry.getInstance().addRepository(repo);
        if (selectNode) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ RepositorySelector this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    DashboardTopComponent.findInstance().select(repo, true);
                }
            });
        }
        return repo;
    }

    public boolean edit(RepositoryImpl repository, String errorMessage) {
        boolean didEdit = this.selectorPanel.edit(repository, errorMessage);
        RepositoryImpl repo = this.selectorPanel.getRepository();
        if (!didEdit) {
            if (repo != null) {
                repo.cancelChanges();
            }
            return false;
        }
        repo.applyChanges();
        RepositoryRegistry.getInstance().addRepository(repo);
        return true;
    }

    private DelegatingConnector[] addJiraProxyIfNeeded(DelegatingConnector[] connectors) {
        if (!BugtrackingUtil.isJiraInstalled() && RepositorySelector.supportsDownload()) {
            DelegatingConnector[] ret = new DelegatingConnector[connectors.length + 1];
            System.arraycopy(connectors, 0, ret, 0, connectors.length);
            ret[ret.length - 1] = FakeJiraConnector.getConnector();
            connectors = ret;
        }
        return connectors;
    }

    static boolean supportsDownload() {
        IDEServices ideServices = BugtrackingManager.getInstance().getIDEServices();
        return ideServices != null && ideServices.providesPluginUpdate();
    }
}

