/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.util.Comparator;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;

public class TaskAttribute
implements Comparator<TaskNode>,
Comparable<TaskAttribute> {
    private final String id;
    private final String displayName;
    private final Comparator<TaskNode> comparator;
    private int rank;
    private boolean asceding;
    public static final int NO_RANK = Integer.MAX_VALUE;

    public TaskAttribute(String id, String displayName, Comparator<TaskNode> comparator) {
        this.id = id;
        this.displayName = displayName;
        this.comparator = comparator;
        this.rank = Integer.MAX_VALUE;
        this.asceding = true;
    }

    private TaskAttribute(String id, String displayName, Comparator<TaskNode> comparator, int rank, boolean asceding) {
        this.id = id;
        this.displayName = displayName;
        this.comparator = comparator;
        this.rank = rank;
        this.asceding = asceding;
    }

    @Override
    public int compare(TaskNode tn1, TaskNode tn2) {
        int compare = this.comparator.compare(tn1, tn2);
        return this.asceding ? compare : -compare;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public boolean isAsceding() {
        return this.asceding;
    }

    public void setAsceding(boolean asceding) {
        this.asceding = asceding;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int compareTo(TaskAttribute o) {
        return Integer.compare(this.rank, o.rank);
    }

    public String toString() {
        return this.getDisplayName();
    }

    TaskAttribute getClone() {
        return new TaskAttribute(this.id, this.displayName, this.comparator, this.rank, this.asceding);
    }
}

