/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.api.explorer.NodeProvider;
import org.netbeans.modules.db.explorer.DbNodeLoader;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

public class DbNodeLoaderImpl
implements DbNodeLoader,
ChangeListener {
    static final String NODE_PROVIDER_PATH = "Databases/NodeProviders";
    static Collection providers;
    final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    public List<Node> getAllNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (providers == null) {
            providers = Lookups.forPath((String)NODE_PROVIDER_PATH).lookupAll(NodeProvider.class);
        }
        for (NodeProvider provider : providers) {
            List<Node> nodeList = provider.getNodes();
            if (nodeList != null) {
                nodes.addAll(nodeList);
            }
            provider.addChangeListener(this);
        }
        return nodes;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void stateChanged(ChangeEvent evt) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }
}

