/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.util.FileUtils;
import org.openide.util.NbPreferences;

public final class GruntOptions {
    private static final String GRUNT_PATH = "grunt.path";
    private static final String PREFERENCES_PATH = "grunt";
    private static final GruntOptions INSTANCE = new GruntOptions();
    private final Preferences preferences = NbPreferences.forModule(GruntOptions.class).node("grunt");
    private volatile boolean gruntSearched = false;

    private GruntOptions() {
    }

    public static GruntOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getGrunt() {
        String path = this.preferences.get(GRUNT_PATH, null);
        if (path == null && !this.gruntSearched) {
            this.gruntSearched = true;
            List<String> files = FileUtils.findFileOnUsersPath(GruntExecutable.GRUNT_NAME);
            if (!files.isEmpty()) {
                path = files.get(0);
                this.setGrunt(path);
            }
        }
        return path;
    }

    public void setGrunt(String grunt) {
        this.preferences.put(GRUNT_PATH, grunt);
    }
}

