/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netbinox;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.netbeans.core.netigso.spi.BundleContent;
import org.netbeans.core.netigso.spi.NetigsoArchive;
import org.netbeans.modules.netbinox.EmptyBundleFile;
import org.netbeans.modules.netbinox.ModuleEntry;
import org.netbeans.modules.netbinox.NetbinoxFactory;
import org.netbeans.modules.netbinox.RootEntry;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

final class JarBundleFile
extends BundleFile
implements BundleContent {
    private static final String META_INF = "META-INF/";
    private static final Attributes.Name MULTI_RELEASE;
    private static final int BASE_VERSION = 8;
    private static final int RUNTIME_VERSION;
    private static Map<Long, File> usedIds;
    private BundleFile delegate;
    private final MRUBundleFileList mru;
    private final BaseData data;
    private final NetigsoArchive archive;
    private int[] versions;
    private Boolean isMultiRelease;

    JarBundleFile(File base, BaseData data, NetigsoArchive archive, MRUBundleFileList mru, boolean isBase) {
        super(base);
        long id = isBase ? data.getBundleID() : (long)(100000 + base.getPath().hashCode());
        boolean assertOn = false;
        if (!$assertionsDisabled) {
            assertOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertOn) {
            File prev;
            if (usedIds == null) {
                usedIds = new HashMap<Long, File>();
            }
            if ((prev = usedIds.put(id, base)) != null && !prev.equals(base)) {
                NetbinoxFactory.LOG.log(Level.WARNING, "same id: {0} for {1} and {2}", new Object[]{id, base, prev});
            }
        }
        this.archive = archive.forBundle(id, (BundleContent)this);
        this.data = data;
        this.mru = mru;
    }

    private synchronized BundleFile delegate(String who, String what) {
        if (this.delegate == null) {
            NetbinoxFactory.LOG.log(Level.FINE, "opening {0} because of {1} needing {2}", new Object[]{this.data.getLocation(), who, what});
            try {
                this.delegate = new ZipBundleFile(this.getBaseFile(), this.data, this.mru){

                    @Override
                    protected boolean checkedOpen() {
                        try {
                            return this.getZipFile() != null;
                        }
                        catch (IOException ex) {
                            File bf = new File(this.getBaseFile().getPath());
                            if (bf.isDirectory()) {
                                try {
                                    JarBundleFile.this.delegate = new DirBundleFile(bf, false);
                                    return false;
                                }
                                catch (IOException dirEx) {
                                    NetbinoxFactory.LOG.log(Level.WARNING, "Cannot create DirBundleFile for " + bf, dirEx);
                                }
                            }
                            NetbinoxFactory.LOG.log(Level.WARNING, "Cannot open bundle delegate {0}", bf);
                            if (!bf.isFile() || !bf.canRead()) {
                                JarBundleFile.this.delegate = EmptyBundleFile.EMPTY;
                                return false;
                            }
                            return super.checkedOpen();
                        }
                    }
                };
            }
            catch (IOException ex) {
                NetbinoxFactory.LOG.log(Level.WARNING, "Error creating delegate for {0} because of {1}", new Object[]{this.getBaseFile(), this.data.getLocation()});
                this.delegate = EmptyBundleFile.EMPTY;
            }
        }
        return this.delegate;
    }

    @Override
    public File getBaseFile() {
        final File file = super.getBaseFile();
        class VFile
        extends File {
            final /* synthetic */ JarBundleFile this$0;

            public VFile() {
                this.this$0 = this$0;
                super(file2.getPath());
            }

            @Override
            public boolean isDirectory() {
                return false;
            }

            @Override
            public boolean isFile() {
                return true;
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public File getAbsoluteFile() {
                return this;
            }

            @Override
            public long lastModified() {
                return this.this$0.data.getLastModified();
            }
        }
        return new VFile();
    }

    @Override
    public File getFile(String file, boolean bln) {
        if (!file.startsWith(META_INF) && this.isMultiRelease()) {
            for (int version : this.getVersions()) {
                File f = this.getFile0("META-INF/versions/" + version + "/" + file, bln);
                if (f == null) continue;
                return f;
            }
        }
        return this.getFile0(file, bln);
    }

    private File getFile0(String file, boolean bln) {
        byte[] exists = this.getCachedEntry(file);
        if (exists == null) {
            return null;
        }
        BundleFile d = this.delegate("getFile", file);
        return d == null ? null : d.getFile(file, bln);
    }

    public byte[] resource(String name) throws IOException {
        if (!name.startsWith(META_INF) && this.isMultiRelease()) {
            for (int version : this.getVersions()) {
                byte[] b = this.resource0("META-INF/versions/" + version + "/" + name);
                if (b == null) continue;
                return b;
            }
        }
        return this.resource0(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] resource0(String name) throws IOException {
        BundleEntry u = this.findEntry("resource", name);
        if (u == null) {
            return null;
        }
        InputStream is = u.getInputStream();
        if (is == null) {
            return new byte[0];
        }
        byte[] arr = null;
        try {
            int len;
            int toRead;
            arr = new byte[is.available()];
            int pos = 0;
            while ((toRead = arr.length - pos) != 0 && (len = is.read(arr, pos, toRead)) != -1) {
                pos += len;
            }
            if (pos != arr.length) {
                throw new IOException("Not read enough: " + pos + " should have been: " + arr.length);
            }
        }
        finally {
            is.close();
        }
        NetbinoxFactory.LOG.log(Level.FINE, "Loaded {1} bytes for {0}", new Object[]{name, arr.length});
        return arr;
    }

    private BundleEntry findEntry(String why, String name) {
        BundleFile d;
        BundleEntry u;
        if (!name.equals("META-INF/MANIFEST.MF") && this.data != null && this.data.getLocation() != null && this.data.getLocation().startsWith("netigso://")) {
            String cnb = this.data.getLocation().substring(10);
            for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                URL url;
                if (!mi.getCodeNameBase().equals(cnb)) continue;
                if (!mi.isEnabled() || (url = mi.getClassLoader().getResource(name)) == null) break;
                return new ModuleEntry(url, name);
            }
        }
        if ("/".equals(name)) {
            return new RootEntry(this);
        }
        while ((u = (d = this.delegate(why, name)).getEntry(name)) == null && d != this.delegate) {
        }
        return u;
    }

    private byte[] getCachedEntry(String name) {
        try {
            return this.archive.fromArchive(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public BundleEntry getEntry(String name) {
        if (!name.startsWith(META_INF) && this.isMultiRelease()) {
            for (int version : this.getVersions()) {
                BundleEntry be = this.getEntry0("META-INF/versions/" + version + "/" + name);
                if (be == null) continue;
                return be;
            }
        }
        return this.getEntry0(name);
    }

    private BundleEntry getEntry0(String name) {
        if (!this.archive.isActive()) {
            return this.delegate("inactive", name).getEntry(name);
        }
        byte[] arr = this.getCachedEntry(name);
        if (arr == null && !name.equals("/")) {
            return null;
        }
        return new CachingEntry(arr, name);
    }

    @Override
    public Enumeration<String> getEntryPaths(String prefix) {
        BundleFile d = this.delegate("getEntryPaths", prefix);
        if (d == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return d.getEntryPaths(prefix);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void open() throws IOException {
        if (this.delegate != null) {
            this.delegate.open();
        }
    }

    @Override
    public boolean containsDir(String path) {
        return path.endsWith("/") && this.getEntry(path) != null;
    }

    private int[] getVersions() {
        if (this.versions != null) {
            return this.versions;
        }
        TreeSet vers = new TreeSet(Collections.reverseOrder());
        for (int i = 8; i <= RUNTIME_VERSION; ++i) {
            String directory = "META-INF/versions/" + i;
            BundleEntry be = this.delegate("getVersions", directory).getEntry(directory);
            if (be == null) continue;
            vers.add(i);
        }
        int[] ret = new int[vers.size()];
        int i = 0;
        for (Integer ver : vers) {
            ret[i++] = ver;
        }
        this.versions = ret;
        return this.versions;
    }

    private boolean isMultiRelease() {
        if (this.isMultiRelease != null) {
            return this.isMultiRelease;
        }
        BundleEntry be = this.delegate("isMultiRelease", "META-INF/MANIFEST.MF").getEntry("META-INF/MANIFEST.MF");
        if (be == null) {
            this.isMultiRelease = false;
        } else {
            try {
                Manifest manifest = new Manifest(be.getInputStream());
                this.isMultiRelease = Boolean.valueOf(manifest.getMainAttributes().getValue(MULTI_RELEASE));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.isMultiRelease;
    }

    static {
        int version;
        MULTI_RELEASE = new Attributes.Name("Multi-Release");
        try {
            Object runtimeVersion = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            version = (Integer)runtimeVersion.getClass().getMethod("major", new Class[0]).invoke(runtimeVersion, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            version = 8;
        }
        RUNTIME_VERSION = version;
    }

    private class CachingEntry
    extends BundleEntry {
        private final String name;
        private final int size;
        private final Reference<byte[]> arr;

        public CachingEntry(byte[] arr, String name) {
            this.size = arr.length;
            this.name = name;
            this.arr = new SoftReference<byte[]>(arr);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            byte[] data = this.arr.get();
            this.arr.clear();
            if (data == null) {
                data = JarBundleFile.this.getCachedEntry(this.name);
            }
            if (data == null) {
                throw new FileNotFoundException();
            }
            return new ByteArrayInputStream(data);
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getTime() {
            return JarBundleFile.this.getBaseFile().lastModified();
        }

        @Override
        public URL getLocalURL() {
            return JarBundleFile.this.findEntry("getLocalURL", this.name).getLocalURL();
        }

        @Override
        public URL getFileURL() {
            return JarBundleFile.this.findEntry("getFileURL", this.name).getFileURL();
        }
    }
}

