/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.hints;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.php.latte.hints.Bundle;
import org.netbeans.modules.php.latte.hints.HintRule;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;
import org.openide.filesystems.FileObject;

public abstract class DeprecatedMacrosHint
extends HintRule {
    private FileObject fileObject;
    private BaseDocument baseDocument;
    private List<Hint> hints;

    @Override
    public void invoke(RuleContext context, List<Hint> result) {
        TokenSequence topTs;
        Snapshot snapshot = context.parserResult.getSnapshot();
        this.hints = result;
        this.fileObject = snapshot.getSource().getFileObject();
        this.baseDocument = context.doc;
        if (this.fileObject != null && (topTs = snapshot.getTokenHierarchy().tokenSequence(LatteTopTokenId.language())) != null) {
            this.checkTopTokenSequence((TokenSequence<LatteTopTokenId>)topTs);
        }
    }

    private void checkTopTokenSequence(TokenSequence<LatteTopTokenId> topTs) {
        topTs.moveStart();
        while (topTs.moveNext()) {
            TokenSequence ts = topTs.embeddedJoined(LatteMarkupTokenId.language());
            if (ts == null) continue;
            this.checkMarkupTokenSequence((TokenSequence<LatteMarkupTokenId>)ts);
        }
    }

    private void checkMarkupTokenSequence(TokenSequence<LatteMarkupTokenId> ts) {
        ts.moveStart();
        while (ts.moveNext()) {
            Token token = ts.token();
            if (!this.isDeprecatedToken((Token<LatteMarkupTokenId>)token)) continue;
            this.createHint(ts.offset(), (Token<LatteMarkupTokenId>)token);
        }
    }

    private void createHint(int startOffset, Token<LatteMarkupTokenId> token) {
        OffsetRange offsetRange = new OffsetRange(startOffset, startOffset + token.length());
        if (this.showHint(offsetRange, this.baseDocument)) {
            String replaceText = this.getReplaceText();
            List fixes = replaceText == null ? Collections.emptyList() : Collections.singletonList(new Fix(startOffset, token, this.baseDocument, replaceText));
            this.hints.add(new Hint((Rule)this, Bundle.DeprecatedMacroHintText(), this.fileObject, offsetRange, fixes, 500));
        }
    }

    protected abstract boolean isDeprecatedToken(Token<LatteMarkupTokenId> var1);

    protected abstract String getReplaceText();

    private static final class Fix
    implements HintFix {
        private final int startOffset;
        private final Token<LatteMarkupTokenId> token;
        private final BaseDocument baseDocument;
        private final String replaceText;

        private Fix(int startOffset, Token<LatteMarkupTokenId> token, BaseDocument baseDocument, String replaceText) {
            this.startOffset = startOffset;
            this.token = token;
            this.baseDocument = baseDocument;
            this.replaceText = replaceText;
        }

        public String getDescription() {
            return Bundle.DeprecatedMacroHintFix(this.replaceText);
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDocument);
            editList.replace(this.startOffset, this.token.length(), this.replaceText, true, 0);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    public static final class IfCurrentMacroHint
    extends DeprecatedMacrosHint {
        private static final String HINT_ID = "latte.ifcurrent.macro.hint";
        private static final String DEPRECATED_MACRO = "ifCurrent";

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.IfCurrentMacroHintDesc();
        }

        public String getDisplayName() {
            return Bundle.IfCurrentMacroHintDisp();
        }

        @Override
        protected boolean isDeprecatedToken(Token<LatteMarkupTokenId> token) {
            return token != null && LatteMarkupTokenId.T_MACRO_START.equals(token.id()) && DEPRECATED_MACRO.equals(token.text().toString().trim());
        }

        @Override
        protected String getReplaceText() {
            return null;
        }
    }

    public static final class WidgetMacroHint
    extends DeprecatedMacrosHint {
        private static final String HINT_ID = "latte.widget.macro.hint";
        private static final String WIDGET_MACRO = "widget";
        private static final String CONTROL_MACRO = "control";

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.WidgetMacroHintDesc();
        }

        public String getDisplayName() {
            return Bundle.WidgetMacroHintDisp();
        }

        @Override
        protected boolean isDeprecatedToken(Token<LatteMarkupTokenId> token) {
            return token != null && LatteMarkupTokenId.T_MACRO_START.equals(token.id()) && WIDGET_MACRO.equals(token.text().toString().trim());
        }

        @Override
        protected String getReplaceText() {
            return CONTROL_MACRO;
        }
    }
}

