/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.user;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.Catalog;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor2;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class UserXMLCatalog
implements CatalogReader,
CatalogWriter,
CatalogDescriptor2,
EntityResolver {
    private static final String PROPERTY_LEX_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private Map<String, String> publicIds;
    private List<CatalogListener> catalogListeners = new ArrayList<CatalogListener>();
    private static final String catalogResource = "xml/catalogs/UserXMLCatalog.xml";
    private static final String URI_PREFIX = "URI:";
    private static final String PUBLIC_PREFIX = "PUBLIC:";
    private static final String SYSTEM_PREFIX = "SYSTEM:";
    private static final String SCHEMA_PREFIX = "SCHEMA:";
    private static final int TYPE_PUBLIC = 0;
    private static final int TYPE_SYSTEM = 1;
    private static final int TYPE_URI = 2;
    private static final int TYPE_SCHEMA = 3;
    private static final String NB_SCHEMA_MARKER = "NetBeans XML schema marker, do not remove";
    private static final String NB_SCHEMA_MARKER_COMMENT = "<!-- NetBeans XML schema marker, do not remove -->";

    public String resolveURI(String name) {
        String res = (String)this.getPublicIdMap().get(SCHEMA_PREFIX + name);
        if (res != null) {
            return res;
        }
        res = (String)this.getPublicIdMap().get(URI_PREFIX + name);
        if (res != null) {
            return res;
        }
        return null;
    }

    public String resolvePublic(String publicId) {
        return (String)this.getPublicIdMap().get(PUBLIC_PREFIX + publicId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.getPublicIdMap();
        String url = null;
        if (publicId != null) {
            url = (String)this.getPublicIdMap().get(PUBLIC_PREFIX + publicId);
            if (url == null) {
                url = (String)this.getPublicIdMap().get(URI_PREFIX + publicId);
            }
        } else if (systemId != null && (url = (String)this.getPublicIdMap().get(SCHEMA_PREFIX + systemId)) == null) {
            url = (String)this.getPublicIdMap().get(SYSTEM_PREFIX + systemId);
        }
        if (url != null) {
            return new InputSource(url);
        }
        return null;
    }

    public String getSystemID(String publicId) {
        return (String)this.getPublicIdMap().get(publicId);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removeCatalogListener(CatalogListener l) {
        this.catalogListeners.remove(l);
    }

    public void addCatalogListener(CatalogListener l) {
        this.catalogListeners.add(l);
    }

    protected void fireEntryAdded(String publicId) {
        for (CatalogListener listener : this.catalogListeners) {
            listener.notifyNew(publicId);
        }
    }

    protected void fireEntryRemoved(String publicId) {
        for (CatalogListener listener : this.catalogListeners) {
            listener.notifyRemoved(publicId);
        }
    }

    protected void fireEntryUpdated(String publicId) {
        for (CatalogListener listener : this.catalogListeners) {
            listener.notifyUpdate(publicId);
        }
    }

    public String getIconResource(int type) {
        return "org/netbeans/modules/xml/catalog/impl/xmlCatalog.gif";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        for (CatalogListener listener : this.catalogListeners) {
            listener.notifyInvalidate();
        }
        FileObject userCatalog = FileUtil.getConfigFile((String)catalogResource);
        userCatalog.refresh();
        UserXMLCatalog userXMLCatalog = this;
        synchronized (userXMLCatalog) {
            this.publicIds = null;
        }
    }

    public String getShortDescription() {
        return NbBundle.getMessage(UserXMLCatalog.class, (String)"HINT_userCatalog");
    }

    public Iterator getPublicIDs() {
        return this.getPublicIdMap().keySet().iterator();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UserXMLCatalog.class, (String)"LBL_userCatalog");
    }

    private synchronized Map getPublicIdMap() {
        if (this.publicIds == null) {
            try {
                FileObject userCatalog = FileUtil.getConfigFile((String)catalogResource);
                this.publicIds = this.parse(userCatalog);
            }
            catch (IOException ex) {
                this.publicIds = new HashMap<String, String>();
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (SAXException ex) {
                this.publicIds = new HashMap<String, String>();
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return this.publicIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(int entryType, String key, String value) throws IOException {
        FileObject userCatalog = FileUtil.getConfigFile((String)catalogResource);
        String tempBuffer = this.createCatalogBuffer(userCatalog);
        BufferedReader reader = new BufferedReader(new StringReader(tempBuffer));
        FileLock lock = userCatalog.lock();
        try (PrintWriter writer = new PrintWriter(userCatalog.getOutputStream(lock));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("</catalog>") >= 0) {
                    switch (entryType) {
                        case 0: {
                            writer.println("  <public publicId=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(PUBLIC_PREFIX + key, value);
                            this.fireEntryAdded(PUBLIC_PREFIX + key);
                            break;
                        }
                        case 1: {
                            writer.println("  <system systemId=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(SYSTEM_PREFIX + key, value);
                            this.fireEntryAdded(SYSTEM_PREFIX + key);
                            break;
                        }
                        case 2: {
                            writer.println("  <uri name=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(URI_PREFIX + key, value);
                            this.fireEntryAdded(URI_PREFIX + key);
                            break;
                        }
                        case 3: {
                            writer.println("   <!-- NetBeans XML schema marker, do not remove --> <uri name=\"" + key + "\" uri=\"" + value + "\"/> ");
                            this.getPublicIdMap().put(SCHEMA_PREFIX + key, value);
                            this.fireEntryAdded(SCHEMA_PREFIX + key);
                        }
                    }
                }
                writer.println(line);
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(int entryType, String key) throws IOException {
        String searchText;
        String prefix;
        FileObject userCatalog = FileUtil.getConfigFile((String)catalogResource);
        String tempBuffer = this.createCatalogBuffer(userCatalog);
        BufferedReader reader = new BufferedReader(new StringReader(tempBuffer));
        FileLock lock = userCatalog.lock();
        switch (entryType) {
            case 0: {
                prefix = PUBLIC_PREFIX;
                searchText = "<public publicId";
                break;
            }
            case 1: {
                prefix = SYSTEM_PREFIX;
                searchText = "<system systemId";
                break;
            }
            case 2: {
                prefix = URI_PREFIX;
                searchText = "<uri name";
                break;
            }
            case 3: {
                prefix = SCHEMA_PREFIX;
                searchText = "<uri name";
                break;
            }
            default: {
                prefix = "";
                searchText = "<public publicId";
            }
        }
        searchText = searchText + "=\"" + key + "\"";
        try (PrintWriter writer = new PrintWriter(userCatalog.getOutputStream(lock));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(searchText) > 0) {
                    this.getPublicIdMap().remove(prefix + key);
                    this.fireEntryRemoved(prefix + key);
                    continue;
                }
                writer.println(line);
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(int entryType, String key, String value) throws IOException {
        FileObject userCatalog = FileUtil.getConfigFile((String)catalogResource);
        String tempBuffer = this.createCatalogBuffer(userCatalog);
        BufferedReader reader = new BufferedReader(new StringReader(tempBuffer));
        FileLock lock = userCatalog.lock();
        try (PrintWriter writer = new PrintWriter(userCatalog.getOutputStream(lock));){
            String line;
            block12: while ((line = reader.readLine()) != null) {
                switch (entryType) {
                    case 0: {
                        if (line.indexOf("<public publicId=\"" + key + "\"") > 0) {
                            writer.println("  <public publicId=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(PUBLIC_PREFIX + key, value);
                            this.fireEntryUpdated(PUBLIC_PREFIX + key);
                            continue block12;
                        }
                        writer.println(line);
                        continue block12;
                    }
                    case 1: {
                        if (line.indexOf("<system systemId=\"" + key + "\"") > 0) {
                            writer.println("  <system systemId=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(SYSTEM_PREFIX + key, value);
                            this.fireEntryUpdated(SYSTEM_PREFIX + key);
                            continue block12;
                        }
                        writer.println(line);
                        continue block12;
                    }
                    case 2: {
                        if (line.indexOf("<uri name=\"" + key + "\"") > 0) {
                            writer.println("  <uri name=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(URI_PREFIX + key, value);
                            this.fireEntryUpdated(URI_PREFIX + key);
                            continue block12;
                        }
                        writer.println(line);
                        continue block12;
                    }
                    case 3: {
                        if (line.indexOf("<uri name=\"" + key + "\"") > 0) {
                            writer.println("   <!-- NetBeans XML schema marker, do not remove --> <uri name=\"" + key + "\" uri=\"" + value + "\"/>");
                            this.getPublicIdMap().put(SCHEMA_PREFIX + key, value);
                            this.fireEntryUpdated(SCHEMA_PREFIX + key);
                            continue block12;
                        }
                        writer.println(line);
                        continue block12;
                    }
                }
                writer.println(line);
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private String createCatalogBuffer(FileObject fo) throws IOException {
        int b;
        BufferedInputStream is = new BufferedInputStream(fo.getInputStream());
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((b = is.read(buf, 0, 512)) != -1) {
            temp.write(buf, 0, b);
        }
        is.close();
        temp.close();
        return temp.toString("UTF-8");
    }

    private Map parse(FileObject userCatalog) throws SAXException, IOException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setValidating(false);
        try {
            SAXParser parser = fact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new OasisCatalogResolver());
            CatalogHandler handler = new CatalogHandler();
            reader.setContentHandler(handler);
            reader.setProperty(PROPERTY_LEX_HANDLER, handler);
            reader.parse(new InputSource(userCatalog.getInputStream()));
            return handler.getValues();
        }
        catch (ParserConfigurationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return new HashMap();
        }
    }

    public void registerCatalogEntry(String key, String value) {
        this.getPublicIdMap();
        try {
            if (key.startsWith(PUBLIC_PREFIX)) {
                if (value != null) {
                    if (this.getPublicIdMap().get(key) != null) {
                        if (this.requestUpdate(key.substring(PUBLIC_PREFIX.length()))) {
                            this.updateEntry(0, key.substring(PUBLIC_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(0, key.substring(PUBLIC_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(0, key.substring(PUBLIC_PREFIX.length()));
                }
            } else if (key.startsWith(SYSTEM_PREFIX)) {
                if (value != null) {
                    if (this.getPublicIdMap().get(key) != null) {
                        if (this.requestUpdate(key.substring(SYSTEM_PREFIX.length()))) {
                            this.updateEntry(1, key.substring(SYSTEM_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(1, key.substring(SYSTEM_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(1, key.substring(SYSTEM_PREFIX.length()));
                }
            } else if (key.startsWith(URI_PREFIX)) {
                if (value != null) {
                    if (this.getPublicIdMap().get(key) != null) {
                        if (this.requestUpdate(key.substring(URI_PREFIX.length()))) {
                            this.updateEntry(2, key.substring(URI_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(2, key.substring(URI_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(2, key.substring(URI_PREFIX.length()));
                }
            } else if (key.startsWith(SCHEMA_PREFIX)) {
                if (value != null) {
                    if (this.getPublicIdMap().get(key) != null) {
                        if (this.requestUpdate(key.substring(SCHEMA_PREFIX.length()))) {
                            this.updateEntry(3, key.substring(SCHEMA_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(3, key.substring(SCHEMA_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(3, key.substring(SCHEMA_PREFIX.length()));
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private boolean requestUpdate(String id) {
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UserXMLCatalog.class, (String)"TXT_updateEntry", (Object)id), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        return NotifyDescriptor.YES_OPTION == desc.getValue();
    }

    private class OasisCatalogResolver
    implements EntityResolver {
        private OasisCatalogResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if ("-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN".equals(publicId)) {
                URL url = Catalog.class.getResource("etc/catalog.dtd");
                return new InputSource(url.toExternalForm());
            }
            return null;
        }
    }

    private static class CatalogHandler
    extends DefaultHandler
    implements LexicalHandler {
        private Map values = new HashMap();
        private boolean schemaFound;

        CatalogHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if ("public".equals(rawName)) {
                String val = atts.getValue("publicId");
                if (val != null) {
                    this.values.put(UserXMLCatalog.PUBLIC_PREFIX + val, atts.getValue("uri"));
                }
                this.schemaFound = false;
            } else if ("system".equals(rawName)) {
                String val = atts.getValue("systemId");
                if (val != null) {
                    this.values.put(UserXMLCatalog.SYSTEM_PREFIX + val, atts.getValue("uri"));
                }
                this.schemaFound = false;
            } else if ("uri".equals(rawName)) {
                String val = atts.getValue("name");
                if (val != null) {
                    this.addUri(val, atts.getValue("uri"));
                }
                this.schemaFound = false;
            }
        }

        private void addUri(String lastUri, String lastValue) {
            if (this.schemaFound) {
                this.values.put(UserXMLCatalog.SCHEMA_PREFIX + lastUri, lastValue);
            } else {
                this.values.put(UserXMLCatalog.URI_PREFIX + lastUri, lastValue);
            }
            lastUri = null;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.schemaFound = String.copyValueOf(ch, start, length).contains(UserXMLCatalog.NB_SCHEMA_MARKER);
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        public Map getValues() {
            return this.values;
        }
    }
}

