/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.queues.Bundle;
import org.netbeans.modules.mercurial.ui.queues.PatchSeriesPanel;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.ui.queues.Queue;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class GoToPatch {
    private final File repository;
    private final PatchSeriesPanel panel;
    private HgProgressSupport support;
    private static final String GETTING_PATCHES = NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatch.loadingPatches");
    private static final String NO_PATCHES = NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatch.noPatches");
    private QPatch onTopPatch;
    private static final String SEP = "--------------------------------------------";
    private static final String ICON_QUEUE_PATH = "org/netbeans/modules/mercurial/resources/icons/queue.png";
    private static final Icon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mercurial/resources/icons/queue.png", (boolean)true);

    public GoToPatch(File repository) {
        this.repository = repository;
        this.panel = new PatchSeriesPanel();
        this.panel.lstPatches.setCellRenderer(new PatchRenderer());
    }

    public boolean showDialog() {
        final JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(GoToPatch.class, (String)"CTL_GoToPatch.ok.text"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatchPanel.title", (Object)this.repository.getName()), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx(GoToPatch.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        okButton.setEnabled(false);
        this.setInfo(null);
        this.panel.lstPatches.addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ GoToPatch this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selectedObject = ((GoToPatch)this.this$0).panel.lstPatches.getSelectedValue();
                    Queue selectedQueue = selectedObject instanceof Queue ? (Queue)selectedObject : null;
                    okButton.setEnabled(true);
                    if (selectedQueue != null && selectedQueue.isActive() && this.this$0.onTopPatch == null) {
                        this.this$0.setInfo(NbBundle.getMessage(GoToPatch.class, (String)"PatchSeriesPanel.lblInfo.noAppliedPatches"));
                        okButton.setEnabled(false);
                    } else if (selectedObject instanceof QPatch && this.this$0.onTopPatch == selectedObject) {
                        this.this$0.setInfo(NbBundle.getMessage(GoToPatch.class, (String)"PatchSeriesPanel.lblInfo.alreadyOnTop"));
                        okButton.setEnabled(false);
                    } else if (selectedObject == null || selectedObject == GoToPatch.SEP) {
                        okButton.setEnabled(false);
                        this.this$0.setInfo(null);
                    } else {
                        this.this$0.setInfo(null);
                    }
                }
            }
        });
        this.panel.lstPatches.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ GoToPatch this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && okButton.isEnabled()) {
                    okButton.doClick();
                }
            }
        });
        this.loadPatches();
        dialog.setVisible(true);
        HgProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        return dd.getValue() == okButton;
    }

    private void setInfo(String message) {
        if (message == null || message.isEmpty()) {
            this.panel.lblInfo.setVisible(false);
        } else {
            this.panel.lblInfo.setText(message);
            this.panel.lblInfo.setVisible(true);
        }
    }

    private void loadPatches() {
        this.panel.lstPatches.setListData(new String[]{GETTING_PATCHES});
        this.panel.lstPatches.setEnabled(false);
        this.support = new HgProgressSupport(){

            @Override
            protected void perform() {
                Map<Queue, QPatch[]> qPatches2;
                Map<Queue, QPatch[]> patches = null;
                try {
                    qPatches2 = patches = HgCommand.qListAvailablePatches(GoToPatch.this.repository);
                }
                catch (HgException qPatches2) {
                    Map<Queue, QPatch[]> qPatches3 = patches;
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ Map val$qPatches;
                        final /* synthetic */ 3 this$1;
                        {
                            this.val$qPatches = map;
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.GoToPatch.this.displayResults(this.val$qPatches);
                        }
                    });
                }
                catch (Throwable throwable) {
                    Map<Queue, QPatch[]> qPatches4 = patches;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.support.start(Mercurial.getInstance().getRequestProcessor(this.repository), this.repository, GETTING_PATCHES);
    }

    private void displayResults(Map<Queue, QPatch[]> patches) {
        if (patches == null || patches.isEmpty()) {
            this.panel.lstPatches.setListData(new String[]{NO_PATCHES});
        } else {
            LinkedList<Object> toAdd = new LinkedList<Object>();
            for (Map.Entry<Queue, QPatch[]> e : patches.entrySet()) {
                if (!toAdd.isEmpty()) {
                    toAdd.add(SEP);
                }
                Queue q = e.getKey();
                toAdd.add(q);
                for (QPatch p : e.getValue()) {
                    toAdd.add(p);
                    if (!p.isApplied()) continue;
                    this.onTopPatch = p;
                }
            }
            this.panel.lstPatches.setListData(toAdd.toArray(new Object[0]));
            this.panel.lstPatches.setEnabled(true);
            if (this.onTopPatch == null) {
                this.panel.lstPatches.setSelectedIndex(1);
            } else {
                this.panel.lstPatches.setSelectedValue(this.onTopPatch, true);
            }
            this.panel.lstPatches.requestFocusInWindow();
        }
    }

    boolean isPopAllSelected() {
        Object selectedObject = this.panel.lstPatches.getSelectedValue();
        Queue selectedQueue = selectedObject instanceof Queue ? (Queue)selectedObject : null;
        return selectedQueue != null && selectedQueue.isActive();
    }

    QPatch getSelectedPatch() {
        QPatch retval = null;
        Object selected = this.panel.lstPatches.getSelectedValue();
        if (selected instanceof QPatch) {
            retval = (QPatch)selected;
        }
        return retval;
    }

    Queue getSelectedQueue() {
        Queue retval = null;
        Object selected = this.panel.lstPatches.getSelectedValue();
        if (selected instanceof Queue) {
            retval = (Queue)selected;
        }
        return retval;
    }

    private static class PatchRenderer
    extends DefaultListCellRenderer {
        private PatchRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StringBuilder sb;
            String tooltip = null;
            boolean isPatch = false;
            boolean isQueue = false;
            if (value instanceof QPatch) {
                isPatch = true;
                QPatch patch = (QPatch)value;
                sb = new StringBuilder(100);
                if (patch.isApplied()) {
                    sb.append("<html><strong>").append(patch.getId()).append("</strong>");
                } else {
                    sb.append(patch.getId());
                }
                sb.append(" (").append(NbBundle.getMessage(GoToPatch.class, (String)(patch.isApplied() ? "LBL_PatchSeriesPanel.applied" : "LBL_PatchSeriesPanel.unapplied"))).append(')');
                if (patch.isApplied()) {
                    sb.append("</html>");
                }
                value = sb.toString();
                if (!patch.getQueue().isActive()) {
                    tooltip = Bundle.MSG_QPatch_differentQueue(patch.getQueue().getName());
                } else if (!patch.getMessage().trim().isEmpty()) {
                    tooltip = patch.getMessage();
                }
            } else if (value instanceof Queue) {
                Queue q = (Queue)value;
                sb = new StringBuilder(50).append("<html>");
                sb.append(q.isActive() ? Bundle.Queue_name_active(q.getName()) : Bundle.Queue_name_inactive(q.getName()));
                sb.append("</html>");
                tooltip = q.isActive() ? Bundle.MSG_Queue_active_TT() : Bundle.MSG_Queue_inactive_TT();
                value = sb.toString();
                isQueue = true;
            }
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JComponent) {
                JComponent jcomp = (JComponent)comp;
                jcomp.setToolTipText(tooltip);
                if (isPatch) {
                    jcomp.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
                } else if (isQueue) {
                    if (comp instanceof JLabel) {
                        ((JLabel)comp).setIcon(icon);
                    }
                } else if (comp instanceof JLabel && !isSelected) {
                    ((JLabel)comp).setForeground(UIManager.getColor("Label.disabledForeground"));
                }
            }
            return comp;
        }
    }
}

