/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import java.awt.event.ActionEvent;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.actions.AbstractOutputAction;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class StopServerAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            PayaraModule commonSupport = (PayaraModule)node.getLookup().lookup(PayaraModule.class);
            if (commonSupport == null) continue;
            StopServerAction.performActionImpl(commonSupport);
        }
    }

    private static void performActionImpl(PayaraModule commonSupport) {
        commonSupport.stopServer(null);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            PayaraModule commonSupport;
            Node[] nodeArray = activatedNodes;
            int n = nodeArray.length;
            for (int i = 0; i < n && (result = (commonSupport = (PayaraModule)(node = nodeArray[i]).getLookup().lookup(PayaraModule.class)) != null ? StopServerAction.enableImpl(commonSupport) : false); ++i) {
            }
        }
        return result;
    }

    private static boolean enableImpl(PayaraModule commonSupport) {
        boolean online = PayaraState.isOnline(commonSupport.getInstance());
        return (online || commonSupport.getServerState() == PayaraModule.ServerState.STOPPED_JVM_PROFILER) && (null != commonSupport.getInstanceProperties().get("domainsfolder") || !Util.isDefaultOrServerTarget(commonSupport.getInstanceProperties()) && online);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(StopServerAction.class, (String)"CTL_StopServerAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/payara/common/resources/stop.png";

        public OutputAction(PayaraModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(StopServerAction.class, (String)"LBL_StopOutput"), NbBundle.getMessage(StopServerAction.class, (String)"LBL_StopOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StopServerAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return StopServerAction.enableImpl(this.commonSupport);
        }
    }
}

