/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenDomainDirectoryAction
extends NodeAction {
    private static final Logger LOGGER = PayaraLogger.get(OpenDomainDirectoryAction.class);

    protected void performAction(Node[] nodes) {
        PayaraModule commonSupport;
        if (nodes != null && nodes.length > 0 && nodes[0] != null && (commonSupport = (PayaraModule)nodes[0].getLookup().lookup(PayaraModule.class)) != null && commonSupport.getInstance() instanceof PayaraInstance) {
            PayaraInstance server = (PayaraInstance)commonSupport.getInstance();
            String domainPath = ServerUtils.getDomainPath((PayaraServer)server);
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                File directory = new File(domainPath);
                if (directory.exists()) {
                    try {
                        desktop.open(directory);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.INFO, "Error opening domain directory: {0}", e.getMessage());
                    }
                } else {
                    LOGGER.log(Level.INFO, "Domain directory does not exist: {0}", domainPath);
                }
            } else {
                LOGGER.log(Level.INFO, "Desktop not supported for opening directory.");
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length < 1 || nodes[0] == null) {
            return false;
        }
        PayaraModule commonSupport = (PayaraModule)nodes[0].getLookup().lookup(PayaraModule.class);
        if (commonSupport == null || !(commonSupport.getInstance() instanceof PayaraInstance)) {
            return false;
        }
        PayaraInstance server = (PayaraInstance)commonSupport.getInstance();
        String uri = server.getUrl();
        return uri != null && uri.length() > 0 && !server.isRemote();
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(OpenDomainDirectoryAction.class, (String)"CTL_OpenDomainDirectoryAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

