/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedSet;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;

public abstract class GroupEditPanel
extends JPanel {
    private ProjectCustomizer.Category category;
    public static final String PROP_READY = "ready";

    public ProjectCustomizer.Category getCategory() {
        return this.category;
    }

    protected abstract void applyChanges();

    protected boolean doCheckExistingGroups(JTextField field, Group actualGroup) {
        this.getCategory().setErrorMessage(null);
        this.getCategory().setValid(true);
        String name = field.getText();
        if (name != null) {
            if (name.trim().length() <= 0 || name.trim().length() >= 50) {
                return false;
            }
            SortedSet<Group> otherGroups = Group.allGroups();
            otherGroups.remove(actualGroup);
            if (name.equalsIgnoreCase("(none)")) {
                this.getCategory().setErrorMessage(Bundle.WARN_GroupExists());
                return false;
            }
            for (Group group : otherGroups) {
                if (!name.equalsIgnoreCase(group.getName())) continue;
                this.getCategory().setErrorMessage(Bundle.WARN_GroupExists());
                return false;
            }
        }
        return true;
    }

    void setCategory(ProjectCustomizer.Category category) {
        this.category = category;
        category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditPanel.this.applyChanges();
            }
        });
    }

    public abstract boolean isReady();
}

