/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;

public class ExtendedTreeTableModel
extends AbstractTreeTableModel {
    private AbstractTreeTableModel realModel;
    private int[] columnsMapping;
    private boolean[] columnsVisibility;
    private int realColumnsCount;
    private int virtualColumnsCount;

    public ExtendedTreeTableModel(AbstractTreeTableModel realModel) {
        super(realModel.root, realModel.supportsSorting, realModel.initialSortingColumn, realModel.initialSortingOrder);
        this.virtualColumnsCount = this.realColumnsCount = realModel.getColumnCount();
        this.realModel = realModel;
        this.columnsMapping = new int[this.realColumnsCount];
        boolean[] initialColumnsVisibility = new boolean[this.realColumnsCount];
        for (int i = 0; i < this.realColumnsCount; ++i) {
            initialColumnsVisibility[i] = true;
        }
        this.setColumnsVisibility(initialColumnsVisibility);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.realModel.isCellEditable(node, this.getRealColumn(column));
    }

    @Override
    public Class getColumnClass(int col) {
        return this.realModel.getColumnClass(this.getRealColumn(col));
    }

    @Override
    public int getColumnCount() {
        return this.virtualColumnsCount;
    }

    @Override
    public String getColumnName(int col) {
        return this.realModel.getColumnName(this.getRealColumn(col));
    }

    @Override
    public String getColumnToolTipText(int columnIndex) {
        int realColumn = this.getRealColumn(columnIndex);
        if (realColumn == -1) {
            return null;
        }
        return this.realModel.getColumnToolTipText(realColumn);
    }

    public void setColumnsVisibility(boolean[] columnsVisibility) {
        this.columnsVisibility = columnsVisibility;
        this.recomputeColumnsMapping();
    }

    public boolean[] getColumnsVisibility() {
        return this.columnsVisibility;
    }

    @Override
    public boolean getInitialSorting(int column) {
        return this.realModel.getInitialSorting(this.getRealColumn(column));
    }

    @Override
    public int getInitialSortingColumn() {
        return this.realModel.getInitialSortingColumn();
    }

    @Override
    public boolean getInitialSortingOrder() {
        return this.realModel.getInitialSortingOrder();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.realModel.isLeaf(node);
    }

    public int getRealColumn(int column) {
        if (column > -1 && column < this.columnsMapping.length) {
            return this.columnsMapping[column];
        }
        return -1;
    }

    public void setRealColumnVisibility(int column, boolean visible) {
        if (visible) {
            this.showRealColumn(column);
        } else {
            this.hideRealColumn(column);
        }
    }

    public boolean isRealColumnVisible(int column) {
        if (column > -1 && column < this.columnsMapping.length) {
            return this.columnsVisibility[column];
        }
        return false;
    }

    @Override
    public void setRoot(Object root) {
        this.realModel.setRoot(root);
    }

    @Override
    public Object getRoot() {
        return this.realModel.getRoot();
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        this.realModel.setValueAt(aValue, node, this.getRealColumn(column));
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return this.realModel.getValueAt(node, this.getRealColumn(column));
    }

    public int getVirtualColumn(int column) {
        for (int i = 0; i < this.virtualColumnsCount; ++i) {
            if (this.getRealColumn(i) != column) continue;
            return i;
        }
        return -1;
    }

    public void hideRealColumn(int column) {
        if (this.isRealColumnVisible(column)) {
            this.columnsVisibility[column] = false;
            this.recomputeColumnsMapping();
        }
    }

    public void showRealColumn(int column) {
        if (!this.isRealColumnVisible(column)) {
            this.columnsVisibility[column] = true;
            this.recomputeColumnsMapping();
        }
    }

    @Override
    public void sortByColumn(int column, boolean order) {
        this.realModel.sortByColumn(this.getRealColumn(column), order);
    }

    private void recomputeColumnsMapping() {
        int i;
        this.virtualColumnsCount = 0;
        int virtualColumnIndex = 0;
        for (i = 0; i < this.realColumnsCount; ++i) {
            if (!this.columnsVisibility[i]) continue;
            this.columnsMapping[virtualColumnIndex] = i;
            ++this.virtualColumnsCount;
            ++virtualColumnIndex;
        }
        for (i = virtualColumnIndex; i < this.realColumnsCount; ++i) {
            this.columnsMapping[i] = -1;
        }
        this.fireTableStructureChanged();
        this.realModel.fireTableStructureChanged();
    }
}

