/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;

public class ProfilerXYTooltipPainter
extends JPanel {
    private static Color BACKGROUND_COLOR = Utils.forceSpeed() ? new Color(80, 80, 80) : new Color(0, 0, 0, 170);
    private JLabel caption;
    private JLabel[] valuePainters;
    private JLabel[] extraValuePainters;
    private final ProfilerXYTooltipModel model;
    private boolean initialized;

    public ProfilerXYTooltipPainter(ProfilerXYTooltipModel model) {
        this.model = model;
        this.initialized = false;
    }

    public void update(List<ItemSelection> selectedItems) {
        if (!this.initialized) {
            this.initComponents();
        }
        int rowsCount = this.model.getRowsCount();
        if (selectedItems.size() != rowsCount) {
            throw new IllegalStateException("Rows and selected items don't match");
        }
        XYItemSelection selection = (XYItemSelection)selectedItems.get(0);
        long timestamp = selection.getItem().getXValue(selection.getValueIndex());
        this.caption.setText(this.model.getTimeValue(timestamp));
        for (int i = 0; i < rowsCount; ++i) {
            XYItemSelection sel = (XYItemSelection)selectedItems.get(i);
            long itemValue = sel.getItem().getYValue(sel.getValueIndex());
            this.valuePainters[i].setText(this.model.getRowValue(i, itemValue));
        }
        int extraRowsCount = this.model.getExtraRowsCount();
        for (int i = 0; i < extraRowsCount; ++i) {
            this.extraValuePainters[i].setText(this.model.getExtraRowValue(i));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        Color GRAY = new Color(230, 230, 230);
        this.caption = new JLabel();
        this.caption.setFont(ProfilerXYTooltipPainter.smallerFont(this.caption.getFont()));
        this.caption.setForeground(GRAY);
        this.caption.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.caption, constraints);
        final Dimension ZERO = new Dimension(0, 0);
        int count = this.model.getRowsCount();
        this.valuePainters = new JLabel[count];
        int i = 1;
        while (i <= count) {
            JLabel valueLabel;
            JLabel itemLabel = new JLabel();
            itemLabel.setText(this.model.getRowName(i - 1));
            itemLabel.setForeground(Color.WHITE);
            itemLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)itemLabel, constraints);
            this.valuePainters[i - 1] = valueLabel = new JLabel();
            valueLabel.setForeground(Color.WHITE);
            valueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = i;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)valueLabel, constraints);
            JLabel itemUnits = new JLabel();
            String units = this.model.getRowUnits(i - 1);
            if (!units.isEmpty()) {
                units = " " + units;
            }
            itemUnits.setText(units);
            itemUnits.setForeground(Color.WHITE);
            itemUnits.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = i;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)itemUnits, constraints);
            JPanel valueSpacer = new JPanel(this, null){
                final /* synthetic */ ProfilerXYTooltipPainter this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public Dimension getPreferredSize() {
                    return ZERO;
                }
            };
            valueSpacer.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = i++;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)valueSpacer, constraints);
        }
        int extraCount = this.model.getExtraRowsCount();
        this.extraValuePainters = new JLabel[count];
        for (int i2 = 1; i2 <= extraCount; ++i2) {
            JLabel extraValueLabel;
            int top = i2 == 1 ? 5 : 0;
            JLabel maxItemLabel = new JLabel();
            maxItemLabel.setText(this.model.getExtraRowName(i2 - 1));
            maxItemLabel.setFont(ProfilerXYTooltipPainter.smallerFont(maxItemLabel.getFont()));
            maxItemLabel.setForeground(GRAY);
            maxItemLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = count + i2;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(top, 0, 0, 0);
            this.add((Component)maxItemLabel, constraints);
            this.extraValuePainters[i2 - 1] = extraValueLabel = new JLabel();
            extraValueLabel.setFont(ProfilerXYTooltipPainter.smallerFont(extraValueLabel.getFont()));
            extraValueLabel.setForeground(GRAY);
            extraValueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = count + i2;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(top, 8, 0, 0);
            this.add((Component)extraValueLabel, constraints);
            JLabel maxItemUnits = new JLabel();
            String units = this.model.getExtraRowUnits(i2 - 1);
            if (!units.isEmpty()) {
                units = " " + units;
            }
            maxItemUnits.setText(units);
            maxItemUnits.setFont(ProfilerXYTooltipPainter.smallerFont(maxItemUnits.getFont()));
            maxItemUnits.setForeground(GRAY);
            maxItemUnits.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = count + i2;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(top, 0, 0, 0);
            this.add((Component)maxItemUnits, constraints);
            JPanel extraValueSpacer = new JPanel(this, null){
                final /* synthetic */ ProfilerXYTooltipPainter this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public Dimension getPreferredSize() {
                    return ZERO;
                }
            };
            extraValueSpacer.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = count + i2;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 12;
            constraints.insets = new Insets(top, 0, 0, 0);
            this.add((Component)extraValueSpacer, constraints);
        }
        this.initialized = true;
    }

    private static Font smallerFont(Font font) {
        return new Font(font.getName(), font.getStyle(), font.getSize() - 2);
    }
}

