/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks.task;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.commons.AttachmentsPanel;
import org.netbeans.modules.bugtracking.spi.IssueController;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.localtasks.LocalRepository;
import org.netbeans.modules.localtasks.task.Bundle;
import org.netbeans.modules.localtasks.task.TaskController;
import org.netbeans.modules.localtasks.util.FileUtils;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.NbTaskDataModel;
import org.netbeans.modules.mylyn.util.localtasks.AbstractLocalTask;
import org.netbeans.modules.mylyn.util.localtasks.IssueField;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class LocalTask
extends AbstractLocalTask {
    private final NbTask task;
    private final LocalRepository repository;
    private TaskController controller;
    private static final RequestProcessor RP = LocalRepository.getInstance().getRequestProcessor();
    private static final String NB_ATTACHMENT = "nb.attachment.";
    private static final String NB_TASK_REFERENCE = "nb.taskreference.";
    private static final Object ATTACHMENT_STORAGE_LOCK = new Object();
    private List<AttachmentsPanel.AttachmentInfo> unsavedAttachments;
    private String tooltip = "";

    public LocalTask(NbTask task) {
        super(task);
        this.task = task;
        this.repository = LocalRepository.getInstance();
        this.updateTooltip();
    }

    protected void taskDeleted(NbTask task) {
        this.repository.taskDeleted(this.getID());
    }

    protected void attributeChanged(NbTaskDataModel.NbTaskDataModelEvent event, NbTaskDataModel model) {
        this.modelStateChanged(model.isDirty() || this.hasUnsavedAttributes());
    }

    protected void modelSaved(NbTaskDataModel model) {
        this.modelStateChanged(model.isDirty() || this.hasUnsavedAttributes());
    }

    protected String getSummary(TaskData taskData) {
        return LocalTask.getFieldValue(taskData, IssueField.SUMMARY);
    }

    protected void taskDataUpdated() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                LocalTask.this.dataChanged();
            }
        });
    }

    private void dataChanged() {
        this.updateTooltip();
        this.fireDataChanged();
        if (this.controller != null) {
            this.controller.refreshViewData();
        }
    }

    private boolean updateTooltip() {
        String displayName = this.getDisplayName();
        if (displayName.startsWith("#")) {
            displayName = displayName.replaceFirst("#", "");
        }
        String oldTooltip = this.tooltip;
        String status = this.isFinished() ? Bundle.LBL_Task_tooltip_status_completed() : Bundle.LBL_Task_tooltip_status_open();
        String scheduledLabel = Bundle.CTL_Issue_Scheduled_Title();
        String scheduled = this.getScheduleDisplayString();
        String dueLabel = Bundle.CTL_Issue_Due_Title();
        String due = this.getDueDisplayString();
        String estimateLabel = Bundle.CTL_Issue_Estimate_Title();
        String estimate = this.getEstimateDisplayString();
        String fieldTable = "<table><tr><td><b>" + Bundle.LBL_Task_tooltip_statusLabel() + ":</b></td><td>" + status + "</td></tr>";
        if (!scheduled.isEmpty()) {
            fieldTable = fieldTable + "<tr><td><b>" + scheduledLabel + ":</b></td><td>" + scheduled + "</td></tr>";
        }
        if (!due.isEmpty()) {
            fieldTable = fieldTable + "<tr><td><b>" + dueLabel + ":</b></td><td>" + due + "</td></tr>";
        }
        if (!estimate.isEmpty()) {
            fieldTable = fieldTable + "<tr><td><b>" + estimateLabel + ":</b></td><td>" + estimate + "</td></tr>";
        }
        fieldTable = fieldTable + "</table>";
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<b>").append(displayName).append("</b>");
        sb.append("<hr>");
        sb.append(fieldTable);
        sb.append("</html>");
        this.tooltip = sb.toString();
        return !oldTooltip.equals(this.tooltip);
    }

    protected void taskModified(boolean syncStateChanged) {
        this.updateTooltip();
        this.fireDataChanged();
    }

    protected void repositoryTaskDataLoaded(TaskData repositoryTaskData) {
    }

    public boolean synchronizeTask() {
        return true;
    }

    public String getDisplayName() {
        return Bundle.LBL_LocalTask_displayName(LocalTask.getID((NbTask)this.task), this.task.getSummary());
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean searchFor(String[] keywords) {
        String summary = this.getSummary().toLowerCase();
        for (String kw : keywords) {
            if (!summary.contains(kw = kw.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public IssueController getController() {
        return this.getTaskController();
    }

    TaskController getTaskController() {
        if (this.controller == null) {
            this.controller = new TaskController(this);
        }
        return this.controller;
    }

    void opened() {
        LocalRepository.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (LocalTask.this.editorOpened()) {
                    LocalTask.this.getTaskController().refreshViewData();
                }
            }
        });
    }

    void closed() {
        LocalRepository.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                LocalTask.this.editorClosed();
            }
        });
    }

    public void delete() {
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                for (Attachment att : LocalTask.this.getAttachments()) {
                    if (!att.isInCentral()) continue;
                    String uri = att.getUri();
                    try {
                        File f = Utilities.toFile((URI)new URI(uri));
                        f.delete();
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                LocalTask.this.clearUnsavedChanges();
            }
        });
        this.fireChanged();
        if (this.controller != null) {
            this.controller.taskDeleted();
        }
        this.deleteTask();
    }

    void markUserChange() {
        this.markNewRead();
    }

    String getFieldValue(IssueField field) {
        NbTaskDataModel model = this.getModel();
        return LocalTask.getFieldValue(model == null ? null : model.getLocalTaskData(), field);
    }

    List<String> getFieldValues(IssueField field) {
        NbTaskDataModel model = this.getModel();
        return LocalTask.getFieldValues(model == null ? null : model.getLocalTaskData(), field);
    }

    void setFieldValue(IssueField field, String value) {
        NbTaskDataModel m = this.getModel();
        assert (m != null);
        TaskData taskData = m.getLocalTaskData();
        TaskAttribute a = taskData.getRoot().getMappedAttribute(field.getKey());
        assert (a != null) : field.getKey();
        if (!value.equals(a.getValue())) {
            this.setValue(m, a, value);
        }
    }

    private static String getFieldValue(TaskData taskData, IssueField field) {
        if (taskData == null) {
            return "";
        }
        TaskAttribute a = taskData.getRoot().getAttribute(field.getKey());
        if (a == null) {
            return "";
        }
        if (a.getValues().size() > 1) {
            return LocalTask.listValues(a);
        }
        return a.getValue();
    }

    private static List<String> getFieldValues(TaskData taskData, IssueField field) {
        if (taskData == null) {
            return Collections.emptyList();
        }
        TaskAttribute a = taskData.getRoot().getAttribute(field.getKey());
        if (a == null) {
            return Collections.emptyList();
        }
        return a.getValues();
    }

    private static String listValues(TaskAttribute a) {
        if (a == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : a.getValues()) {
            sb.append(s);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    private void setValue(NbTaskDataModel model, TaskAttribute ta, String value) {
        ta.setValue(value);
        model.attributeChanged(ta);
    }

    private boolean hasUnsavedAttributes() {
        return this.hasUnsavedAttachments() || this.hasUnsavedPrivateTaskAttributes();
    }

    boolean hasUnsavedAttachments() {
        return this.unsavedAttachments != null;
    }

    public boolean save() {
        TaskData taskData;
        NbTaskDataModel model = this.getModel();
        TaskData taskData2 = taskData = model == null ? null : model.getLocalTaskData();
        if (taskData != null) {
            this.getNbTask().setSummary(taskData.getRoot().getAttribute(IssueField.SUMMARY.getKey()).getValue());
            this.persistAttachments(model, taskData);
            this.fireDataChanged();
        }
        return this.saveChanges();
    }

    void clearModifications() {
        this.unsavedAttachments = null;
        this.clearUnsavedChanges();
    }

    boolean hasSubtasks() {
        return !this.getTaskReferences().isEmpty();
    }

    List<Attachment> getAttachments() {
        TaskAttribute parentTA;
        NbTaskDataModel model = this.getModel();
        TaskData taskData = model == null ? null : model.getLocalTaskData();
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        TaskAttribute taskAttribute = parentTA = taskData == null ? null : taskData.getRoot().getAttribute(IssueField.ATTACHMENTS.getKey());
        if (parentTA != null) {
            for (TaskAttribute ta : parentTA.getAttributes().values()) {
                if (!ta.getId().startsWith(NB_ATTACHMENT)) continue;
                attachments.add(new Attachment(ta));
            }
        }
        return attachments;
    }

    List<AttachmentsPanel.AttachmentInfo> getUnsubmittedAttachments() {
        return this.unsavedAttachments == null ? Collections.emptyList() : Collections.unmodifiableList(this.unsavedAttachments);
    }

    void setUnsubmittedAttachments(List<AttachmentsPanel.AttachmentInfo> attachments) {
        this.unsavedAttachments = new ArrayList<AttachmentsPanel.AttachmentInfo>(attachments);
        this.modelStateChanged(true);
    }

    private void persistAttachments(NbTaskDataModel model, TaskData td) {
        if (this.unsavedAttachments != null) {
            TaskAttribute parentTA = td.getRoot().getAttribute(IssueField.ATTACHMENTS.getKey());
            if (parentTA == null) {
                parentTA = td.getRoot().createAttribute(IssueField.ATTACHMENTS.getKey());
            }
            if (!this.unsavedAttachments.isEmpty()) {
                boolean copyToCentral = this.askCopyToCentralStorage(this.unsavedAttachments.size());
                for (AttachmentsPanel.AttachmentInfo att : this.unsavedAttachments) {
                    File file = att.getFile();
                    if (file == null) continue;
                    String desc = att.getDescription();
                    String contentType = att.getContentType();
                    boolean isPatch = att.isPatch();
                    this.addAttachment(model, parentTA, file, desc, contentType, isPatch, copyToCentral);
                }
                this.unsavedAttachments.clear();
            }
        }
    }

    private void addAttachment(NbTaskDataModel model, TaskAttribute parentTA, File file, String desc, String contentType, boolean isPatch, boolean copyToCentralStorage) {
        if (desc == null) {
            desc = "";
        }
        if (contentType == null) {
            String ct = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file))));
            contentType = ct != null && !"content/unknown".equals(ct) ? ct : FileTaskAttachmentSource.getContentTypeFromFilename((String)file.getName());
        }
        int attachmentIndex = parentTA.getAttributes().size();
        TaskAttribute attachment = parentTA.createAttribute(NB_ATTACHMENT + attachmentIndex);
        TaskAttachmentMapper mapper = new TaskAttachmentMapper();
        mapper.setAttachmentId(String.valueOf(attachmentIndex));
        mapper.setDescription(desc);
        mapper.setFileName(file.getName());
        mapper.setPatch(Boolean.valueOf(isPatch));
        mapper.setCreationDate(new Date());
        mapper.setContentType(contentType);
        File realFile = copyToCentralStorage ? this.copyFileToCentral(file) : file;
        mapper.setUrl(Utilities.toURI((File)realFile).toString());
        mapper.setReplaceExisting(Boolean.valueOf(copyToCentralStorage));
        mapper.applyTo(attachment);
        model.attributeChanged(parentTA);
    }

    private void deleteAttachment(TaskAttribute ta) {
        TaskAttribute parentTA;
        NbTaskDataModel model = this.getModel();
        TaskData taskData = model == null ? null : model.getLocalTaskData();
        TaskAttribute taskAttribute = parentTA = taskData == null ? null : taskData.getRoot().getAttribute(IssueField.ATTACHMENTS.getKey());
        if (parentTA != null && parentTA.getAttribute(ta.getId()) != null) {
            parentTA.removeAttribute(ta.getId());
            model.attributeChanged(parentTA);
            this.getTaskController().attachmentDeleted();
        }
    }

    void addTaskReference(Issue task) {
        TaskData taskData;
        NbTaskDataModel model = this.getModel();
        TaskData taskData2 = taskData = model == null ? null : model.getLocalTaskData();
        if (taskData != null) {
            TaskAttribute parentTA = taskData.getRoot().getAttribute(IssueField.REFERENCES.getKey());
            if (parentTA == null) {
                parentTA = taskData.getRoot().createAttribute(IssueField.REFERENCES.getKey());
            }
            int index = parentTA.getAttributes().size();
            TaskAttribute attr = parentTA.createAttribute(NB_TASK_REFERENCE + index);
            TaskReference taskRef = new TaskReference(task);
            taskRef.applyTo(attr);
            model.attributeChanged(parentTA);
        }
    }

    List<TaskReference> getTaskReferences() {
        TaskAttribute parentTA;
        NbTaskDataModel model = this.getModel();
        TaskData taskData = model == null ? null : model.getLocalTaskData();
        ArrayList<TaskReference> references = new ArrayList<TaskReference>();
        TaskAttribute taskAttribute = parentTA = taskData == null ? null : taskData.getRoot().getAttribute(IssueField.REFERENCES.getKey());
        if (parentTA != null) {
            for (TaskAttribute ta : parentTA.getAttributes().values()) {
                if (!ta.getId().startsWith(NB_TASK_REFERENCE)) continue;
                references.add(TaskReference.createFrom(ta));
            }
        }
        return references;
    }

    void removeTaskReference(String repositoryId, String taskId) {
        TaskData taskData;
        NbTaskDataModel model = this.getModel();
        TaskData taskData2 = taskData = model == null ? null : model.getLocalTaskData();
        if (taskData != null) {
            TaskAttribute parentTA = taskData.getRoot().getAttribute(IssueField.REFERENCES.getKey());
            if (parentTA != null) {
                for (TaskAttribute ta : parentTA.getAttributes().values()) {
                    TaskReference ref;
                    if (!ta.getId().startsWith(NB_TASK_REFERENCE) || !repositoryId.equals((ref = TaskReference.createFrom(ta)).getRepositoryId()) || !taskId.equals(ref.getTaskId())) continue;
                    parentTA.removeAttribute(ta.getId());
                    break;
                }
            }
            model.attributeChanged(parentTA);
        }
    }

    void setTaskPrivateNotes(String notes) {
        super.setPrivateNotes(notes);
        this.modelStateChanged(true);
    }

    public void setTaskDueDate(Date date, boolean persistChange) {
        super.setDueDate(date, persistChange);
        this.modelStateChanged(this.hasUnsavedChanges());
        if (persistChange) {
            this.dataChanged();
        }
    }

    public void setTaskScheduleDate(IssueScheduleInfo date, boolean persistChange) {
        super.setScheduleDate(date, persistChange);
        this.modelStateChanged(this.hasUnsavedChanges());
        if (persistChange) {
            this.dataChanged();
        }
    }

    public void setTaskEstimate(int estimate, boolean persistChange) {
        super.setEstimate(estimate, persistChange);
        this.modelStateChanged(this.hasUnsavedChanges());
        if (persistChange) {
            this.dataChanged();
        }
    }

    public void addComment(String comment, boolean closeAsFixed) {
        if (comment != null && !comment.isEmpty()) {
            String notes = this.getPrivateNotes();
            notes = notes + "\n\n" + comment;
            this.setPrivateNotes(notes);
        }
        if (closeAsFixed) {
            this.finish();
        }
        this.save();
        this.modelStateChanged(false);
        if (this.controller != null) {
            this.controller.refreshViewData();
        }
    }

    public void attachPatch(final File file, final String description) {
        if (file != null) {
            this.runWithModelLoaded(new Runnable(){
                final /* synthetic */ LocalTask this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    TaskData td;
                    NbTaskDataModel model = this.this$0.getModel();
                    TaskData taskData = td = model == null ? null : model.getLocalTaskData();
                    if (td != null) {
                        TaskAttribute parentTA = td.getRoot().getAttribute(IssueField.ATTACHMENTS.getKey());
                        if (parentTA == null) {
                            parentTA = td.getRoot().createAttribute(IssueField.ATTACHMENTS.getKey());
                        }
                        this.this$0.addAttachment(model, parentTA, file, description, null, true, true);
                        this.this$0.save();
                        this.this$0.modelStateChanged(false);
                        if (this.this$0.controller != null) {
                            this.this$0.controller.refreshViewData();
                        }
                    }
                }
            });
        }
    }

    void fireChangeEvent() {
        this.fireChanged();
    }

    private void modelStateChanged(boolean dirty) {
        if (this.controller != null) {
            this.controller.modelStateChanged(dirty);
        }
    }

    private boolean askCopyToCentralStorage(int attachmentCount) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_LocalTask_copyAttToCentralStorage_text(attachmentCount), Bundle.LBL_LocalTask_copyAttToCentralStorage_title(), 0, 3);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyFileToCentral(File file) {
        File destFolder = new File(Places.getUserDirectory().getAbsolutePath() + ("/var/tasks/mylyn/tasks/" + this.repository.getTaskRepository().getConnectorKind() + "-" + this.repository.getTaskRepository().getUrl() + "/offline/attachments").replace("/", File.separator));
        destFolder.mkdirs();
        Object object = ATTACHMENT_STORAGE_LOCK;
        synchronized (object) {
            File destFile = new File(destFolder, file.getName());
            if (destFile.exists()) {
                int i = 1;
                while (destFile.exists()) {
                    destFile = new File(destFolder, i + "_" + file.getName());
                    ++i;
                }
            }
            try {
                FileUtils.copyFile(file, destFile);
            }
            catch (IOException ex) {
                Logger.getLogger(LocalTask.class.getName()).log(Level.INFO, "Cannot copy " + file + " to " + destFile + ", will stick with the original", ex);
                destFile = file;
            }
            return destFile;
        }
    }

    class Attachment
    extends AttachmentsPanel.AbstractAttachment {
        private final TaskAttribute ta;
        private final String desc;
        private final String filename;
        private final Date date;
        private final String contentType;
        private final boolean isPatch;
        private final String uri;
        private Action deleteAction;
        private final boolean residesInCentral;

        public Attachment(TaskAttribute ta) {
            TaskAttachmentMapper taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)ta);
            this.ta = ta;
            this.desc = taskAttachment.getDescription();
            this.filename = taskAttachment.getFileName();
            this.date = taskAttachment.getCreationDate();
            this.contentType = taskAttachment.getContentType();
            this.isPatch = taskAttachment.isPatch();
            this.uri = taskAttachment.getUrl();
            Boolean inCentral = taskAttachment.getReplaceExisting();
            this.residesInCentral = Boolean.TRUE.equals(inCentral);
        }

        public String getAuthorName() {
            return "";
        }

        public String getAuthor() {
            return "";
        }

        public Date getDate() {
            return this.date;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }

        public boolean isPatch() {
            return this.isPatch;
        }

        public void getAttachementData(OutputStream os) {
            try {
                File f = Utilities.toFile((URI)new URI(this.uri));
                FileUtils.copyStreamsCloseAll(os, FileUtils.createInputStream(f));
            }
            catch (IOException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public boolean canBeDeleted() {
            return true;
        }

        public Action getDeleteAction() {
            if (this.deleteAction == null) {
                this.deleteAction = new DeleteAttachmentAction();
            }
            return this.deleteAction;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isInCentral() {
            return this.residesInCentral;
        }

        private class DeleteAttachmentAction
        extends AbstractAction {
            public DeleteAttachmentAction() {
                this.putValue("Name", Bundle.CTL_AttachmentAction_Remove());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_AttachmentAction_Remove_confirm_text(), Bundle.LBL_AttachmentAction_Remove_confirm_title(), 0, 3)) {
                    LocalTask.this.deleteAttachment(Attachment.this.ta);
                }
            }
        }
    }

    static final class TaskReference {
        private final String repositoryId;
        private final String taskId;

        public TaskReference(String repositoryId, String taskId) {
            this.repositoryId = repositoryId;
            this.taskId = taskId;
        }

        private TaskReference(Issue task) {
            this.repositoryId = task.getRepository().getId();
            this.taskId = task.getID();
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        private void applyTo(TaskAttribute attr) {
            attr.createAttribute("task.repository").setValue(this.repositoryId);
            attr.createAttribute("task.id").setValue(this.taskId);
        }

        private static TaskReference createFrom(TaskAttribute ta) {
            String repositoryId = "";
            String taskId = "";
            TaskAttribute attr = ta.getAttribute("task.repository");
            if (attr != null) {
                repositoryId = attr.getValue();
            }
            if ((attr = ta.getAttribute("task.id")) != null) {
                taskId = attr.getValue();
            }
            return new TaskReference(repositoryId, taskId);
        }
    }
}

