/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystem$Environment;
import org.openide.filesystems.FileSystemCompat;
import org.openide.filesystems.MultiFileSystem;
import org.openide.modules.PatchFor;
import org.openide.util.actions.SystemAction;

@PatchFor(value=MultiFileSystem.class)
public abstract class MultiFileSystemCompat
extends FileSystem {
    public SystemAction[] getActions() {
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> uniq = new HashSet<SystemAction>(101);
        FileSystem[] del = this.getDelegates();
        for (int i = 0; i < del.length; ++i) {
            if (del[i] == null) continue;
            SystemAction[] acts = MultiFileSystemCompat.compat(del[i]).getActions();
            for (int j = 0; j < acts.length; ++j) {
                if (!uniq.add(acts[j])) continue;
                al.add(acts[j]);
            }
        }
        return al.toArray(new SystemAction[0]);
    }

    public SystemAction[] getActions(Set<FileObject> foSet) {
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> uniq = new HashSet<SystemAction>(101);
        FileSystem[] del = this.getDelegates();
        for (int i = 0; i < del.length; ++i) {
            if (del[i] == null) continue;
            SystemAction[] acts = MultiFileSystemCompat.compat(del[i]).getActions(foSet);
            for (int j = 0; j < acts.length; ++j) {
                if (!uniq.add(acts[j])) continue;
                al.add(acts[j]);
            }
        }
        return al.toArray(new SystemAction[0]);
    }

    static FileSystemCompat compat(FileSystem fs) {
        FileSystem o = fs;
        return (FileSystemCompat)o;
    }

    @Deprecated
    public void prepareEnvironment(FileSystem$Environment env) throws EnvironmentNotSupportedException {
        FileSystem[] layers = this.getDelegates();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] == null) continue;
            try {
                MultiFileSystemCompat.compat(layers[i]).prepareEnvironment(env);
                continue;
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                // empty catch block
            }
        }
    }

    protected abstract FileSystem[] getDelegates();
}

